/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.phy;

import ea.BoundingRechteck;
import ea.Knoten;
import ea.KollisionsReagierbar;
import ea.Manager;
import ea.Raum;
import ea.Ticker;
import ea.Vektor;
import ea.internal.phy.Gravitator;
import ea.internal.phy.Passivator;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

public class Physik
extends Manager
implements Ticker {
    private static Physik physik;
    private ArrayList<Auftrag> kollisionsListe = new ArrayList();
    private CopyOnWriteArrayList<Passivator> passive = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<Gravitator> gravitatoren = new CopyOnWriteArrayList();
    private int runde = 1;

    private Physik() {
        Manager.standard.anmelden(new Ticker(){

            @Override
            public void tick() {
                for (Auftrag a : Physik.this.kollisionsListe) {
                    a.test();
                }
            }
        }, 35);
        this.anmelden(this, 1);
    }

    public static void neutralize() {
        if (physik == null) {
            return;
        }
        physik.kill();
        for (Passivator p : Physik.physik.passive) {
            p.ziel().neutralMachen();
        }
        for (Gravitator g : Physik.physik.gravitatoren) {
            g.ziel().neutralMachen();
        }
        physik = null;
    }

    public static final Physik getPhysik() {
        if (physik == null) {
            physik = new Physik();
        }
        return physik;
    }

    public void passivAnmelden(Passivator p) {
        this.passive.add(p);
    }

    public void passivAbmelden(Passivator p) {
        this.passive.remove(p);
    }

    public void aktivAnmelden(Gravitator g) {
        this.gravitatoren.add(g);
    }

    public void aktivAbmelden(Gravitator g) {
        this.gravitatoren.remove(g);
    }

    public synchronized void alleAktivenEinsetzen(Knoten k, BoundingRechteck b) {
        for (Gravitator g : this.gravitatoren) {
            if (!g.ziel().inFlaeche(b)) continue;
            k.add(g.ziel());
        }
    }

    public synchronized void alleAktivenTestenUndEinsetzen(Knoten k, BoundingRechteck b, Vektor v) {
        for (Gravitator g : this.gravitatoren) {
            if (!g.ziel().inFlaeche(b) || this.inPassivem(g.ziel().dimension().verschobeneInstanz(v))) continue;
            k.add(g.ziel());
        }
    }

    public synchronized boolean inPassivem(BoundingRechteck r) {
        for (Passivator p : this.passive) {
            if (!p.in(r)) continue;
            return true;
        }
        return false;
    }

    public synchronized void alleAktivenTestenUndEinsetzenOhne(Knoten k, BoundingRechteck b, Vektor v, Passivator p) {
        for (Gravitator g : this.gravitatoren) {
            if (!g.ziel().inFlaeche(b) || this.inPassivemAusser(g.ziel().dimension().verschobeneInstanz(v), p)) continue;
            k.add(g.ziel());
        }
    }

    public synchronized boolean inPassivemAusser(BoundingRechteck r, Passivator aus) {
        for (Passivator p : this.passive) {
            if (p.equals(aus) || !p.in(r)) continue;
            return true;
        }
        return false;
    }

    public synchronized Vektor entblocken(BoundingRechteck r) {
        for (Passivator p : this.passive) {
            if (!p.in(r)) continue;
            float x = 0.0f;
            float y = 0.0f;
            BoundingRechteck pas = p.ziel().dimension();
            if (pas.y < r.y && pas.y + pas.hoehe > r.y + r.hoehe) {
                x = r.x > pas.x ? pas.x + pas.breite - r.x : pas.x - (r.x + r.breite);
            } else {
                y = r.y > pas.y ? pas.y + pas.hoehe - r.y : pas.y - (r.y + r.hoehe);
            }
            Vektor retA = new Vektor(x, y);
            return retA.summe(this.entblocken(r.verschobeneInstanz(retA), retA));
        }
        return Vektor.NULLVEKTOR;
    }

    private synchronized Vektor entblocken(BoundingRechteck r, Vektor letzte) {
        for (Passivator p : this.passive) {
            if (!p.in(r)) continue;
            float x = 0.0f;
            float y = 0.0f;
            BoundingRechteck pas = p.ziel().dimension();
            if (letzte.x != 0.0f) {
                x = letzte.x > 0.0f ? pas.x + pas.breite - r.x : pas.x - (r.x + r.breite);
            } else {
                y = letzte.y > 0.0f ? pas.y + pas.hoehe - r.y : pas.y - (r.y + r.hoehe);
            }
            Vektor retA = new Vektor(x, y);
            return retA.summe(this.entblocken(r.verschobeneInstanz(retA), retA));
        }
        return Vektor.NULLVEKTOR;
    }

    public void anmelden(KollisionsReagierbar k, Raum r1, Raum r2) {
        this.anmelden(k, r1, r2, 0);
    }

    public void anmelden(KollisionsReagierbar k, Raum r1, Raum r2, int code) {
        if (r2 instanceof Knoten) {
            Raum r = r1;
            r1 = r2;
            r2 = r;
        }
        this.kollisionsListe.add(new Auftrag(r1, r2, k, code));
    }

    public void entfernen(KollisionsReagierbar k) {
        ArrayList<Auftrag> out = new ArrayList<Auftrag>();
        for (Auftrag a : this.kollisionsListe) {
            if (!a.benachrichtigt(k)) continue;
            out.add(a);
        }
        for (Auftrag a : out) {
            this.kollisionsListe.remove(a);
        }
    }

    @Override
    public void tick() {
        for (Gravitator g : this.gravitatoren) {
            g.tick(this.runde);
        }
        this.runde = this.runde == 10 ? 1 : ++this.runde;
    }

    private final class Auftrag {
        private final Raum r1;
        private final Raum r2;
        private final KollisionsReagierbar listener;
        private final int code;

        public Auftrag(Raum r1, Raum r2, KollisionsReagierbar k, int code) {
            this.r1 = r1;
            this.r2 = r2;
            this.listener = k;
            this.code = code;
        }

        public void test() {
            if (this.r1.schneidet(this.r2) && this.r1.sichtbar() && this.r2.sichtbar()) {
                this.listener.kollision(this.code);
            }
        }

        public boolean benachrichtigt(KollisionsReagierbar k) {
            return this.listener == k;
        }
    }
}

