/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.phy;

import ea.BoundingRechteck;
import ea.FallReagierbar;
import ea.Knoten;
import ea.Raum;
import ea.StehReagierbar;
import ea.Vektor;
import ea.internal.phy.Physik;
import ea.internal.phy.PhysikClient;
import ea.internal.util.Logger;

public class Passivator
extends PhysikClient {
    private final Physik physik = Physik.getPhysik();
    private volatile Knoten system = new Knoten();
    private float remainderX = 0.0f;
    private float remainderY = 0.0f;

    public Passivator(Raum ziel) {
        super(ziel);
        this.system.add(ziel);
        this.physik.passivAnmelden(this);
    }

    @Override
    public boolean bewegen(Vektor v) {
        this.xVersch(v.x);
        this.yVersch(v.y);
        return true;
    }

    @Override
    public void aufloesen() {
        this.physik.passivAbmelden(this);
    }

    @Override
    public boolean sprung(int kraft) {
        Logger.error("Achtung! Ein fuer die Physik passives Objekt wurde zum Sprung gezwungen. Es passiert nichts.");
        return false;
    }

    @Override
    public void schwerkraftAktivSetzen(boolean aktiv) {
        Logger.error("Achtung! Das Objekt, bei dem der Einfluss der Schwerkraft gesetzt werden sollte, ist ein passives Objekt. Folglich macht der Aufruf dieser Methode keinen Sinn. Dafuer muesste das entsprechende Objekt ein Aktiv-Objekt sein!");
    }

    @Override
    public void kritischeTiefeSetzen(int tiefe) {
        Logger.error("Achtung! Das Raum-Objekt, dem eine kritische Tiefe gegeben werden sollte, ist kein Aktiv-Objekt, sondern passiv! Bitte erst dieses Objekt aktiv machen, dann diese Methode aufrufen!");
    }

    @Override
    public void fallReagierbarAnmelden(FallReagierbar f, int tiefe) {
        Logger.error("Achtung! Das Raum-Objekt, dem ein FallReagierbar-Listener zugewiesen werden sollte, ist kein Aktiv-Objekt, sondern passiv! Bitte erst dieses Objekt aktiv machen, dann diese Methode aufrufen!");
    }

    @Override
    public void stehReagierbarAnmelden(StehReagierbar s) {
        Logger.error("Achtung! Das Raum-Objekt, dem ein StehReagierbar-Listener zugewiesen werden sollte, ist kein Aktiv-Objekt, sonder ein passives Objekt! Bitte erst dieses Objekt aktiv machen, dann diese Methode aufrufen!");
    }

    @Override
    public boolean steht() {
        Logger.error("Achtung! Das Raum-Objekt, an dem das Stehen erfragt werden sollte, ist kein Aktiv-Objekt, sonder ein passives Objekt! Bitte erst dieses Objekt aktiv machen, dann diese Methode aufrufen! Solange ist die Rueckgabe immer false.");
        return false;
    }

    @Override
    public void schwerkraftSetzen(int schwerkraft) {
        Logger.error("Achtung! Ein passives Raum-Objekt sollte eine neue Schwerkraft verpasst bekommen. Das ist nicht moeglich. Nur Aktiv-Objekte koennen eine Schwerkraft gesetzt bekommen.");
    }

    @Override
    public void impulsHinzunehmen(Vektor impuls) {
        Logger.error("Passivobjekte unterst\u00fctzen leider keine Impulsrechnung. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void geschwindigkeitHinzunehmen(Vektor geschwindigkeit) {
        Logger.error("Passivobjekte unterst\u00fctzen leider keine Geschwindigkeit. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public float getLuftwiderstandskoeffizient() {
        Logger.error("Passivobjekte unterst\u00fctzen leider keinen Luftwiderstand. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
        return 0.0f;
    }

    @Override
    public boolean istBeeinflussbar() {
        Logger.error("Passivobjekte unterst\u00fctzen leider keinen Beeinflussbarkeit. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
        return false;
    }

    @Override
    public float getMasse() {
        Logger.error("Passivobjekte unterst\u00fctzen leider keine Masse. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
        return 0.0f;
    }

    @Override
    public Vektor getForce() {
        Logger.error("Passivobjekte unterst\u00fctzen leider keine Kraftrechnung. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
        return null;
    }

    @Override
    public void luftwiderstandskoeffizientSetzen(float luftwiderstandskoeffizient) {
        Logger.error("Passivobjekte unterst\u00fctzen leider keinen Luftwiderstand. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void beeinflussbarSetzen(boolean beeinflussbar) {
        Logger.error("Passivobjekte unterst\u00fctzen leider keinen Beeinflussbarkeit. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void masseSetzen(float masse) {
        Logger.error("Passivobjekte unterst\u00fctzen leider keine Masse. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void kraftSetzen(Vektor kraft) {
        Logger.error("Passivobjekte unterst\u00fctzen leider keine Kraftrechnung. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void geschwindigkeitSetzen(Vektor geschwindigkeit) {
        Logger.error("Passivobjekte unterst\u00fctzen leider keine Geschwindigkeit. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void einfluesseZuruecksetzen() {
        Logger.error("Passivobjekte unterst\u00fctzen leider keine Einfl\u00fcsse. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void kraftAnwenden(Vektor kraft, float t_kraftuebertrag) {
        Logger.error("Passivobjekte unterst\u00fctzen leider keine Kraftrechnung. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    public void xVersch(float dX) {
        int max;
        int z;
        if ((dX += this.remainderX) > 0.0f) {
            z = 1;
            max = (int)dX;
        } else if (dX < 0.0f) {
            z = -1;
            max = (int)(-dX);
        } else {
            this.remainderX = dX;
            return;
        }
        Vektor v = new Vektor(z, 0.0f);
        Vektor testV = new Vektor(z, -1.0f);
        for (int i = 0; i < max; ++i) {
            this.system.leerenOhnePhysikAbmelden();
            this.system.add(this.ziel);
            BoundingRechteck test = this.ziel.dimension().verschErhoeht(testV, 1);
            this.physik.alleAktivenTestenUndEinsetzen(this.system, test, v);
            this.system.verschieben(v);
            dX -= (float)z;
        }
        this.remainderX = dX;
    }

    public void yVersch(float dY) {
        int max;
        int z;
        float originalY = dY;
        if ((dY += this.remainderY) > 0.0f) {
            z = 1;
            max = (int)dY;
        } else if (dY < 0.0f) {
            z = -1;
            max = (int)(-dY);
        } else {
            this.remainderY = dY;
            return;
        }
        Vektor v = new Vektor(0.0f, z);
        for (int i = 0; i < max; ++i) {
            this.system.leerenOhnePhysikAbmelden();
            this.system.add(this.ziel);
            BoundingRechteck test = this.ziel.dimension().verschErhoeht(Vektor.OBEN, 1);
            this.physik.alleAktivenTestenUndEinsetzenOhne(this.system, test, v, this);
            this.system.verschieben(v);
            dY -= (float)z;
        }
        this.remainderY = dY;
    }

    public boolean in(BoundingRechteck r) {
        return r.schneidetBasic(this.ziel.dimension());
    }
}

