/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.phy;

import ea.FallDummy;
import ea.FallReagierbar;
import ea.KreisCollider;
import ea.Manager;
import ea.Raum;
import ea.StehReagierbar;
import ea.Ticker;
import ea.Vektor;
import ea.internal.phy.CollisionHandling;
import ea.internal.phy.PhysikClient;
import ea.internal.phy.StehDummy;
import ea.internal.util.Logger;

public class MechanikClient
extends PhysikClient
implements Ticker {
    private static float THRESHOLD = 1.0E-5f;
    static final float DELTA_T = 0.040000003f;
    public static Manager MECH_TIMER = new Manager();
    private static float METER_PRO_PIXEL = 0.001f;
    private FallReagierbar fallListener = FallDummy.getDummy();
    private StehReagierbar sListener = StehDummy.getDummy();
    private int kritischeTiefe = 0;
    private Vektor velocity;
    private Vektor lastVelocity;
    private Vektor force;
    private float masse = 30.0f;
    private boolean beeinflussbar = true;
    private float luftwiderstandskoeffizient = 40.0f;
    private float elastizitaet = 0.34f;
    private KreisCollider collider;

    public static void tresholdSetzen(float threshold) {
        THRESHOLD = threshold;
    }

    public MechanikClient(Raum ziel) {
        super(ziel);
        this.collider = ziel.dimension().umschliessenderKreis();
        this.einfluesseZuruecksetzen();
        MECH_TIMER.anmelden(this, 40);
        CollisionHandling.anmelden(this);
    }

    public static void setzeMeterProPixel(float meterpropixel) {
        if (meterpropixel <= 0.0f) {
            throw new IllegalArgumentException("Die Anzahl an Metern pro Pixel muss positiv sein!");
        }
        if (MECH_TIMER.hatAktiveTicker()) {
            throw new RuntimeException("Die Anzahl von Metern pro Pixel kann nach der Nutzung der Physik nicht mehr ge\u00e4ndert werden!");
        }
        METER_PRO_PIXEL = meterpropixel;
    }

    public Vektor getVelocity() {
        return this.velocity;
    }

    @Override
    public void tick() {
        Vektor dif;
        Vektor momentanekraft = this.force.summe(this.velocity.gegenrichtung().multiplizieren(this.luftwiderstandskoeffizient * this.velocity.laenge()));
        this.velocity = this.velocity.summe(momentanekraft.multiplizieren(0.040000003f / this.masse));
        this.bewegen(this.velocity.multiplizieren(0.040000003f).teilen(METER_PRO_PIXEL));
        if (this.ziel.positionY() > this.kritischeTiefe) {
            this.fallListener.fallReagieren();
        }
        if ((dif = this.velocity.differenz(this.lastVelocity)).manhattanLength() < THRESHOLD && dif.manhattanLength() != 0.0f) {
            System.out.println("T");
            this.velocity = Vektor.NULLVEKTOR;
        }
        this.lastVelocity = this.velocity;
    }

    @Override
    public boolean bewegen(Vektor v) {
        this.ziel.verschieben(v);
        this.collider.verschieben(v);
        return false;
    }

    @Override
    public void aufloesen() {
        CollisionHandling.abmelden(this);
    }

    @Override
    @Deprecated
    public boolean sprung(int kraft) {
        this.impulsHinzunehmen(new Vektor(60.0f, 0.0f));
        return true;
    }

    @Override
    @Deprecated
    public void schwerkraftAktivSetzen(boolean aktiv) {
        this.force = aktiv ? new Vektor(0.0f, 10.0f) : Vektor.NULLVEKTOR;
    }

    @Override
    public void kritischeTiefeSetzen(int tiefe) {
        this.kritischeTiefe = tiefe;
    }

    @Override
    public void fallReagierbarAnmelden(FallReagierbar f, int tiefe) {
        this.fallListener = f;
        this.kritischeTiefeSetzen(tiefe);
    }

    @Override
    public void stehReagierbarAnmelden(StehReagierbar s) {
        this.sListener = s;
    }

    @Override
    public boolean steht() {
        return false;
    }

    @Override
    @Deprecated
    public void schwerkraftSetzen(int schwerkraft) {
        this.kraftSetzen(new Vektor(0.0f, 0.01f * (float)schwerkraft));
    }

    @Override
    public void impulsHinzunehmen(Vektor impuls) {
        this.velocity = this.velocity.summe(impuls.teilen(this.masse));
    }

    @Override
    public void geschwindigkeitHinzunehmen(Vektor geschwindigkeit) {
        this.velocity = this.velocity.summe(geschwindigkeit);
    }

    @Override
    public float getLuftwiderstandskoeffizient() {
        return this.luftwiderstandskoeffizient;
    }

    @Override
    public boolean istBeeinflussbar() {
        return this.beeinflussbar;
    }

    @Override
    public float getMasse() {
        return this.masse;
    }

    @Override
    public Vektor getForce() {
        return this.force;
    }

    public float getElastizitaet() {
        return this.elastizitaet;
    }

    public void setElastizitaet(float elastizitaet) {
        if (elastizitaet < 0.0f) {
            Logger.error("Die Elastizit\u00e4t eines Objekts kann nicht negativ sein. Die Eingabe war " + elastizitaet + " .");
            return;
        }
        this.elastizitaet = elastizitaet;
    }

    @Override
    public void luftwiderstandskoeffizientSetzen(float luftwiderstandskoeffizient) {
        if (luftwiderstandskoeffizient < 0.0f) {
            throw new IllegalArgumentException("Der Luftwiderstandskoeffizient darf nicht negativ sein! Eingabe war " + luftwiderstandskoeffizient + ".");
        }
        this.luftwiderstandskoeffizient = luftwiderstandskoeffizient;
    }

    @Override
    public void beeinflussbarSetzen(boolean beeinflussbar) {
        this.beeinflussbar = beeinflussbar;
    }

    @Override
    public void masseSetzen(float masse) {
        this.masse = masse;
    }

    @Override
    public void kraftSetzen(Vektor kraft) {
        this.force = kraft;
    }

    @Override
    public void geschwindigkeitSetzen(Vektor geschwindigkeit) {
        this.velocity = geschwindigkeit;
    }

    @Override
    public void einfluesseZuruecksetzen() {
        this.force = Vektor.NULLVEKTOR;
        this.velocity = Vektor.NULLVEKTOR;
        this.lastVelocity = Vektor.NULLVEKTOR;
    }

    @Override
    public void kraftAnwenden(Vektor kraft, float t_kraftuebertrag) {
        this.impulsHinzunehmen(kraft.multiplizieren(t_kraftuebertrag));
    }

    public KreisCollider collider() {
        return this.collider;
    }
}

