/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.phy;

import ea.BoundingRechteck;
import ea.Manager;
import ea.Punkt;
import ea.Ticker;
import ea.Vektor;
import ea.internal.phy.MechanikClient;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;

public class CollisionHandling {
    private static ArrayList<Auftrag> liste;
    private static Queue<Collision> colQueue;

    public static void anmelden(MechanikClient c) {
        liste.add(new Auftrag(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void abmelden(MechanikClient c) {
        Auftrag a = null;
        for (Auftrag auf : liste) {
            if (auf.parent != c) continue;
            a = auf;
            break;
        }
        if (a != null) {
            ArrayList<Auftrag> arrayList = liste;
            synchronized (arrayList) {
                liste.remove(a);
            }
        }
    }

    static {
        Manager.standard.anmelden(new CollisionRoutine(), 40);
        new CollisionConsumer().start();
        liste = new ArrayList();
        colQueue = new LinkedList<Collision>();
    }

    private static class Collision {
        final Auftrag[] clients;

        public Collision(Auftrag[] clients) {
            this.clients = clients;
        }

        public void abarbeiten() {
            MechanikClient c1 = this.clients[0].parent;
            MechanikClient c2 = this.clients[1].parent;
            if (c1.istBeeinflussbar() && c2.istBeeinflussbar()) {
                Collision.doppelaktivlogik(c1, c2);
            }
            if (c1.istBeeinflussbar() && !c2.istBeeinflussbar()) {
                Collision.ungleichlogik(c1, c2);
            }
            if (!c1.istBeeinflussbar() && c2.istBeeinflussbar()) {
                Collision.ungleichlogik(c2, c1);
            }
        }

        public static void doppelaktivlogik(MechanikClient c1, MechanikClient c2) {
            do {
                c1.bewegen(c1.getVelocity().gegenrichtung().multiplizieren(0.040000003f));
                c2.bewegen(c2.getVelocity().gegenrichtung().multiplizieren(0.040000003f));
            } while (c1.ziel().schneidet(c2.ziel()));
            Vektor v1 = c1.getVelocity();
            Vektor v2 = c2.getVelocity();
            Punkt s1 = c1.ziel().zentrum();
            Punkt s2 = c2.ziel().zentrum();
            float m1 = c1.getMasse();
            float m2 = c2.getMasse();
            Vektor normale = s1.nach(s2).normiert();
            Vektor v1p = normale.multiplizieren(v1.skalarprodukt(normale));
            Vektor v2p = normale.multiplizieren(v2.skalarprodukt(normale));
            Vektor v1s = v1.differenz(v1p);
            Vektor v2s = v2.differenz(v2p);
            Vektor v1pNeu = v1p.multiplizieren(m1).summe(v2p.multiplizieren(2.0f).differenz(v1p).multiplizieren(m2)).teilen(m1 + m2);
            Vektor v2pNeu = v2p.multiplizieren(m2).summe(v1p.multiplizieren(2.0f).differenz(v2p).multiplizieren(m1)).teilen(m1 + m2);
            c1.geschwindigkeitSetzen(v1pNeu.summe(v1s));
            c2.geschwindigkeitSetzen(v2pNeu.summe(v2s));
        }

        public static void ungleichlogik(MechanikClient beeinflussbar, MechanikClient unbeeinflussbar) {
            do {
                beeinflussbar.bewegen(beeinflussbar.getVelocity().gegenrichtung().multiplizieren(0.040000003f));
            } while (beeinflussbar.ziel().schneidet(unbeeinflussbar.ziel()));
            Punkt zmov = beeinflussbar.ziel().zentrum();
            BoundingRechteck bounds = unbeeinflussbar.ziel().dimension();
            Vektor vneu = beeinflussbar.getVelocity().multiplizieren(unbeeinflussbar.getElastizitaet());
            vneu = zmov.realX() <= bounds.x + bounds.breite / 2.0f ? (zmov.realX() > bounds.x ? new Vektor(vneu.x, -vneu.y) : new Vektor(-vneu.x, vneu.y)) : (zmov.realX() < bounds.x + bounds.breite ? new Vektor(vneu.x, -vneu.y) : new Vektor(-vneu.x, vneu.y));
            beeinflussbar.geschwindigkeitSetzen(vneu);
        }
    }

    private static class Auftrag {
        final MechanikClient parent;

        Auftrag(MechanikClient p) {
            this.parent = p;
        }

        public boolean serioushit(Auftrag a) {
            return this.parent.ziel().schneidet(a.parent.ziel());
        }

        public boolean probablehit(Auftrag a) {
            return this.parent.collider().schneidet(a.parent.collider());
        }
    }

    private static class CollisionRoutine
    implements Ticker {
        private CollisionRoutine() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tick() {
            ArrayList arrayList = liste;
            synchronized (arrayList) {
                int i = 0;
                for (Auftrag a : liste) {
                    int j = 0;
                    for (Auftrag a2 : liste) {
                        if (j > i && a.probablehit(a2) && a.serioushit(a2)) {
                            Queue queue = colQueue;
                            synchronized (queue) {
                                colQueue.add(new Collision(new Auftrag[]{a, a2}));
                                colQueue.notifyAll();
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    private static class CollisionConsumer
    extends Thread {
        private CollisionConsumer() {
            super("Collision Handling");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!CollisionConsumer.interrupted()) {
                Queue queue = colQueue;
                synchronized (queue) {
                    while (colQueue.isEmpty()) {
                        try {
                            colQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    ((Collision)colQueue.remove()).abarbeiten();
                }
            }
        }
    }
}

