/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class DiscoveryServer
extends Thread {
    private static DiscoveryServer server;
    private DatagramSocket socket;

    private DiscoveryServer() {
    }

    public static void startServer() {
        if (server == null) {
            server = new DiscoveryServer();
            server.start();
        }
    }

    public static void stopServer() {
        if (server == null) {
            return;
        }
        server.interrupt();
        try {
            server.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        server = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int bufferSize = 8192;
            this.socket = new DatagramSocket(15035, InetAddress.getByName("0.0.0.0"));
            this.socket.setBroadcast(true);
            while (!this.isInterrupted()) {
                byte[] recvBuf = new byte[bufferSize];
                DatagramPacket receivePacket = new DatagramPacket(recvBuf, recvBuf.length);
                this.socket.receive(receivePacket);
                String cmd = new String(receivePacket.getData()).trim();
                if (!cmd.startsWith("EA_DISCOVERY_REQ")) continue;
                byte[] sendData = "EA_DISCOVERY_RESP".getBytes();
                DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, receivePacket.getAddress(), receivePacket.getPort());
                this.socket.send(sendPacket);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (this.socket != null) {
                this.socket.close();
            }
        }
    }

    @Override
    public void interrupt() {
        if (this.socket != null) {
            this.socket.close();
        }
        super.interrupt();
    }
}

