/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.collision;

import ea.Farbe;
import ea.Kreis;
import ea.Punkt;
import ea.Raum;
import ea.Vektor;
import ea.internal.collision.BoxCollider;
import ea.internal.collision.Collider;
import ea.internal.collision.ColliderGroup;

public class SphereCollider
extends Collider {
    final float durchmesser;
    Kreis modelsphere;

    public SphereCollider(float durchmesser) {
        this(durchmesser, Vektor.NULLVEKTOR);
    }

    public SphereCollider(float durchmesser, Vektor offset) {
        this(durchmesser, offset, 8);
    }

    public SphereCollider(float durchmesser, Vektor offset, int genauigkeit) {
        this.offset = offset;
        this.durchmesser = durchmesser;
        this.modelsphere = new Kreis(0, 0, durchmesser, genauigkeit);
    }

    @Override
    public boolean verursachtCollision(Punkt positionThis, Punkt positionOther, Collider collider) {
        if (collider instanceof SphereCollider) {
            return Collider.spheresphereCollision(this, (SphereCollider)collider, positionThis, positionOther);
        }
        if (collider instanceof BoxCollider) {
            return Collider.sphereboxCollision(this, (BoxCollider)collider, positionThis, positionOther);
        }
        if (collider instanceof ColliderGroup) {
            return collider.verursachtCollision(positionOther, positionThis, this);
        }
        return false;
    }

    @Override
    public boolean istNullCollider() {
        return false;
    }

    @Override
    public Raum visualize(Punkt p, Farbe color) {
        Kreis k = this.ausDiesem(p);
        k.farbeSetzen(color);
        return k;
    }

    @Override
    public Collider clone() {
        Collider newSC = this.modelsphere.erzeugeCollider();
        newSC.offsetSetzen(this.offset);
        return new SphereCollider(this.durchmesser, this.offset);
    }

    public Kreis ausDiesem(Punkt position) {
        return new Kreis(position.x + this.offset.x, position.y + this.offset.y, this.modelsphere.radius() * 2.0f);
    }
}

