/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.collision;

import ea.Farbe;
import ea.Knoten;
import ea.Punkt;
import ea.Raum;
import ea.internal.collision.Collider;
import java.util.ArrayList;
import java.util.List;

public class ColliderGroup
extends Collider {
    private List<Collider> colliders = new ArrayList<Collider>();

    @Override
    public boolean verursachtCollision(Punkt positionThis, Punkt positionOther, Collider collider) {
        Punkt positionMitOffset = positionThis.verschobenerPunkt(this.offset);
        for (Collider c : this.colliders) {
            if (!c.verursachtCollision(positionMitOffset, positionOther, collider)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean istNullCollider() {
        return false;
    }

    @Override
    public Raum visualize(Punkt p, Farbe color) {
        Punkt positionMitOffset = p.verschobenerPunkt(this.offset);
        Knoten ret = new Knoten();
        for (Collider c : this.colliders) {
            ret.add(c.visualize(positionMitOffset, color));
        }
        return ret;
    }

    @Override
    public Collider clone() {
        ColliderGroup group = new ColliderGroup();
        for (Collider c : this.colliders) {
            group.addCollider(c.clone());
        }
        return group;
    }

    public void addCollider(Collider c) {
        this.colliders.add(c);
    }
}

