/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.collision;

import ea.Dreieck;
import ea.Farbe;
import ea.Punkt;
import ea.Raum;
import ea.Vektor;
import ea.internal.collision.BoxCollider;
import ea.internal.collision.SphereCollider;

public abstract class Collider
implements Cloneable {
    protected Vektor offset = Vektor.NULLVEKTOR;

    public static boolean boxboxCollision(BoxCollider b1, BoxCollider b2, Punkt p1, Punkt p2) {
        return b2.offset.y + p2.y < p1.y + b1.offset.y + b1.diagonale.y && p2.y + b2.offset.y + b2.diagonale.y > p1.y + b1.offset.y && b2.offset.x + p2.x + b2.diagonale.x > p1.x + b2.offset.x && b2.offset.x + p2.x < p1.x + b1.offset.x + b1.diagonale.x;
    }

    public static boolean spheresphereCollision(SphereCollider s1, SphereCollider s2, Punkt p1, Punkt p2) {
        float r1 = s1.durchmesser / 2.0f;
        float r2 = s2.durchmesser / 2.0f;
        float dx = s1.offset.x + p1.x + r1 - (s2.offset.x + p2.x + r2);
        float dy = s1.offset.y + p1.y + r1 - (s2.offset.y + p2.y + r2);
        float summeRadien = (s1.durchmesser + s2.durchmesser) / 2.0f;
        return dx * dx + dy * dy <= summeRadien * summeRadien;
    }

    public static boolean sphereboxCollision(SphereCollider sphere, BoxCollider box, Punkt ps, Punkt pb) {
        sphere.modelsphere.positionSetzen(ps.verschobenerPunkt(sphere.offset));
        for (Dreieck d : sphere.modelsphere.formen()) {
            Punkt[] punkte = d.punkte();
            for (int i = 0; i < punkte.length; ++i) {
                if (!(punkte[i].realX() >= box.offset.x + pb.x) || !(punkte[i].realY() >= box.offset.y + pb.y) || !(punkte[i].realX() <= box.offset.x + pb.x + box.diagonale.x) || !(punkte[i].realY() <= box.offset.y + pb.y + box.diagonale.y)) continue;
                return true;
            }
        }
        return false;
    }

    public final void offsetSetzen(Vektor os) {
        this.offset = os;
    }

    public final Vektor offset() {
        return this.offset;
    }

    public abstract boolean verursachtCollision(Punkt var1, Punkt var2, Collider var3);

    public abstract boolean istNullCollider();

    public abstract Raum visualize(Punkt var1, Farbe var2);

    public abstract Collider clone();
}

