/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.ani;

import ea.AnimationsEndeReagierbar;
import ea.AnimationsManager;
import ea.Manager;
import ea.Punkt;
import ea.Raum;
import ea.Vektor;
import ea.internal.ani.Animierer;
import ea.internal.util.Logger;

public class GeradenAnimierer
extends Animierer {
    private final Vektor bewegung;
    private final int ende;

    public GeradenAnimierer(Raum ziel, Punkt richtung, int geschwindigkeit, int dauer, Manager m, AnimationsEndeReagierbar listener) {
        super(ziel, false, m, listener);
        this.bewegung = new Vektor(ziel.zentrum(), richtung).teilen(AnimationsManager.intervall((float)geschwindigkeit / 5.0f));
        if (dauer <= 0) {
            Logger.error("Die Dauer fuer die Geraden-Animation kann nie 0 oder negativ sein!!!");
            this.ende = 0;
        } else {
            this.ende = dauer / 5;
        }
    }

    @Override
    public void animationsSchritt() {
        this.ziel.bewegen(this.bewegung);
        if (this.count == this.ende) {
            this.beenden();
        }
    }
}

