/*
 * Decompiled with CFR 0.152.
 */
package ea.edu.mine;

import ea.Farbe;
import ea.Figur;
import ea.MausReagierbar;
import ea.Punkt;
import ea.Raum;
import ea.Rechteck;
import ea.RechtsKlickReagierbar;
import ea.Text;
import ea.edu.mine.Spiegel;
import ea.internal.util.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class FieldE {
    private Text text;
    private Rechteck aussen;
    private Rechteck innen;
    private Figur fig;
    private Object aim;
    private Method linksclick;
    private Method rechtsclick;

    public FieldE(int x, int y, int laenge) {
        if (laenge < 10) {
            Logger.error("ACHTUNG! Die Laenge dieses Feldes ist laecherlich klein (" + laenge + " Pixel).");
            Logger.error("Ein groesseres stellt die Funktionsfaehigkeit sicher.");
        }
        Spiegel s = Spiegel.getSpiegel();
        this.aussen = new Rechteck(x, y, laenge, laenge);
        this.aussen.farbeSetzen(new Farbe(30, 30, 30));
        this.innen = new Rechteck(x + 2, y + 2, laenge - 4, laenge - 4);
        this.innen.farbeSetzen(new Farbe(60, 60, 60));
        this.text = new Text("", (float)(x + 3), y + 3);
        s.wurzel.add(this.aussen, this.innen, this.text);
        this.aim = this;
        Method[] meth = this.aim.getClass().getMethods();
        for (int i = 0; i < meth.length; ++i) {
            if (meth[i].getName().equals("linksKlick")) {
                this.linksclick = meth[i];
                continue;
            }
            if (!meth[i].getName().equals("rechtsKlick")) continue;
            this.rechtsclick = meth[i];
        }
        s.maus().mausReagierbarAnmelden(new MausReagierbar(){

            @Override
            public void mausReagieren(int code) {
                FieldE.this.klick();
            }
        }, this.aussen);
        s.maus().rechtsKlickReagierbarAnmelden(new RechtsKlickReagierbar(){

            @Override
            public void rechtsKlickReagieren(Punkt p) {
                int x = p.x();
                int y = p.y();
                if (FieldE.this.aussen.dimension().istIn(new Punkt(x, y))) {
                    try {
                        FieldE.this.rechtsclick.invoke(FieldE.this.aim, new Object[0]);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.error("Achtung! Der Zugriff auf die Methode fuer On-Klicks hat nicht funktioniert. BUG!");
                    }
                    catch (InvocationTargetException ex) {
                        Logger.error("Achtung! Das Objekt, an dem die Methode aufzurufen war, besass selbige nicht. BUG!");
                    }
                }
            }
        });
    }

    private void klick() {
        try {
            this.linksclick.invoke(this.aim, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Logger.error("Achtung! Der Zugriff auf die Methode fuer On-Klicks hat nicht funktioniert. BUG!");
        }
        catch (InvocationTargetException ex) {
            Logger.error("Achtung! Das Objekt, an dem die Methode aufzurufen war, besass selbige nicht. BUG!");
        }
    }

    public void fuellFarbeSetzen(String farbe) {
        this.innen.farbeSetzen(farbe);
    }

    public void randFarbeSetzen(String farbe) {
        this.aussen.farbeSetzen(farbe);
    }

    public void textFarbeSetzen(String farbe) {
        this.text.farbeSetzen(farbe);
    }

    public void textSetzen(String inhalt) {
        this.text.sichtbarSetzen(false);
        this.text.inhaltSetzen(inhalt);
        this.text.groesseSetzen(40);
        while (!this.innen.dimension().umschliesst(this.text.dimension()) && this.text.groesse() > 10) {
            this.text.groesseSetzen(this.text.groesse() - 1);
        }
        this.text.mittelpunktSetzen(this.aussen.mittelPunkt());
        this.text.sichtbarSetzen(true);
    }

    public void figurEinsetzen(String datei) {
        if (!datei.endsWith(".eaf")) {
            Logger.error("Achtung! Der eingegebene Dateiname endet nicht mit .eaf!");
            return;
        }
        if (this.fig != null) {
            Spiegel.getSpiegel().wurzel.entfernen(this.fig);
        }
        this.fig = new Figur(0.0f, 0.0f, datei);
        this.fig.faktorSetzen(1);
        do {
            this.fig.faktorSetzen(this.fig.animation()[0].faktor() + 1);
            this.fig.mittelpunktSetzen(this.aussen.mittelPunkt());
        } while (this.aussen.dimension().umschliesst(this.fig.dimension()));
        this.fig.faktorSetzen(this.fig.animation()[0].faktor() - 1);
        this.fig.mittelpunktSetzen(this.aussen.mittelPunkt());
        Spiegel.getSpiegel().wurzel.add((Raum)this.fig);
    }

    public void figurEntfernen() {
        if (this.fig == null) {
            return;
        }
        Spiegel.getSpiegel().wurzel.entfernen(this.fig);
        this.fig = null;
    }
}

