/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.BoundingRechteck;
import ea.Farbe;
import ea.Leuchtend;
import ea.Manager;
import ea.Punkt;
import ea.Raum;
import ea.internal.collision.Collider;
import ea.internal.gui.Fenster;
import ea.internal.util.Logger;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class Text
extends Raum
implements Leuchtend {
    private static final long serialVersionUID = -2145724725115670955L;
    private static Font[] eigene;
    protected int groesse;
    protected int schriftart;
    protected String inhalt;
    protected Font font;
    protected Color farbe;
    private Color alte;
    private boolean leuchtet = false;
    private int leuchtzaehler;
    private Anker anker = Anker.LINKS;

    public Text(String inhalt, float x, float y, String fontName) {
        this(inhalt, x, y, fontName, 24);
    }

    public Text(String inhalt, float x, float y, String fontName, int schriftGroesse) {
        this(inhalt, x, y, fontName, schriftGroesse, 0, "Weiss");
    }

    public Text(String inhalt, float x, float y, String fontName, int schriftGroesse, int schriftart, String farbe) {
        this.inhalt = inhalt;
        this.position = new Punkt(x, y);
        this.groesse = schriftGroesse;
        this.farbe = Text.zuFarbeKonvertieren(farbe);
        this.schriftart = schriftart >= 0 && schriftart <= 3 ? schriftart : 0;
        this.setzeFont(fontName);
        super.leuchterAnmelden(this);
    }

    public void setzeFont(String fontName) {
        Font base = null;
        for (int i = 0; i < eigene.length; ++i) {
            if (!eigene[i].getName().equals(fontName)) continue;
            base = eigene[i];
            break;
        }
        if (base != null) {
            this.font = base.deriveFont(this.schriftart, this.groesse);
        } else {
            if (!Manager.fontExistiert(fontName)) {
                fontName = "SansSerif";
                Logger.error("Achtung! Die gewuenschte Schriftart existiert nicht im Font-Verzeichnis dieses PC! Wurde der Name falsch geschrieben? Oder existiert der Font nicht?");
            }
            this.font = new Font(fontName, this.schriftart, this.groesse);
        }
    }

    public Text(String inhalt, float x, float y, int schriftGroesse) {
        this(inhalt, x, y, "SansSerif", schriftGroesse, 0, "Weiss");
    }

    public Text(String inhalt, float x, float y) {
        this(inhalt, x, y, "SansSerif", 24, 0, "Weiss");
    }

    public Text(float x, float y, String inhalt) {
        this(inhalt, x, y, "SansSerif", 24, 0, "Weiss");
    }

    public Text(int x, int y, int schriftGroesse, String inhalt) {
        this(inhalt, x, y, "SansSerif", schriftGroesse, 0, "Weiss");
    }

    private static void fontsEinbauen(ArrayList<File> liste, File akt) {
        File[] files = akt.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].equals(akt)) {
                    Logger.error("Das Sub-Directory war das Directory selbst. Das darf nicht passieren!");
                    continue;
                }
                if (files[i].isDirectory()) {
                    Text.fontsEinbauen(liste, files[i]);
                }
                if (!files[i].getName().toLowerCase().endsWith(".ttf")) continue;
                liste.add(files[i]);
            }
        }
    }

    public static Font holeFont(String fontName) {
        Font base = null;
        for (int i = 0; i < eigene.length; ++i) {
            if (!eigene[i].getName().equals(fontName)) continue;
            base = eigene[i];
            break;
        }
        if (base != null) {
            return base;
        }
        if (!Manager.fontExistiert(fontName)) {
            fontName = "SansSerif";
            Logger.error("Achtung! Die gewuenschte Schriftart existiert weder als geladene Sonderdatei noch im Font-Verzeichnis dieses PC! Wurde der Name falsch geschrieben? Oder existiert der Font nicht?");
        }
        return new Font(fontName, 0, 12);
    }

    public static void geladeneSchriftartenAusgeben() {
        Logger.info("Protokoll aller aus dem Projektordner geladener Fontdateien");
        if (eigene.length == 0) {
            Logger.info("Es wurden keine \".ttf\"-Dateien im Projektordner gefunden");
        } else {
            Logger.info("Es wurden " + eigene.length + " \".ttf\"-Dateien im Projektordner gefunden.");
            Logger.info("Diese sind unter folgenden Namen abrufbar:");
            for (Font font : eigene) {
                Logger.info(font.getName());
            }
        }
    }

    public void inhaltSetzen(String inhalt) {
        this.setzeInhalt(inhalt);
    }

    public void setzeInhalt(String inhalt) {
        this.inhalt = inhalt;
    }

    public void schriftartSetzen(int art) {
        this.setzeSchriftart(art);
    }

    public void setzeSchriftart(int art) {
        if (art >= 0 && art <= 3) {
            this.schriftart = art;
            this.aktualisieren();
        }
    }

    private void aktualisieren() {
        this.font = this.font.deriveFont(this.schriftart, this.groesse);
    }

    public void farbeSetzen(String farbe) {
        this.setzeFarbe(farbe);
    }

    public void setzeFarbe(String farbe) {
        this.setzeFarbe(Text.zuFarbeKonvertieren(farbe));
    }

    public void setzeFarbe(Color c) {
        this.farbe = c;
        this.aktualisieren();
    }

    public void farbeSetzen(Farbe f) {
        this.setzeFarbe(f.wert());
    }

    public void groesseSetzen(int groesse) {
        this.setzeGroesse(groesse);
    }

    public void setzeGroesse(int groesse) {
        this.groesse = groesse;
        this.aktualisieren();
    }

    public int groesse() {
        return this.groesse;
    }

    public void fontSetzen(String name) {
        this.setzeFont(name);
    }

    @Override
    public void zeichnen(Graphics2D g, BoundingRechteck r) {
        if (!r.schneidetBasic(this.dimension())) {
            return;
        }
        super.beforeRender(g, r);
        FontMetrics f = Fenster.metrik(this.font);
        float x = this.position.x;
        float y = this.position.y;
        if (this.anker == Anker.MITTE) {
            x = this.position.x - (float)(f.stringWidth(this.inhalt) / 2);
        } else if (this.anker == Anker.RECHTS) {
            x = this.position.x - (float)f.stringWidth(this.inhalt);
        }
        g.setColor(this.farbe);
        g.setFont(this.font);
        g.drawString(this.inhalt, (int)(x - r.x), (int)(y - r.y + (float)this.groesse));
        super.afterRender(g, r);
    }

    @Override
    public BoundingRechteck dimension() {
        FontMetrics f = Fenster.metrik(this.font);
        float x = this.position.x;
        float y = this.position.y;
        if (this.anker == Anker.MITTE) {
            x = this.position.x - (float)(f.stringWidth(this.inhalt) / 2);
        } else if (this.anker == Anker.RECHTS) {
            x = this.position.x - (float)f.stringWidth(this.inhalt);
        }
        return new BoundingRechteck(x, y, f.stringWidth(this.inhalt), f.getHeight());
    }

    @Override
    public Collider erzeugeCollider() {
        return this.erzeugeLazyCollider();
    }

    @Override
    public void loeschen() {
        super.leuchterAbmelden(this);
        super.loeschen();
    }

    @Override
    public void leuchtetSetzen(boolean leuchtet) {
        if (this.leuchtet == leuchtet) {
            return;
        }
        this.leuchtet = leuchtet;
        if (leuchtet) {
            this.alte = this.farbe;
        } else {
            this.setzeFarbe(this.alte);
        }
    }

    @Override
    public void leuchtSchritt() {
        ++this.leuchtzaehler;
        this.leuchtzaehler %= farbzyklus.length;
        this.setzeFarbe(farbzyklus[this.leuchtzaehler]);
    }

    @Override
    public boolean leuchtet() {
        return this.leuchtet;
    }

    public String gibInhalt() {
        return this.inhalt;
    }

    public Anker getAnker() {
        return this.anker;
    }

    public void setAnker(Anker anker) {
        this.anker = anker;
    }

    static {
        ArrayList<File> alleFonts = new ArrayList<File>();
        Text.fontsEinbauen(alleFonts, new File(System.getProperty("user.dir")));
        File[] unter = alleFonts.toArray(new File[alleFonts.size()]);
        eigene = new Font[unter.length];
        for (int i = 0; i < unter.length; ++i) {
            try {
                FileInputStream s = new FileInputStream(unter[i]);
                Text.eigene[i] = Font.createFont(0, s);
                s.close();
                continue;
            }
            catch (FileNotFoundException e) {
                Logger.error("Interner Lesefehler. Dies h\u00e4tte unter keinen Umst\u00e4nden passieren d\u00fcrfen.");
                continue;
            }
            catch (FontFormatException e) {
                Logger.error("Das TrueType-Font-Format einer Datei (" + unter[i].getPath() + ") war nicht einlesbar!");
                continue;
            }
            catch (IOException e) {
                Logger.error("Lesefehler beim Laden der eigenen Fonts! Zugriffsrechte \u00fcberpr\u00fcfen.");
            }
        }
    }

    public static enum Anker {
        LINKS,
        MITTE,
        RECHTS;

    }
}

