/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.Empfaenger;
import ea.NetzwerkVerbindung;
import ea.SenderInterface;
import ea.VerbindungHergestelltReagierbar;
import ea.edu.net.NetzwerkInterpreter;
import ea.internal.net.DiscoveryServer;
import ea.internal.util.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;

public class Server
extends Thread
implements Empfaenger,
SenderInterface {
    private final CopyOnWriteArrayList<NetzwerkVerbindung> verbindungen = new CopyOnWriteArrayList();
    private final Queue<NetzwerkVerbindung> waitingQueue = new LinkedList<NetzwerkVerbindung>();
    private final int port;
    private ServerSocket socket;
    private boolean active = true;
    private Empfaenger globalerEmpfaenger;
    private VerbindungHergestelltReagierbar verbindungHergestelltReagierbar;
    private boolean broadcast;

    public Server(int port) {
        this.port = port;
        this.setDaemon(true);
        this.start();
    }

    public void verbindungSchliessen() {
        if (this.socket == null) {
            return;
        }
        if (!this.socket.isClosed()) {
            for (NetzwerkVerbindung verbindung : this.verbindungen) {
                verbindung.beendeVerbindung();
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                Logger.error("Konnte den Verbindungs-Socket nicht mehr schliessen.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.socket = new ServerSocket(this.port);
        }
        catch (BindException e) {
            Logger.error("Port wird bereits genutzt. Ports k\u00f6nnen nicht doppelt genutzt werden.");
            return;
        }
        catch (IOException e) {
            Logger.error("Konnte keinen Server aufstellen. Ausreichend Rechte vorhanden?\n");
            e.printStackTrace();
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Server.this.beendeVerbindung();
            }
        });
        while (!this.isInterrupted() && this.active) {
            try {
                String name;
                Socket got = this.socket.accept();
                BufferedReader br = new BufferedReader(new InputStreamReader(got.getInputStream()));
                OutputStream os = got.getOutputStream();
                String init = br.readLine();
                if (init.length() < 1 || !init.startsWith("xe")) {
                    Logger.error("Client gefunden! Dieser hat sich aber falsch angemeldet! Kommt er sicher von der EA?");
                    continue;
                }
                if (init.length() == 1) {
                    Logger.error("Client hat sich angemeldet, jedoch keinen Namen hinterlassen. Verbindung wird trotzdem aufgebaut.");
                    name = "";
                } else {
                    name = init.substring(2);
                }
                String ip = got.getInetAddress().getHostAddress();
                NetzwerkInterpreter interpreter = new NetzwerkInterpreter(ip, this, br);
                interpreter.empfaengerHinzufuegen(this);
                final NetzwerkVerbindung verbindung = new NetzwerkVerbindung(name, ip, new BufferedWriter(new OutputStreamWriter(os)), interpreter);
                this.waitingQueue.add(verbindung);
                this.verbindungen.add(verbindung);
                verbindung.getInterpreter().empfaengerHinzufuegen(new Empfaenger(){

                    @Override
                    public void empfangeString(String string) {
                    }

                    @Override
                    public void empfangeInt(int i) {
                    }

                    @Override
                    public void empfangeByte(byte b) {
                    }

                    @Override
                    public void empfangeDouble(double d) {
                    }

                    @Override
                    public void empfangeChar(char c) {
                    }

                    @Override
                    public void empfangeBoolean(boolean b) {
                    }

                    @Override
                    public void verbindungBeendet() {
                        Server.this.verbindungen.remove(verbindung);
                        Server.this.waitingQueue.remove(verbindung);
                    }
                });
                if (this.verbindungHergestelltReagierbar != null) {
                    this.verbindungHergestelltReagierbar.verbindungHergestellt(ip);
                }
                Queue<NetzwerkVerbindung> queue = this.waitingQueue;
                synchronized (queue) {
                    this.waitingQueue.notifyAll();
                }
            }
            catch (IOException e) {
                return;
            }
        }
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public boolean isBroadcasting() {
        return this.broadcast;
    }

    public CopyOnWriteArrayList<NetzwerkVerbindung> getVerbindungen() {
        return this.verbindungen;
    }

    public void setVerbindungHergestelltReagierbar(VerbindungHergestelltReagierbar listener) {
        this.verbindungHergestelltReagierbar = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetzwerkVerbindung naechsteVerbindungAusgeben() {
        if (this.waitingQueue.isEmpty()) {
            try {
                Queue<NetzwerkVerbindung> queue = this.waitingQueue;
                synchronized (queue) {
                    this.waitingQueue.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.waitingQueue.poll();
    }

    public void globalenEmpfaengerSetzen(Empfaenger e) {
        this.globalerEmpfaenger = e;
    }

    @Override
    public void sendeString(String string) {
        for (NetzwerkVerbindung v : this.verbindungen) {
            v.sendeString(string);
        }
    }

    @Override
    public void sendeInt(int i) {
        for (NetzwerkVerbindung v : this.verbindungen) {
            v.sendeInt(i);
        }
    }

    @Override
    public void sendeByte(byte b) {
        for (NetzwerkVerbindung v : this.verbindungen) {
            v.sendeByte(b);
        }
    }

    @Override
    public void sendeDouble(double d) {
        for (NetzwerkVerbindung v : this.verbindungen) {
            v.sendeDouble(d);
        }
    }

    @Override
    public void sendeChar(char c) {
        for (NetzwerkVerbindung v : this.verbindungen) {
            v.sendeChar(c);
        }
    }

    @Override
    public void sendeBoolean(boolean b) {
        for (NetzwerkVerbindung v : this.verbindungen) {
            v.sendeBoolean(b);
        }
    }

    @Override
    public void beendeVerbindung() {
        if (this.socket == null) {
            return;
        }
        if (!this.socket.isClosed()) {
            for (NetzwerkVerbindung v : this.verbindungen) {
                if (!v.istAktiv()) continue;
                v.beendeVerbindung();
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                Logger.error("Konnte den Verbindungs-Socket nicht mehr schliessen.");
            }
        }
    }

    @Override
    public void empfangeString(String string) {
        if (this.globalerEmpfaenger != null) {
            this.globalerEmpfaenger.empfangeString(string);
        }
    }

    @Override
    public void empfangeInt(int i) {
        if (this.globalerEmpfaenger != null) {
            this.globalerEmpfaenger.empfangeInt(i);
        }
    }

    @Override
    public void empfangeByte(byte b) {
        if (this.globalerEmpfaenger != null) {
            this.globalerEmpfaenger.empfangeByte(b);
        }
    }

    @Override
    public void empfangeDouble(double d) {
        if (this.globalerEmpfaenger != null) {
            this.globalerEmpfaenger.empfangeDouble(d);
        }
    }

    @Override
    public void empfangeChar(char c) {
        if (this.globalerEmpfaenger != null) {
            this.globalerEmpfaenger.empfangeChar(c);
        }
    }

    @Override
    public void empfangeBoolean(boolean b) {
        if (this.globalerEmpfaenger != null) {
            this.globalerEmpfaenger.empfangeBoolean(b);
        }
    }

    @Override
    public void verbindungBeendet() {
        if (this.globalerEmpfaenger != null) {
            this.globalerEmpfaenger.verbindungBeendet();
        }
    }

    public void netzwerkSichtbarkeit(boolean sichtbar) {
        if (sichtbar) {
            DiscoveryServer.startServer();
        } else {
            DiscoveryServer.stopServer();
        }
    }
}

