/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.API;
import ea.AnimationsManager;
import ea.BoundingRechteck;
import ea.DateiManager;
import ea.FallReagierbar;
import ea.Knoten;
import ea.Kreis;
import ea.LeuchtMacher;
import ea.Leuchtend;
import ea.NoExternalUse;
import ea.Punkt;
import ea.StehReagierbar;
import ea.Vektor;
import ea.internal.collision.BoxCollider;
import ea.internal.collision.Collider;
import ea.internal.collision.NullCollider;
import ea.internal.gui.Fenster;
import ea.internal.phy.Gravitator;
import ea.internal.phy.MechanikClient;
import ea.internal.phy.NullClient;
import ea.internal.phy.Passivator;
import ea.internal.phy.PhysikClient;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Locale;

public abstract class Raum
implements Serializable,
Comparable<Raum> {
    public static final Color[] farbzyklus = new Color[]{Color.white, Color.blue, Color.red, Color.yellow, Color.magenta, Color.cyan, Color.green, Color.orange};
    private static final long serialVersionUID = 98L;
    private static final LeuchtMacher macher = new LeuchtMacher();
    private static final AnimationsManager animationsManager = AnimationsManager.getAnimationsManager();
    protected static boolean roh = false;
    protected Punkt position = Punkt.ZENTRUM;
    private boolean sichtbar = true;
    private boolean statisch = false;
    private PhysikClient phClient = new NullClient(this);
    private Collider collider = NullCollider.getInstance();
    private int zIndex = 1;
    private double drehung;
    private float opacity = 1.0f;
    private Composite composite;
    private AffineTransform transform;

    public static void heavyComputingSetzen(boolean heavy) {
        roh = heavy;
    }

    public static Color zuFarbeKonvertieren(String t) {
        Color c;
        switch (t.toLowerCase(Locale.GERMAN)) {
            case "gelb": {
                c = Color.yellow;
                break;
            }
            case "weiss": 
            case "wei\u00df": {
                c = Color.white;
                break;
            }
            case "orange": {
                c = Color.orange;
                break;
            }
            case "grau": {
                c = Color.gray;
                break;
            }
            case "gruen": 
            case "gr\u00fcn": {
                c = Color.green;
                break;
            }
            case "blau": {
                c = Color.blue;
                break;
            }
            case "rot": {
                c = Color.red;
                break;
            }
            case "pink": {
                c = Color.pink;
                break;
            }
            case "magenta": 
            case "lila": {
                c = Color.magenta;
                break;
            }
            case "cyan": 
            case "tuerkis": 
            case "t\u00fcrkis": {
                c = Color.cyan;
                break;
            }
            case "dunkelgrau": {
                c = Color.darkGray;
                break;
            }
            case "hellgrau": {
                c = Color.lightGray;
                break;
            }
            case "braun": {
                c = new Color(110, 68, 14);
                break;
            }
            default: {
                c = Color.black;
            }
        }
        return DateiManager.ausListe(c);
    }

    public static final Color halbesAlpha(Color c) {
        return DateiManager.ausListe(new Color(c.getRed(), c.getGreen(), c.getBlue(), 178));
    }

    protected static boolean problem(int z1, int z2) {
        if (z1 == 0 || z2 == 0) {
            return false;
        }
        return z1 < 0 ^ z2 < 0;
    }

    public void zIndex(int z) {
        this.zIndex = z;
    }

    public void neutralMachen() {
        this.phClient.aufloesen();
        this.phClient = new NullClient(this);
    }

    public void passivMachen() {
        this.phClient.aufloesen();
        this.phClient = new Passivator(this);
    }

    public void aktivMachen() {
        this.phClient.aufloesen();
        this.phClient = new Gravitator(this);
    }

    public void newtonschMachen() {
        this.phClient.aufloesen();
        this.phClient = new MechanikClient(this);
    }

    public boolean sprung(int kraft) {
        return this.phClient.sprung(kraft);
    }

    public void schwerkraftAktivSetzen(boolean aktiv) {
        this.phClient.schwerkraftAktivSetzen(aktiv);
    }

    public void schwerkraftSetzen(int schwerkraft) {
        this.phClient.schwerkraftSetzen(schwerkraft);
    }

    public void fallReagierbarAnmelden(FallReagierbar f, int kritischeTiefe) {
        this.phClient.fallReagierbarAnmelden(f, kritischeTiefe);
    }

    public void kritischeTiefeSetzen(int tiefe) {
        this.phClient.kritischeTiefeSetzen(tiefe);
    }

    public void stehReagierbarAnmelden(StehReagierbar s) {
        this.phClient.stehReagierbarAnmelden(s);
    }

    public boolean steht() {
        return this.phClient.steht();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bewegen(Vektor v) {
        Raum raum = this;
        synchronized (raum) {
            return this.phClient.bewegen(v);
        }
    }

    public void bewegen(float dX, float dY) {
        this.phClient.bewegen(new Vektor(dX, dY));
    }

    public void setzeMeterProPixel(float mpp) {
        MechanikClient.setzeMeterProPixel(mpp);
    }

    public void impulsHinzunehmen(Vektor impuls) {
        this.phClient.impulsHinzunehmen(impuls);
    }

    public void geschwindigkeitHinzunehmen(Vektor geschwindigkeit) {
        this.phClient.geschwindigkeitHinzunehmen(geschwindigkeit);
    }

    public float luftwiderstandskoeffizient() {
        return this.phClient.getLuftwiderstandskoeffizient();
    }

    public boolean istBeeinflussbar() {
        return this.phClient.istBeeinflussbar();
    }

    public float getMasse() {
        return this.phClient.getMasse();
    }

    public Vektor getForce() {
        return this.phClient.getForce();
    }

    public void luftwiderstandskoeffizientSetzen(float luftwiderstandskoeffizient) {
        this.phClient.luftwiderstandskoeffizientSetzen(luftwiderstandskoeffizient);
    }

    public void beeinflussbarSetzen(boolean beeinflussbar) {
        this.phClient.beeinflussbarSetzen(beeinflussbar);
    }

    public void masseSetzen(float masse) {
        this.phClient.masseSetzen(masse);
    }

    public void konstanteKraftSetzen(Vektor kraft) {
        this.phClient.kraftSetzen(kraft);
    }

    public void geschwindigkeitSetzen(Vektor geschwindigkeit) {
        this.phClient.geschwindigkeitSetzen(geschwindigkeit);
    }

    public void einfluesseZuruecksetzen() {
        this.phClient.einfluesseZuruecksetzen();
    }

    public void kraftAnwenden(Vektor kraft, float t_kraftuebertrag) {
        this.phClient.kraftAnwenden(kraft, t_kraftuebertrag);
    }

    public final void sichtbarSetzen(boolean sichtbar) {
        this.sichtbar = sichtbar;
    }

    public final boolean sichtbar() {
        return this.sichtbar;
    }

    protected final void leuchterAnmelden(Leuchtend l) {
        macher.add(l);
    }

    protected final void leuchterAbmelden(Leuchtend l) {
        macher.entfernen(l);
    }

    public final void zeichnenBasic(Graphics2D g, BoundingRechteck r) {
        boolean bl = this.statisch = r.x == 0.0f && r.y == 0.0f;
        if (this.sichtbar) {
            this.zeichnen(g, r);
        }
    }

    public abstract void zeichnen(Graphics2D var1, BoundingRechteck var2);

    public void positionSetzen(float x, float y) {
        this.positionSetzen(new Punkt(x, y));
    }

    public void positionSetzen(Punkt p) {
        BoundingRechteck r = this.dimension();
        this.verschieben(new Vektor(p.x - r.x, p.y - r.y));
    }

    public abstract BoundingRechteck dimension();

    public void verschieben(Vektor v) {
        this.position = this.position.verschobeneInstanz(v);
    }

    public void mittelpunktSetzen(int x, int y) {
        this.mittelpunktSetzen(new Punkt(x, y));
    }

    public void mittelpunktSetzen(Punkt p) {
        this.verschieben(this.zentrum().nach(p));
    }

    public float getX() {
        return this.position.x;
    }

    public Punkt zentrum() {
        return this.dimension().zentrum();
    }

    public float getBreite() {
        return this.dimension().breite;
    }

    public void setX(float x) {
        this.verschieben(x - this.getX(), 0.0f);
    }

    public float getHoehe() {
        return this.dimension().hoehe;
    }

    public int positionX() {
        return (int)this.dimension().x;
    }

    public float getY() {
        return this.position.y;
    }

    public int positionY() {
        return (int)this.dimension().y;
    }

    public final boolean schneidet(Raum r) {
        if (this instanceof Knoten) {
            Knoten k = (Knoten)this;
            for (Raum m : k.alleElemente()) {
                if (!r.schneidet(m)) continue;
                return true;
            }
        } else if (r instanceof Knoten) {
            Knoten k = (Knoten)r;
            for (Raum m : k.alleElemente()) {
                if (!this.schneidet(m)) continue;
                return true;
            }
        } else {
            if (this instanceof Kreis) {
                if (r instanceof Kreis) {
                    float x = r.mittelPunkt().abstand(this.mittelPunkt());
                    return x <= ((Kreis)this).radius() + ((Kreis)r).radius();
                }
                return this.dimension().schneidetBasic(r.dimension());
            }
            return this.dimension().schneidetBasic(r.dimension());
        }
        return false;
    }

    public void setY(float y) {
        this.verschieben(0.0f, y - this.getY());
    }

    public final Collider aktuellerCollider() {
        if (this.collider.istNullCollider()) {
            this.collider = this.erzeugeCollider();
            return this.collider;
        }
        return this.collider;
    }

    public abstract Collider erzeugeCollider();

    @NoExternalUse
    public final void beforeRender(Graphics2D g, BoundingRechteck r) {
        this.transform = g.getTransform();
        Punkt middle = this.mittelPunkt().verschobeneInstanz(new Vektor(-r.x, -r.y));
        if (this.drehung != 0.0) {
            g.rotate(Math.toRadians(this.drehung), middle.x, middle.y);
        }
        if (this.opacity != 1.0f) {
            this.composite = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(10, this.opacity));
        } else {
            this.composite = null;
        }
    }

    public Punkt mittelPunkt() {
        BoundingRechteck b = this.dimension();
        return new Punkt(b.x + b.breite / 2.0f, b.y + b.hoehe / 2.0f);
    }

    @NoExternalUse
    public final void afterRender(Graphics2D g, BoundingRechteck r) {
        if (this.composite != null) {
            g.setComposite(this.composite);
        }
        g.setTransform(this.transform);
    }

    public final boolean beinhaltet(Punkt p) {
        BoundingRechteck[] dim;
        if (this.statisch) {
            BoundingRechteck b = Fenster.instanz().getCam().position();
            p = p.verschobeneInstanz(new Vektor(-b.x, -b.y));
        }
        for (BoundingRechteck r : dim = this.flaechen()) {
            if (!r.istIn(p)) continue;
            return true;
        }
        return false;
    }

    public BoundingRechteck[] flaechen() {
        return new BoundingRechteck[]{this.dimension()};
    }

    protected Collider erzeugeLazyCollider() {
        return BoxCollider.fromBoundingRechteck(Vektor.NULLVEKTOR, this.dimension());
    }

    public void verschieben(float dX, float dY) {
        this.verschieben(new Vektor(dX, dY));
    }

    public void colliderSetzen(Collider collider) {
        this.collider = collider;
    }

    public void boundsUebernehmen(Raum boundHilfe) {
        Collider c = boundHilfe.aktuellerCollider();
        c.offsetSetzen(boundHilfe.position().alsVektor());
        this.collider = c;
    }

    public Punkt position() {
        return this.position;
    }

    public boolean stehtAuf(Raum m) {
        return this.dimension().stehtAuf(m.dimension());
    }

    public int hoehenUnterschied(Raum m) {
        return (int)this.dimension().hoehenUnterschied(m.dimension());
    }

    public void loeschen() {
        animationsManager.animationBeendenVon(this);
    }

    public boolean inFlaeche(BoundingRechteck r) {
        BoundingRechteck[] fl;
        for (BoundingRechteck fr : fl = this.flaechen()) {
            if (!fr.schneidetBasic(r)) continue;
            return true;
        }
        return false;
    }

    public double gibDrehung() {
        return this.drehung;
    }

    public void drehenAbsolut(double grad) {
        this.drehung = grad;
    }

    public void drehenRelativ(double grad) {
        this.drehung -= grad;
    }

    @API
    public float getOpacity() {
        return this.opacity;
    }

    @API
    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    @Override
    @NoExternalUse
    public int compareTo(Raum r) {
        if (this.zIndex < r.zIndex) {
            return 1;
        }
        if (this.zIndex > r.zIndex) {
            return -1;
        }
        return 0;
    }
}

