/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.API;
import ea.Bild;
import ea.BoundingRechteck;
import ea.KlickReagierbar;
import ea.MausBewegungReagierbar;
import ea.MausLosgelassenReagierbar;
import ea.MausReagierbar;
import ea.Punkt;
import ea.Raum;
import ea.RechtsKlickReagierbar;
import ea.Vektor;
import ea.internal.gui.Fenster;
import ea.internal.util.Logger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class Maus {
    public static final int TYPE_STANDARD = 0;
    public static final int TYPE_FADENKREUZ = 1;
    public static final int TYPE_HAND = 2;
    public static final int TYPE_KLASSIK = 3;
    private final int type;
    private final boolean fixed;
    private final boolean bewegend;
    private final ArrayList<Auftrag> mausListe = new ArrayList();
    private final ArrayList<KlickReagierbar> klickListeners = new ArrayList();
    private final ArrayList<RechtsKlickReagierbar> rechtsKlickListeners = new ArrayList();
    private final ArrayList<MausLosgelassenReagierbar> mausLosgelassenListeners = new ArrayList();
    private final ArrayList<MausBewegungReagierbar> mausBewegungListeners = new ArrayList();
    private final Raum bild;
    private final Punkt hotspot;
    private Fenster fenster;

    @API
    public Maus(Raum mausbild, Punkt hotspot, boolean fixed) {
        this(mausbild, hotspot, fixed, false);
    }

    @API
    public Maus(Raum mausbild, Punkt hotspot, boolean fixed, boolean bewegend) {
        this.type = -1;
        this.bild = mausbild;
        this.hotspot = hotspot;
        this.fixed = fixed;
        this.bewegend = bewegend;
    }

    @API
    public Maus(Raum mausbild, Punkt hotspot) {
        this(mausbild, hotspot, false, false);
    }

    @API
    public Maus(int type) {
        this(type, false, false);
    }

    @API
    public Maus(int type, boolean fixed, boolean bewegend) {
        this.type = type;
        this.fixed = fixed;
        this.bewegend = bewegend;
        this.bild = this.getImage();
        this.hotspot = this.hotSpot();
    }

    public Raum getImage() {
        if (this.bild != null) {
            return this.bild;
        }
        BufferedImage ret = null;
        String verzeichnis = "/assets/mouse/";
        switch (this.type) {
            case 0: {
                verzeichnis = verzeichnis + "blau.gif";
                break;
            }
            case 1: {
                verzeichnis = verzeichnis + "fadenkreuz.gif";
                break;
            }
            case 2: {
                verzeichnis = verzeichnis + "hand.gif";
                break;
            }
            case 3: {
                verzeichnis = verzeichnis + "klassisch.gif";
                break;
            }
            default: {
                verzeichnis = verzeichnis + "fadenkreuz.gif";
            }
        }
        InputStream in = Maus.class.getResourceAsStream(verzeichnis);
        try {
            ret = ImageIO.read(in);
        }
        catch (IOException ex) {
            Logger.error("Achtung! Das zu ladende Standard-Mausbild konnte nicht geladen werden.");
        }
        return new Bild(0.0f, 0.0f, ret);
    }

    public Punkt hotSpot() {
        if (this.hotspot != null) {
            return this.hotspot;
        }
        int x = 0;
        int y = 0;
        switch (this.type) {
            case 1: {
                y = 12;
                x = 12;
                break;
            }
            case 2: {
                x = 5;
                y = 0;
                break;
            }
        }
        return new Punkt(x, y);
    }

    public void fensterSetzen(Fenster f) {
        this.fenster = f;
    }

    public void mausReagierbarAnmelden(MausReagierbar m, Raum objekt) {
        this.anmelden(m, objekt, 0);
    }

    public void anmelden(MausReagierbar m, Raum objekt, int code) {
        this.mausListe.add(new Auftrag(m, code, objekt));
    }

    public void uebernehmeAlleListener(Maus von) {
        for (Auftrag a : von.mausListe) {
            this.anmelden(a.listener, a.koll, a.signal);
        }
        for (KlickReagierbar kr : von.klickListeners) {
            this.klickReagierbarAnmelden(kr);
        }
        for (RechtsKlickReagierbar rkr : von.rechtsKlickListeners) {
            this.rechtsKlickReagierbarAnmelden(rkr);
        }
        for (MausLosgelassenReagierbar mlr : this.mausLosgelassenListeners) {
            this.mausLosgelassenReagierbarAnmelden(mlr);
        }
        for (MausBewegungReagierbar mbr : this.mausBewegungListeners) {
            this.mausBewegungReagierbarAnmelden(mbr);
        }
    }

    public void klickReagierbarAnmelden(KlickReagierbar k) {
        this.klickListeners.add(k);
    }

    public void rechtsKlickReagierbarAnmelden(RechtsKlickReagierbar k) {
        this.rechtsKlickListeners.add(k);
    }

    public void mausLosgelassenReagierbarAnmelden(MausLosgelassenReagierbar m) {
        this.mausLosgelassenListeners.add(m);
    }

    public void mausBewegungReagierbarAnmelden(MausBewegungReagierbar m) {
        this.mausBewegungListeners.add(m);
    }

    public void klick(Punkt p, boolean links) {
        this.klick(p, links, false);
    }

    public void klick(Punkt p, boolean links, boolean losgelassen) {
        p = p.verschobeneInstanz(this.hotspot.alsVektor());
        if (losgelassen) {
            for (MausLosgelassenReagierbar m : this.mausLosgelassenListeners) {
                m.mausLosgelassen(p, links);
            }
            return;
        }
        if (links) {
            for (Auftrag a : this.mausListe) {
                a.klick(p);
            }
            for (KlickReagierbar k : this.klickListeners) {
                k.klickReagieren(p);
            }
        } else {
            for (RechtsKlickReagierbar k : this.rechtsKlickListeners) {
                k.rechtsKlickReagieren(p);
            }
        }
    }

    public void bewegt(Vektor bewegung) {
        if (bewegung.unwirksam()) {
            return;
        }
        for (MausBewegungReagierbar m : this.mausBewegungListeners) {
            m.mausBewegt(bewegung);
        }
    }

    public void entfernen(MausReagierbar g) {
        ArrayList<Auftrag> l = new ArrayList<Auftrag>();
        for (Auftrag a : this.mausListe) {
            if (!a.benachrichtigt(g)) continue;
            l.add(a);
        }
        for (Auftrag a : l) {
            this.mausListe.remove(a);
        }
    }

    public boolean bewegend() {
        return this.bewegend;
    }

    public Punkt klickAufZeichenebene() {
        if (this.absolut()) {
            BoundingRechteck r = this.bild.dimension();
            Punkt p = this.hotSpot();
            return new Punkt((int)(r.x + p.realX() + (float)this.fenster.getCam().getX()), (int)(r.y + p.realY() + (float)this.fenster.getCam().getY()));
        }
        Dimension dim = this.fenster.getSize();
        int startX = dim.width / 2;
        int startY = dim.height / 2;
        return new Punkt(startX + this.fenster.getCam().getX(), startY + this.fenster.getCam().getY());
    }

    public boolean absolut() {
        return this.fixed;
    }

    public ArrayList<Auftrag> mausReagierbarListe() {
        return this.mausListe;
    }

    public final class Auftrag {
        private final MausReagierbar listener;
        private final Raum koll;
        private int signal;

        public Auftrag(MausReagierbar listen, int signal, Raum m) {
            this.listener = listen;
            this.signal = signal;
            this.koll = m;
        }

        public void signalSetzen(int signal) {
            this.signal = signal;
        }

        public void klick(Punkt p) {
            if (this.koll.beinhaltet(p)) {
                this.listener.mausReagieren(this.signal);
            }
        }

        public boolean benachrichtigt(MausReagierbar r) {
            return r == this.listener;
        }

        public boolean beobachtet(Raum m) {
            return m == this.koll;
        }

        public int signal() {
            return this.signal;
        }
    }
}

