/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.EngineAlpha;
import ea.Ticker;
import ea.internal.util.Logger;
import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Manager {
    public static final Manager standard = new Manager();
    public static final String[] fontNamen;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(10);
    private final Map<Ticker, ScheduledFuture<?>> jobs = new HashMap();
    private int activeJobs = 0;

    public static boolean fontExistiert(String name) {
        for (String s : fontNamen) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Manager() {
    }

    @Deprecated
    public Manager(String name) {
        this();
    }

    public synchronized boolean hatAktiveTicker() {
        return this.activeJobs > 0;
    }

    public synchronized void anmelden(Ticker t, int intervall) {
        this.anmelden(t);
        this.starten(t, intervall);
    }

    public synchronized void anmelden(Ticker t) {
        if (this.istAngemeldet(t)) {
            Logger.warning("Der Ticker ist bereits an diesem Manager angemeldet und wird nicht erneut angemeldet.");
            return;
        }
        this.jobs.put(t, null);
        if (EngineAlpha.isDebug()) {
            Logger.info("Ticker wurde angemeldet: " + t.toString());
        }
    }

    public synchronized void starten(final Ticker ticker, int intervall) {
        if (!this.istAngemeldet(ticker)) {
            Logger.error("Der Ticker ist noch nicht angemeldet.");
            return;
        }
        if (this.jobs.get(ticker) != null) {
            Logger.error("Ticker ist bereits am Laufen!");
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    ticker.tick();
                }
                catch (RuntimeException e) {
                    Logger.error("Kritischer Fehler im Ticker: Eine Ausnahme wurde nicht abgefangen. Der Ticker wurde angehalten. Die folgende StackTrace sollte dir weitere Informationen liefern.");
                    e.printStackTrace();
                    Manager.this.anhalten(ticker);
                }
            }
        };
        this.jobs.put(ticker, this.executor.scheduleAtFixedRate(r, intervall, intervall, TimeUnit.MILLISECONDS));
        ++this.activeJobs;
    }

    public synchronized boolean istAngemeldet(Ticker t) {
        return this.jobs.containsKey(t);
    }

    public synchronized void anhalten(Ticker ticker) {
        if (!this.istAngemeldet(ticker)) {
            Logger.error("Der Ticker ist noch nicht angemeldet.");
            return;
        }
        ScheduledFuture<?> future = this.jobs.get(ticker);
        if (future != null) {
            this.jobs.get(ticker).cancel(false);
            this.jobs.put(ticker, null);
            --this.activeJobs;
        }
        if (EngineAlpha.isDebug()) {
            Logger.info("Ticker wurde angehalten: " + ticker.toString());
        }
    }

    public synchronized void abmelden(Ticker ticker) {
        if (!this.istAngemeldet(ticker)) {
            Logger.error("Der Ticker ist noch nicht angemeldet.");
            return;
        }
        if (this.jobs.get(ticker) != null) {
            this.anhalten(ticker);
        }
        this.jobs.remove(ticker);
        if (EngineAlpha.isDebug()) {
            Logger.info("Ticker wurde abgemeldet: " + ticker.toString());
        }
    }

    public final synchronized void kill() {
        this.alleAbmelden();
    }

    public final synchronized void alleAbmelden() {
        for (Ticker ticker : this.jobs.keySet()) {
            if (this.jobs.get(ticker) == null) continue;
            this.anhalten(ticker);
        }
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        fontNamen = ge.getAvailableFontFamilyNames();
    }
}

