/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.BoundingRechteck;
import ea.Dreieck;
import ea.Farbe;
import ea.Leuchtend;
import ea.Punkt;
import ea.Raum;
import ea.Vektor;
import ea.internal.collision.Collider;
import ea.internal.collision.ColliderGroup;
import ea.internal.gra.Listung;
import java.awt.Color;
import java.awt.Graphics2D;

public abstract class Geometrie
extends Raum
implements Leuchtend,
Listung {
    protected BoundingRechteck dimension;
    private Dreieck[] formen;
    private boolean leuchtet = false;
    private int leuchtzaehler = 0;
    private Color alte = Color.white;

    public Geometrie(float x, float y) {
        this.position = new Punkt(x, y);
        this.dimension = new BoundingRechteck(x, y, 0.0f, 0.0f);
        super.leuchterAnmelden(this);
    }

    @Override
    public void zeichnen(Graphics2D g, BoundingRechteck r) {
        super.beforeRender(g, r);
        for (int i = 0; i < this.formen.length; ++i) {
            this.formen[i].zeichnen(g, r);
        }
        super.afterRender(g, r);
    }

    @Override
    public BoundingRechteck dimension() {
        return this.dimension.klon();
    }

    @Override
    public void verschieben(Vektor v) {
        super.verschieben(v);
        for (int i = 0; i < this.formen.length; ++i) {
            this.formen[i].verschieben(v);
        }
        this.dimension = this.dimension.verschobeneInstanz(v);
    }

    @Override
    public Collider erzeugeCollider() {
        ColliderGroup group = new ColliderGroup();
        for (Dreieck d : this.formen) {
            group.addCollider(d.erzeugeCollider());
        }
        return group;
    }

    @Override
    public BoundingRechteck[] flaechen() {
        BoundingRechteck[] ret = new BoundingRechteck[this.formen.length];
        for (int i = 0; i < this.formen.length; ++i) {
            ret[i] = this.formen[i].dimension();
        }
        return ret;
    }

    @Override
    public void loeschen() {
        super.leuchterAbmelden(this);
        super.loeschen();
    }

    public void farbeSetzen(Farbe f) {
        this.farbeSetzen(f.wert());
    }

    public void farbeSetzen(Color c) {
        this.alte = c;
        if (this.formen == null) {
            this.formen = this.neuBerechnen();
        }
        for (int i = 0; i < this.formen.length; ++i) {
            this.formen[i].setColor(c);
        }
    }

    public abstract Dreieck[] neuBerechnen();

    @Override
    public void leuchtetSetzen(boolean leuchtet) {
        if (this.leuchtet == leuchtet) {
            return;
        }
        this.leuchtet = leuchtet;
        if (leuchtet) {
            this.alte = this.formen[0].getColor();
        } else {
            this.farbeSetzen(this.alte);
        }
    }

    @Override
    public void leuchtSchritt() {
        for (int i = 0; i < this.formen.length; ++i) {
            ++this.leuchtzaehler;
            this.leuchtzaehler %= farbzyklus.length;
            this.formen[i].setColor(farbzyklus[this.leuchtzaehler]);
        }
    }

    @Override
    public boolean leuchtet() {
        return this.leuchtet;
    }

    protected void aktualisierenFirst() {
        this.aktualisieren();
        this.farbeSetzen("Weiss");
    }

    protected void aktualisieren() {
        this.formen = this.neuBerechnen();
        for (int i = 0; i < this.formen.length; ++i) {
            this.formen[i].setColor(this.alte);
        }
        this.dimension = Geometrie.ausDreiecken(this.formen);
    }

    public void farbeSetzen(String farbe) {
        this.farbeSetzen(Geometrie.zuFarbeKonvertieren(farbe));
    }

    public static BoundingRechteck ausDreiecken(Dreieck[] ecke) {
        BoundingRechteck r = ecke[0].dimension();
        for (int i = 1; i < ecke.length; ++i) {
            r = r.summe(ecke[i].dimension());
        }
        return r;
    }

    public Dreieck[] formen() {
        return this.formen;
    }
}

