/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.internal.util.Logger;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.imageio.ImageIO;

public class EngineAlpha
extends Frame {
    public static final int VERSION_CODE = 30200;
    public static final String VERSION_STRING = "v3.2.0";
    public static final boolean IS_JAR = EngineAlpha.isJar();
    public static final long BUILD_TIME = IS_JAR ? EngineAlpha.getBuildTime() / 1000L : System.currentTimeMillis() / 1000L;
    private static boolean debug;
    private EngineAlphaPromotion promo;

    public EngineAlpha() {
        super("Engine Alpha v3.2.0");
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResourceAsStream("/assets/favicon.png")));
        }
        catch (IOException e) {
            Logger.error(e.getLocalizedMessage());
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EngineAlpha.this.promo.shutdown();
                EngineAlpha.this.setVisible(false);
                EngineAlpha.this.dispose();
                System.exit(0);
            }
        });
        this.promo = new EngineAlphaPromotion();
    }

    public static void main(String[] args) {
        new EngineAlpha();
    }

    public static boolean isJar() {
        String className = EngineAlpha.class.getName().replace('.', '/');
        String classJar = EngineAlpha.class.getResource("/" + className + ".class").toString();
        return classJar.startsWith("jar:");
    }

    public static String getJarName() {
        String className = EngineAlpha.class.getName().replace('.', '/');
        String classJar = EngineAlpha.class.getResource("/" + className + ".class").toString();
        if (classJar.startsWith("jar:")) {
            String[] vals;
            for (String val : vals = classJar.split("/")) {
                if (!val.contains("!")) continue;
                try {
                    return URLDecoder.decode(val.substring(0, val.length() - 1), "UTF-8");
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static long getBuildTime() {
        try {
            String uri = EngineAlpha.class.getName().replace('.', '/') + ".class";
            JarURLConnection j = (JarURLConnection)ClassLoader.getSystemResource(uri).openConnection();
            long time = j.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime();
            return time > 0L ? time : System.currentTimeMillis() / 1000L;
        }
        catch (Exception e) {
            return System.currentTimeMillis() / 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUrlBody(String uri) {
        System.setProperty("jsse.enableSNIExtension", "false");
        BufferedInputStream bis = null;
        try {
            int read;
            URL url = new URL(uri);
            bis = new BufferedInputStream(url.openStream());
            StringBuilder builder = new StringBuilder();
            byte[] data = new byte[1024];
            while ((read = bis.read(data)) != -1) {
                builder.append(new String(data, 0, read));
            }
            String string = builder.toString();
            return string;
        }
        catch (Exception builder) {
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean value) {
        debug = value;
    }

    private class EngineAlphaPromotion
    extends Canvas
    implements Runnable {
        private Thread thread;
        private BufferedImage logo;
        private double alpha = 0.0;
        private boolean loading = true;
        private boolean alive = true;
        private int version_stable = -1;

        public EngineAlphaPromotion() {
            EngineAlpha parent = EngineAlpha.this;
            try {
                this.logo = ImageIO.read(this.getClass().getResource("/assets/logo.png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.setSize(400, 300);
            this.setPreferredSize(this.getSize());
            parent.add(this);
            parent.pack();
            Dimension screen = this.getToolkit().getScreenSize();
            parent.setLocation((screen.width - parent.getWidth()) / 2, (screen.height - parent.getHeight()) / 2);
            parent.setVisible(true);
            this.thread = new Thread((Runnable)this){
                {
                    super(x0);
                    this.setDaemon(true);
                }
            };
            this.thread.start();
            new Thread(){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    try {
                        String body = EngineAlpha.getUrlBody("https://raw.githubusercontent.com/engine-alpha/engine-alpha/master/VERSION_STABLE").trim();
                        EngineAlphaPromotion.this.version_stable = Integer.parseInt(body);
                    }
                    catch (Exception e) {
                        EngineAlphaPromotion.this.version_stable = -1;
                    }
                    EngineAlphaPromotion.this.loading = false;
                }
            }.start();
        }

        @Override
        public void run() {
            this.createBufferStrategy(2);
            BufferStrategy bs = this.getBufferStrategy();
            Graphics2D g = (Graphics2D)bs.getDrawGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            long currTime = System.currentTimeMillis();
            while (this.alive) {
                long lastTime = currTime;
                currTime = System.currentTimeMillis();
                this.update(currTime - lastTime);
                this.render(g);
                bs.show();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void update(long passedTime) {
            this.alpha += (double)passedTime * 0.01;
            this.alpha %= 360.0;
        }

        public void render(Graphics2D g) {
            g.setFont(new Font("SansSerif", 2, 14));
            FontMetrics fm = g.getFontMetrics();
            g.setColor(new Color(250, 250, 250));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage((Image)this.logo, (this.getWidth() - this.logo.getWidth()) / 2, 45, null);
            if (this.loading) {
                g.setColor(new Color(0, 0, 0, 150));
                g.fillOval((int)((double)(this.getWidth() / 2) + 8.0 * Math.cos(this.alpha)) - 2, (int)((double)(this.getHeight() - 80) + 8.0 * Math.sin(this.alpha)) - 2, 4, 4);
                g.fillOval((int)((double)(this.getWidth() / 2) + 8.0 * Math.cos(180.0 + this.alpha)) - 2, (int)((double)(this.getHeight() - 80) + 8.0 * Math.sin(180.0 + this.alpha)) - 2, 4, 4);
                g.drawLine((int)((double)(this.getWidth() / 2) + 8.0 * Math.cos(this.alpha)), (int)((double)(this.getHeight() - 80) + 8.0 * Math.sin(this.alpha)), (int)((double)(this.getWidth() / 2) + 8.0 * Math.cos(180.0 + this.alpha)), (int)((double)(this.getHeight() - 80) + 8.0 * Math.sin(180.0 + this.alpha)));
            } else {
                String message = "";
                Color color = new Color(30, 30, 30);
                if (this.version_stable == -1) {
                    message = "Server f\u00fcr Versionsabgleich nicht erreichbar.";
                } else if (this.version_stable == 30200) {
                    message = "Dies ist die aktuelle Stable-Version.";
                    color = new Color(50, 200, 25);
                } else if (30200 < this.version_stable) {
                    message = "Es ist eine neue Stable-Version verf\u00fcgbar!";
                    color = new Color(200, 50, 0);
                }
                g.setColor(color);
                g.drawString(message, (this.getWidth() - fm.stringWidth(message)) / 2, this.getHeight() - 70);
            }
            Date date = new Date(BUILD_TIME * 1000L);
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            g.setColor(new Color(100, 100, 100));
            String str = "Build #30200   " + sdf.format(date);
            g.drawString(str, (this.getWidth() - fm.stringWidth(str)) / 2, this.getHeight() - 40);
        }

        public void shutdown() {
            this.alive = false;
            try {
                this.thread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

