/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.API;
import ea.Figur;
import ea.Raum;
import ea.compat.CompatDateiManager;
import ea.internal.gra.PixelFeld;
import ea.internal.util.Logger;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public class DateiManager {
    public static final String bruch = System.getProperty("line.separator");
    public static final String sep = System.getProperty("file.separator");
    public static final String verz = System.getProperty("user.dir") + sep;
    private static final List<Color> colors = new ArrayList<Color>();

    private DateiManager() {
    }

    @API
    public static boolean stringArraySchreiben(String[] array, String pfad) {
        if (array == null) {
            throw new IllegalArgumentException("Das Array war null. Das ist nicht erlaubt!");
        }
        if (!(pfad = DateiManager.normalizePath(pfad)).endsWith(".eaa")) {
            pfad = pfad + ".eaa";
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(verz + pfad));
            writer.write("version:2,typ:string,length:" + array.length);
            for (int i = 0; i < array.length; ++i) {
                writer.newLine();
                String line = array[i];
                line = line == null ? Character.toString('\u0000') : DatatypeConverter.printBase64Binary((byte[])line.getBytes());
                writer.write(line);
            }
            writer.close();
            return true;
        }
        catch (Exception e) {
            Logger.error("Fehler beim Schreiben der Datei!");
            return false;
        }
    }

    private static String normalizePath(String path) {
        return path.replace("\\", "/").replace("/", sep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @API
    public static String[] stringArrayEinlesen(String pfad) {
        if (!(pfad = DateiManager.normalizePath(pfad)).endsWith(".eaa")) {
            pfad = pfad + ".eaa";
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(pfad));
            String line = reader.readLine();
            if (line.equals("typ:String")) {
                String[] stringArray = CompatDateiManager.stringArrayEinlesen(pfad);
                return stringArray;
            }
            String[] metaInfos = line.split(",");
            HashMap<String, String> meta = new HashMap<String, String>();
            for (String metaInfo : metaInfos) {
                String[] info = metaInfo.split(":");
                meta.put(info[0], info[1]);
            }
            if (!((String)meta.get("version")).equals("2")) {
                Logger.error("Unbekannte Dateiformatsversion!");
                String[] stringArray = null;
                return stringArray;
            }
            if (!((String)meta.get("typ")).equals("string")) {
                Logger.error("Datei hat einen anderen Datentyp gespeichert: " + (String)meta.get("typ"));
            }
            String[] ret = new String[Integer.parseInt((String)meta.get("length"))];
            for (int i = 0; i < ret.length; ++i) {
                line = reader.readLine();
                ret[i] = line.equals(Character.toString('\u0000')) ? null : new String(DatatypeConverter.parseBase64Binary((String)line));
            }
            String[] stringArray = ret;
            return stringArray;
        }
        catch (IOException e) {
            Logger.error("Fehler beim Lesen der Datei. Existiert die Datei mit diesem Namen wirklich?\n" + pfad);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @API
    public static boolean integerArraySchreiben(int[] array, String pfad) {
        if (array == null) {
            throw new IllegalArgumentException("Das Array war null. Das ist nicht erlaubt!");
        }
        if (!(pfad = DateiManager.normalizePath(pfad)).endsWith(".eaa")) {
            pfad = pfad + ".eaa";
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(verz + pfad));
            writer.write("version:2,typ:int,length:" + array.length);
            for (int i = 0; i < array.length; ++i) {
                writer.newLine();
                writer.write(Integer.toString(array[i]));
            }
            writer.close();
            return true;
        }
        catch (Exception e) {
            Logger.error("Fehler beim Schreiben der Datei!");
            return false;
        }
    }

    @API
    public static int[] integerArrayEinlesen(String pfad) {
        if (!(pfad = DateiManager.normalizePath(pfad)).endsWith(".eaa")) {
            pfad = pfad + ".eaa";
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(pfad));
            String line = reader.readLine();
            if (line.compareTo("typ:String") == 0) {
                return CompatDateiManager.integerArrayEinlesen(pfad);
            }
            String[] metaInfos = line.split(",");
            HashMap<String, String> meta = new HashMap<String, String>();
            for (String metaInfo : metaInfos) {
                String[] info = metaInfo.split(":");
                meta.put(info[0], info[1]);
            }
            if (!((String)meta.get("version")).equals("2")) {
                Logger.error("Unbekannte Dateiformatsversion!");
                return null;
            }
            if (!((String)meta.get("typ")).equals("int")) {
                Logger.error("Datei hat einen anderen Datentyp gespeichert: " + (String)meta.get("typ"));
            }
            int[] ret = new int[Integer.parseInt((String)meta.get("length"))];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = Integer.parseInt(reader.readLine());
            }
            reader.close();
            return ret;
        }
        catch (IOException e) {
            Logger.error("Fehler beim Lesen der Datei. Existiert die Datei mit diesem Namen wirklich?\n" + pfad);
            return null;
        }
    }

    @API
    public static boolean schreiben(Figur f, String pfad) {
        return DateiManager.schreiben(f, "", pfad);
    }

    @API
    public static boolean schreiben(Figur f, String verzeichnis, String name) {
        PixelFeld[] feld = f.animation();
        if (!name.endsWith(".eaf")) {
            name = name + ".eaf";
        }
        String verz = verzeichnis.isEmpty() ? name : verzeichnis + sep + name;
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(verz));
            writer.write("_fig_");
            writer.newLine();
            writer.write("an:" + feld.length);
            writer.newLine();
            writer.write("f:" + feld[0].faktor());
            writer.newLine();
            writer.write("x:" + feld[0].breiteN());
            writer.newLine();
            writer.write("y:" + feld[0].hoeheN());
            writer.newLine();
            writer.write("p:" + (int)f.dimension().x);
            writer.newLine();
            writer.write("q:" + (int)f.dimension().y);
            writer.newLine();
            for (int i = 0; i < feld.length; ++i) {
                writer.write("-");
                writer.newLine();
                writer.write(DateiManager.feldInfo(feld[i]));
            }
            writer.close();
            return true;
        }
        catch (IOException e) {
            Logger.error("Fehler beim Erstellen der Datei. Sind die Zugriffsrechte zu stark?" + bruch + verz);
            Logger.error(e.getMessage());
            return false;
        }
    }

    @Deprecated
    @API
    public static boolean schreiben(Figur f, String name, String verzeichnis, boolean relativ) {
        return DateiManager.schreiben(f, name, verzeichnis);
    }

    public static String feldInfo(PixelFeld f) {
        Color[][] farbe = f.getPic();
        String ret = "";
        for (int i = 0; i < farbe.length; ++i) {
            for (int j = 0; j < farbe[0].length; ++j) {
                ret = ret + "Z" + i + "-" + j + ":" + DateiManager.farbeAnalysieren(farbe[i][j]) + bruch;
            }
        }
        return ret;
    }

    public static String farbeAnalysieren(Color c) {
        if (c == null) {
            return "%%;";
        }
        if (c.equals(Color.black)) {
            return "schwarz;";
        }
        if (c.equals(Color.gray)) {
            return "grau;";
        }
        if (c.equals(Color.green)) {
            return "gruen;";
        }
        if (c.equals(Color.yellow)) {
            return "gelb;";
        }
        if (c.equals(Color.blue)) {
            return "blau;";
        }
        if (c.equals(Color.white)) {
            return "weiss;";
        }
        if (c.equals(Color.orange)) {
            return "orange;";
        }
        if (c.equals(Color.red)) {
            return "rot;";
        }
        if (c.equals(Color.pink)) {
            return "pink;";
        }
        if (c.equals(Color.magenta)) {
            return "magenta;";
        }
        if (c.equals(Color.cyan)) {
            return "cyan;";
        }
        if (c.equals(Color.darkGray)) {
            return "dunkelgrau;";
        }
        if (c.equals(Color.lightGray)) {
            return "hellgrau;";
        }
        return "&" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ";";
    }

    @API
    public static Figur figurLaden(String verzeichnis) {
        return DateiManager.figurEinlesen(verzeichnis);
    }

    @API
    public static Figur figurEinlesen(String verzeichnis) {
        return DateiManager.figurEinlesen(new File(DateiManager.normalizePath(verzeichnis)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @API
    public static Figur figurEinlesen(File file) {
        String verzeichnis = file.getAbsolutePath();
        if (!verzeichnis.endsWith(".eaf")) {
            Logger.warning("Datei hatte nicht die Dateierweiterung .eaf. Diese wurde automatisch erg\u00e4nzt.");
            verzeichnis = verzeichnis + ".eaf";
        }
        Figur fig = new Figur();
        BufferedReader f = null;
        try {
            String add = "";
            f = new LineNumberReader(new FileReader(add + verzeichnis));
            String line = ((LineNumberReader)f).readLine();
            if (line.compareTo("_fig_") != 0) {
                Logger.error("Die Datei ist keine Figur-Datei!" + line);
                Figur figur = null;
                return figur;
            }
            line = ((LineNumberReader)f).readLine();
            int animationsLaenge = Integer.valueOf(line.substring(3));
            line = ((LineNumberReader)f).readLine();
            int fakt = Integer.valueOf(line.substring(2));
            line = ((LineNumberReader)f).readLine();
            int x = Integer.valueOf(line.substring(2));
            line = ((LineNumberReader)f).readLine();
            int y = Integer.valueOf(line.substring(2));
            line = ((LineNumberReader)f).readLine();
            int px = Integer.valueOf(line.substring(2));
            line = ((LineNumberReader)f).readLine();
            int py = Integer.valueOf(line.substring(2));
            PixelFeld[] ergebnis = new PixelFeld[animationsLaenge];
            for (int i = 0; i < ergebnis.length; ++i) {
                if (((LineNumberReader)f).readLine().compareTo("-") != 0) {
                    Logger.error("Die Datei ist besch\u00e4digt");
                }
                ergebnis[i] = new PixelFeld(x, y, fakt);
                for (int xT = 0; xT < x; ++xT) {
                    for (int yT = 0; yT < y; ++yT) {
                        line = ((LineNumberReader)f).readLine();
                        Color c = DateiManager.farbeEinlesen(line.split(":")[1]);
                        if (c != null) {
                            c = DateiManager.ausListe(c);
                        }
                        ergebnis[i].farbeSetzen(xT, yT, c);
                    }
                }
            }
            fig.animationSetzen(ergebnis);
            fig.positionSetzen(px, py);
            fig.animiertSetzen(animationsLaenge != 1);
            f.close();
        }
        catch (IOException e) {
            Logger.error("Fehler beim Lesen der Datei. Existiert die Datei mit diesem Namen wirklich?" + bruch + verzeichnis);
            e.printStackTrace();
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return fig;
    }

    public static Color farbeEinlesen(String s) {
        if (s.compareTo("%%;") == 0) {
            return null;
        }
        if (s.charAt(0) != '&') {
            return Raum.zuFarbeKonvertieren(s.replace(";", ""));
        }
        int[] rgb = new int[3];
        int cnt = 0;
        int temp = 1;
        for (int i = 1; i < s.length(); ++i) {
            if (s.charAt(i) != ',' && s.charAt(i) != ';') continue;
            rgb[cnt] = Integer.valueOf(s.substring(temp, i));
            temp = i + 1;
            ++cnt;
        }
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static Color ausListe(Color farbe) {
        for (Color c : colors) {
            if (!c.equals(farbe)) continue;
            return c;
        }
        colors.add(farbe);
        return farbe;
    }

    @Deprecated
    public static Figur figurEinlesen(String verzeichnis, boolean relativ) {
        return DateiManager.figurEinlesen(new File(verzeichnis));
    }

    static {
        colors.add(Color.RED);
        colors.add(Color.GREEN);
        colors.add(Color.BLUE);
        colors.add(Color.YELLOW);
        colors.add(Color.GRAY);
        colors.add(Color.MAGENTA);
        colors.add(Color.CYAN);
        colors.add(Color.BLACK);
        colors.add(Color.ORANGE);
        colors.add(Color.LIGHT_GRAY);
    }
}

