/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.Empfaenger;
import ea.NetzwerkVerbindung;
import ea.SenderInterface;
import ea.edu.net.NetzwerkInterpreter;
import ea.internal.util.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class Client
extends Thread
implements Empfaenger,
SenderInterface {
    private final String ipAdresse;
    private final String name;
    private final int port;
    private Socket socket;
    private NetzwerkVerbindung verbindung;
    private boolean connectFailed;

    public Client(String ipAdresse, int port) {
        this("Unbenannter Client", ipAdresse, port);
    }

    public Client(String name, String ipAdresse, int port) {
        this.setDaemon(true);
        this.name = name;
        this.ipAdresse = ipAdresse;
        this.port = port;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            NetzwerkVerbindung vb;
            this.socket = new Socket(this.ipAdresse, this.port);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Client.this.verbindungSchliessen();
                }
            });
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            InputStream is = this.socket.getInputStream();
            bw.write("xe" + this.name);
            bw.newLine();
            bw.flush();
            String ip = this.socket.getInetAddress().getHostAddress();
            NetzwerkInterpreter interpreter = new NetzwerkInterpreter(ip, null, new BufferedReader(new InputStreamReader(is)));
            interpreter.empfaengerHinzufuegen(this);
            this.verbindung = vb = new NetzwerkVerbindung(this.name, ip, bw, interpreter);
            Client client = this;
            synchronized (client) {
                this.notifyAll();
            }
        }
        catch (UnknownHostException e) {
            Logger.error("Konnte die IP-Adresse nicht zuordnen...");
            this.connectFailed = true;
        }
        catch (IOException e) {
            Logger.error("Es gab Input/Output - Schwierigkeiten. Sind ausreichende Rechte fuer Internet etc. vorhanden? Das System k\u00f6nnte die Netzwerkanfrage ablehnen.");
            this.connectFailed = true;
        }
    }

    public void verbindungSchliessen() {
        if (!this.socket.isClosed()) {
            this.verbindung.beendeVerbindung();
            try {
                this.socket.close();
            }
            catch (IOException e) {
                Logger.error("Konnte den Verbindungs-Socket nicht mehr schliessen.");
            }
        }
    }

    public void empfaengerHinzufuegen(Empfaenger e) {
        this.warteAufVerbindung();
        this.verbindung.getInterpreter().empfaengerHinzufuegen(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warteAufVerbindung() {
        if (this.verbindung == null) {
            Client client = this;
            synchronized (client) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Logger.warning("Achtung. Es k\u00f6nnte trotz warteAufVerbindung() noch keine Verbindung bestehen, da der Warteprozess unterbrochen wurde.");
                }
            }
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void sendeString(String string) {
        this.warteAufVerbindung();
        this.verbindung.sendeString(string);
    }

    @Override
    public void sendeInt(int i) {
        this.warteAufVerbindung();
        this.verbindung.sendeInt(i);
    }

    @Override
    public void sendeByte(byte b) {
        this.warteAufVerbindung();
        this.verbindung.sendeByte(b);
    }

    @Override
    public void sendeDouble(double d) {
        this.warteAufVerbindung();
        this.verbindung.sendeDouble(d);
    }

    @Override
    public void sendeChar(char c) {
        this.warteAufVerbindung();
        this.verbindung.sendeChar(c);
    }

    @Override
    public void sendeBoolean(boolean b) {
        this.warteAufVerbindung();
        this.verbindung.sendeBoolean(b);
    }

    @Override
    public void beendeVerbindung() {
        this.warteAufVerbindung();
        if (!this.verbindung.istAktiv()) {
            Logger.error("Die Verbindung zum Server wurde bereits beendet.");
        }
        this.verbindung.beendeVerbindung();
        try {
            this.socket.close();
        }
        catch (IOException e) {
            Logger.error("Konnte den Verbindungs-Socket nicht mehr schliessen.");
        }
    }

    @Override
    public void empfangeString(String string) {
    }

    @Override
    public void empfangeInt(int i) {
    }

    @Override
    public void empfangeByte(byte b) {
    }

    @Override
    public void empfangeDouble(double d) {
    }

    @Override
    public void empfangeChar(char c) {
    }

    @Override
    public void empfangeBoolean(boolean b) {
    }

    @Override
    public void verbindungBeendet() {
    }

    public boolean verbindungGescheitert() {
        return this.connectFailed;
    }
}

