/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.Dreieck;
import ea.KreisCollider;
import ea.Punkt;
import ea.Rechteck;
import ea.Vektor;
import java.io.Serializable;

public final class BoundingRechteck
implements Serializable {
    private static final long serialVersionUID = 99L;
    public final float x;
    public final float y;
    public final float breite;
    public final float hoehe;

    public BoundingRechteck(float x, float y, float dX, float dY) {
        this.x = x;
        this.y = y;
        this.breite = dX;
        this.hoehe = dY;
    }

    public Rechteck ausDiesem() {
        return new Rechteck(this.x, this.y, this.breite, this.hoehe);
    }

    public BoundingRechteck mittenAngleichInstanz(BoundingRechteck r) {
        return this.mittenAngleichInstanz(r.zentrum());
    }

    public BoundingRechteck mittenAngleichInstanz(Punkt p) {
        Punkt z = this.zentrum();
        return this.verschobeneInstanz(new Vektor(p.realX() - z.realX(), p.realY() - z.realY()));
    }

    public Punkt zentrum() {
        return new Punkt(this.x + this.breite / 2.0f, this.y + this.hoehe / 2.0f);
    }

    public BoundingRechteck verschobeneInstanz(Vektor v) {
        return new BoundingRechteck(this.x + v.x, this.y + v.y, this.breite, this.hoehe);
    }

    public BoundingRechteck summe(BoundingRechteck r) {
        float x = r.x < this.x ? r.x : this.x;
        float y = r.y < this.y ? r.y : this.y;
        float dX = r.x + r.breite > this.x + this.breite ? r.x + r.breite - x : this.x + this.breite - x;
        float dY = r.y + r.hoehe > this.y + this.hoehe ? r.y + r.hoehe - y : this.y + this.hoehe - y;
        return new BoundingRechteck(x, y, dX, dY);
    }

    public BoundingRechteck ueber(int untergrenze) {
        if (this.y + this.hoehe < (float)untergrenze) {
            return this;
        }
        return new BoundingRechteck(this.x, (float)untergrenze - this.hoehe, this.breite, this.hoehe);
    }

    public BoundingRechteck unter(int obergrenze) {
        if (this.y > (float)obergrenze) {
            return this;
        }
        return new BoundingRechteck(this.x, obergrenze, this.breite, this.hoehe);
    }

    public BoundingRechteck rechtsVon(int grenzeLinks) {
        if (this.x > (float)grenzeLinks) {
            return this;
        }
        return new BoundingRechteck(grenzeLinks, this.y, this.breite, this.hoehe);
    }

    public BoundingRechteck linksVon(int grenzeRechts) {
        if (this.x + this.breite < (float)grenzeRechts) {
            return this;
        }
        return new BoundingRechteck((float)grenzeRechts - this.breite, this.y, this.breite, this.hoehe);
    }

    public BoundingRechteck anPosition(float realX, float realY) {
        return new BoundingRechteck(realX, realY, this.breite, this.hoehe);
    }

    public KreisCollider umschliessenderKreis() {
        Punkt z = this.zentrum();
        return new KreisCollider(z, z.abstand(new Punkt(this.x, this.y)));
    }

    public boolean schneidet(Dreieck d) {
        int i;
        if (d == null) {
            return false;
        }
        Punkt[] punkte = d.punkte();
        for (i = 0; i < punkte.length; ++i) {
            if (!this.istIn(punkte[i])) continue;
            return true;
        }
        punkte = this.punkte();
        for (i = 0; i < punkte.length; ++i) {
            if (!d.beinhaltet(punkte[i])) continue;
            return true;
        }
        return false;
    }

    public boolean istIn(Punkt p) {
        return p.realX() >= this.x && p.realY() >= this.y && p.realX() <= this.x + this.breite && p.realY() <= this.y + this.hoehe;
    }

    public Punkt[] punkte() {
        return new Punkt[]{new Punkt(this.x, this.y), new Punkt(this.x + this.breite, this.y), new Punkt(this.x, this.y + this.hoehe), new Punkt(this.x + this.breite, this.y + this.hoehe)};
    }

    public boolean umschliesst(BoundingRechteck innen) {
        return this.x <= innen.x && this.y <= innen.y && this.x + this.breite >= innen.x + innen.breite && this.y + this.hoehe >= innen.y + innen.hoehe;
    }

    public boolean stehtAuf(BoundingRechteck r) {
        if (r.x + r.breite > this.x && r.x < this.x + this.breite) {
            return r.y == this.y + this.hoehe;
        }
        return false;
    }

    public float verschiebenX(BoundingRechteck r) {
        if (!this.schneidetBasic(r)) {
            return 0.0f;
        }
        if (r.linksVon(this)) {
            return this.x - (r.x + r.breite);
        }
        return this.x + this.breite - r.x;
    }

    public boolean schneidetBasic(BoundingRechteck fig) {
        return fig.y < this.y + this.hoehe && fig.y + fig.hoehe > this.y && fig.x + fig.breite > this.x && fig.x < this.x + this.breite;
    }

    public boolean linksVon(BoundingRechteck r) {
        return this.x < r.x;
    }

    public float verschiebenY(BoundingRechteck r) {
        if (!this.schneidetBasic(r)) {
            return 0.0f;
        }
        if (r.ueber(this)) {
            return this.y - (r.y + r.hoehe);
        }
        return this.y + this.hoehe - r.y;
    }

    public boolean ueber(BoundingRechteck r) {
        return this.y < r.y;
    }

    public float hoehenUnterschied(BoundingRechteck r) {
        if (this.schneidetBasic(r)) {
            return 0.0f;
        }
        if (this.y < r.y) {
            return r.y - (this.y + this.hoehe);
        }
        return this.y - (r.y + r.hoehe);
    }

    public BoundingRechteck verschErhoeht(Vektor v, int dHoehe) {
        return new BoundingRechteck(this.x + v.x, this.y + v.y, this.breite, this.hoehe + (float)dHoehe);
    }

    public BoundingRechteck in(BoundingRechteck aussen) {
        float realX = this.x;
        float realY = this.y;
        if (this.x < aussen.x) {
            realX = aussen.x;
        }
        if (this.x + this.breite > aussen.x + aussen.breite) {
            realX = aussen.x + aussen.breite - this.breite;
        }
        if (this.y < aussen.y) {
            realY = aussen.y;
        }
        if (this.y + this.hoehe > aussen.y + aussen.hoehe) {
            realY = aussen.y + aussen.hoehe - this.hoehe;
        }
        return new BoundingRechteck(realX, realY, this.breite, this.hoehe);
    }

    public BoundingRechteck klon() {
        return new BoundingRechteck(this.x, this.y, this.breite, this.hoehe);
    }

    public String toString() {
        return "Bounding-Rechteck: x:" + this.x + " y: " + this.y + " dX: " + this.breite + " dY: " + this.hoehe;
    }

    public float getRealX() {
        return this.x;
    }

    public float getRealY() {
        return this.y;
    }

    public float getRealBreite() {
        return this.breite;
    }

    public float getRealHoehe() {
        return this.hoehe;
    }

    public Punkt position() {
        return new Punkt(this.x, this.y);
    }
}

