/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.BoundingRechteck;
import ea.Punkt;
import ea.Raum;
import ea.Rotation;
import ea.internal.collision.Collider;
import ea.internal.io.ImageLoader;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class Bild
extends Raum {
    private final int urBreite;
    private final int urHoehe;
    private int breite;
    private int hoehe;
    private boolean wiederholen;
    private BufferedImage img;

    public Bild(String verzeichnis) {
        this(0.0f, 0.0f, verzeichnis);
    }

    public Bild(float x, float y, String verzeichnis) {
        this.position = new Punkt(x, y);
        this.wiederholen = false;
        this.img = ImageLoader.loadExternalImage(verzeichnis);
        this.urHoehe = this.img.getHeight();
        this.urBreite = this.img.getWidth();
    }

    public Bild(float x, float y, int breite, int hoehe, String verzeichnis) {
        this(x, y, breite, hoehe, verzeichnis, false);
    }

    public Bild(float x, float y, int breite, int hoehe, String verzeichnis, boolean wiederholen) {
        this(x, y, verzeichnis);
        this.wiederholen = wiederholen;
        this.breite = breite;
        this.hoehe = hoehe;
        this.wiederholen = wiederholen;
        if (!wiederholen) {
            this.img = Bild.resize(this.img, breite, hoehe);
        }
    }

    public static BufferedImage resize(BufferedImage img, int width, int height) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = env.getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage resize = gc.createCompatibleImage(img.getWidth(), img.getHeight(), img.getTransparency());
        Graphics2D g = resize.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(img, 0, 0, width, height, 0, 0, img.getWidth(), img.getHeight(), null);
        g.dispose();
        return resize;
    }

    public Bild(float x, float y, int prozent, String verzeichnis) {
        this(x, y, verzeichnis);
        this.img = Bild.resize(this.img, this.img.getWidth() * prozent / 100, this.img.getHeight() * prozent / 100);
    }

    public Bild(float x, float y, BufferedImage img) {
        this.img = img;
        this.positionSetzen(new Punkt(x, y));
        this.urHoehe = img.getHeight();
        this.urBreite = img.getWidth();
        this.hoehe = this.urHoehe;
        this.breite = this.urBreite;
    }

    public void rotieren(Rotation rot) {
        this.img = Bild.rotieren(this.img, rot.winkelBogen());
    }

    public static BufferedImage rotieren(BufferedImage img, double angle) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage dimg = new BufferedImage((int)((double)w * Math.sin(angle) + (double)w * Math.cos(angle)), (int)((double)h * Math.sin(angle) + (double)h * Math.cos(angle)), img.getType());
        Graphics2D g = dimg.createGraphics();
        g.rotate(angle, w / 2, h / 2);
        g.drawImage(img, null, (int)(Math.cos(angle) * (double)h / 2.0 * Math.sin(angle)), (int)(Math.cos(angle) * (double)h / 2.0 * Math.sin(angle)));
        g.dispose();
        return dimg;
    }

    @Override
    public void zeichnen(Graphics2D g, BoundingRechteck r) {
        if (r.schneidetBasic(this.dimension())) {
            super.beforeRender(g, r);
            if (!this.wiederholen) {
                g.drawImage((Image)this.img, (int)(this.position.realX() - r.x), (int)(this.position.realY() - r.y), null);
            } else {
                TexturePaint tp = new TexturePaint(this.img, new Rectangle2D.Double(-r.x + this.position.realX(), -r.y + this.position.realY(), this.img.getWidth(), this.img.getHeight()));
                g.setPaint(tp);
                g.fill(new Rectangle2D.Double(this.position.realX() - r.x, this.position.realY() - r.y, this.breite, this.hoehe));
            }
            super.afterRender(g, r);
        }
    }

    @Override
    public BoundingRechteck dimension() {
        if (!this.wiederholen) {
            return new BoundingRechteck(this.position.realX(), this.position.realY(), this.img.getWidth(), this.img.getHeight());
        }
        return new BoundingRechteck(this.position.realX(), this.position.realY(), this.breite, this.hoehe);
    }

    @Override
    public Collider erzeugeCollider() {
        return this.erzeugeLazyCollider();
    }

    public int normaleBreite() {
        return this.urBreite;
    }

    public int normaleHoehe() {
        return this.urHoehe;
    }

    public BufferedImage bild() {
        return this.img;
    }

    public final Bild clone() {
        return new Bild((float)this.positionX(), (float)this.positionY(), this.img);
    }
}

