/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.API;
import ea.AnimationsEndeReagierbar;
import ea.Manager;
import ea.NoExternalUse;
import ea.Punkt;
import ea.Raum;
import ea.Vektor;
import ea.internal.ani.Animierer;
import ea.internal.ani.GeradenAnimierer;
import ea.internal.ani.KreisAnimierer;
import ea.internal.ani.StreckenAnimierer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AnimationsManager
extends Manager
implements AnimationsEndeReagierbar {
    private static AnimationsManager instanz;
    private List<Animierer> animierer = new CopyOnWriteArrayList<Animierer>();

    private AnimationsManager() {
    }

    @API
    public static void neutralize() {
        AnimationsManager.getAnimationsManager().alleAbmelden();
    }

    @API
    public static AnimationsManager getAnimationsManager() {
        if (instanz == null) {
            instanz = new AnimationsManager();
        }
        return instanz;
    }

    @API
    public void kreisAnimation(Raum ziel) {
        this.kreisAnimation(ziel, AnimationsManager.unterhalb(ziel));
    }

    @API
    public void kreisAnimation(Raum ziel, Punkt zentrum) {
        this.kreisAnimation(ziel, zentrum, 1500);
    }

    private static Punkt unterhalb(Raum m) {
        return m.zentrum().verschobenerPunkt(new Vektor(0.0f, -150.0f));
    }

    @API
    public void kreisAnimation(Raum ziel, Punkt zentrum, int umlaufzeit) {
        this.kreisAnimation(ziel, zentrum, true, umlaufzeit);
    }

    @API
    public void kreisAnimation(Raum ziel, Punkt zentrum, boolean loop, int umlaufzeit) {
        this.kreisAnimation(ziel, zentrum, loop, umlaufzeit, true);
    }

    @API
    public void kreisAnimation(Raum ziel, Punkt zentrum, boolean loop, int umlaufzeit, boolean uhrzeigersinn) {
        KreisAnimierer k = new KreisAnimierer(ziel, zentrum, umlaufzeit, loop, this, this, uhrzeigersinn);
        this.animierer.add(k);
        k.starten();
    }

    @NoExternalUse
    public static float intervall(float z) {
        return Math.max(z, 1.0f);
    }

    @API
    public void streckenAnimation(Raum ziel, int laufDauer, boolean wiederholen, Punkt ... strecke) {
        this.streckenAnimation(ziel, laufDauer, wiederholen, wiederholen, strecke);
    }

    @API
    public void streckenAnimation(Raum ziel, int laufDauer, boolean wiederholen, boolean geschlossen, Punkt ... strecke) {
        StreckenAnimierer s = new StreckenAnimierer(ziel, wiederholen, geschlossen, this, laufDauer / strecke.length, this, strecke);
        this.animierer.add(s);
        s.starten();
    }

    @API
    public void streckenAnimation(Raum ziel, int laufDauer, Punkt ... strecke) {
        this.streckenAnimation(ziel, laufDauer, true, true, strecke);
    }

    @API
    public void streckenAnimation(Raum ziel, Punkt ... strecke) {
        this.streckenAnimation(ziel, (strecke.length + 1) * 1000, true, true, strecke);
    }

    @API
    public void geradenAnimation(Raum ziel, Punkt orientierung) {
        this.geradenAnimation(ziel, orientierung, 1000);
    }

    @API
    public void geradenAnimation(Raum ziel, Punkt orientierung, int zielGeschwindigkeit) {
        this.geradenAnimation(ziel, orientierung, zielGeschwindigkeit, zielGeschwindigkeit * 2);
    }

    @API
    public void geradenAnimation(Raum ziel, Punkt orientierung, int zielGeschwindigkeit, int dauerInMS) {
        GeradenAnimierer g = new GeradenAnimierer(ziel, orientierung, zielGeschwindigkeit, dauerInMS, this, this);
        this.animierer.add(g);
        g.starten();
    }

    @API
    public void animationBeendenVon(Raum raum) {
        for (Animierer a : this.animierer) {
            if (raum != a.ziel()) continue;
            a.beenden();
            this.animierer.remove(a);
        }
    }

    @Override
    public void endeReagieren(Animierer an) {
        this.animierer.remove(an);
    }
}

