/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.API;
import ea.BoundingRechteck;
import ea.Farbe;
import ea.Figur;
import ea.Manager;
import ea.NoExternalUse;
import ea.Raum;
import ea.Ticker;
import ea.Vektor;
import ea.internal.collision.Collider;
import ea.internal.util.Logger;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class ActionFigur
extends Raum {
    private static final ArrayList<ActionFigur> FIGUREN = new ArrayList();
    private Figur[] states = new Figur[0];
    private String[] stateNames = new String[0];
    private Figur[] actions = new Figur[0];
    private String[] actionNames = new String[0];
    private int indexState = 0;
    private int indexAction = 0;
    private boolean performsAction = false;

    public ActionFigur(Figur zustand, String name) {
        this.neuerZustand(zustand, name);
        FIGUREN.add(this);
    }

    @API
    public void neuerZustand(Figur zustand, String name) {
        zustand.entfernen();
        if (this.states.length > 0) {
            zustand.positionSetzen(this.aktuelleFigur().position());
        }
        Figur[] statesBefore = this.states;
        String[] stateNamesBefore = this.stateNames;
        this.states = new Figur[statesBefore.length + 1];
        this.stateNames = new String[stateNamesBefore.length + 1];
        for (int i = 0; i < statesBefore.length; ++i) {
            this.states[i] = statesBefore[i];
            this.stateNames[i] = stateNamesBefore[i];
        }
        this.states[this.states.length - 1] = zustand;
        this.stateNames[this.stateNames.length - 1] = name.toLowerCase();
    }

    public Figur aktuelleFigur() {
        return this.performsAction ? this.actions[this.indexAction] : this.states[this.indexState];
    }

    @API
    public void neueAktion(Figur action, String name) {
        action.entfernen();
        action.positionSetzen(this.aktuelleFigur().position());
        Figur[] actionsBefore = this.actions;
        String[] actionNamesBefore = this.actionNames;
        this.actions = new Figur[actionsBefore.length + 1];
        this.actionNames = new String[actionNamesBefore.length + 1];
        for (int i = 0; i < actionsBefore.length; ++i) {
            this.actions[i] = actionsBefore[i];
            this.actionNames[i] = actionNamesBefore[i];
        }
        this.actions[this.actions.length - 1] = action;
        this.actionNames[this.actionNames.length - 1] = name.toLowerCase();
    }

    @API
    public void zustandSetzen(String name) {
        name = name.toLowerCase();
        for (int i = 0; i < this.stateNames.length; ++i) {
            if (!this.stateNames[i].equals(name)) continue;
            this.indexState = i;
            return;
        }
        Logger.error("Achtung! Der Name des auszufuehrenden Zustandes wurde nie bei einer Anmeldung mitgegeben! Der Name, der nicht unter den Zustaenden gefunden wurde war: " + name);
    }

    @API
    public void aktionSetzen(String name) {
        name = name.toLowerCase();
        for (int i = 0; i < this.actionNames.length; ++i) {
            if (!this.actionNames[i].equals(name)) continue;
            this.hatAktionSetzen(true);
            this.indexAction = i;
            return;
        }
        Logger.error("Achtung! Der Name der auszufuehrenden Aktion wurde nie bei einer Anmeldung mitgegeben! Der Name, der nicht unter den angemeldeten Aktionen gefunden wurde war: " + name);
    }

    @NoExternalUse
    public void hatAktionSetzen(boolean action) {
        if (this.performsAction) {
            this.actions[this.indexAction].animationsBildSetzen(0);
        }
        this.performsAction = action;
    }

    @API
    public String aktuellesVerhalten() {
        return this.performsAction ? this.actionNames[this.indexAction] : this.stateNames[this.indexState];
    }

    @API
    public void spiegelXSetzen(boolean spiegel) {
        int i;
        for (i = 0; i < this.actions.length; ++i) {
            this.actions[i].spiegelXSetzen(spiegel);
        }
        for (i = 0; i < this.states.length; ++i) {
            this.states[i].spiegelXSetzen(spiegel);
        }
    }

    @API
    public void spiegelYSetzen(boolean spiegel) {
        int i;
        for (i = 0; i < this.actions.length; ++i) {
            this.actions[i].spiegelYSetzen(spiegel);
        }
        for (i = 0; i < this.states.length; ++i) {
            this.states[i].spiegelYSetzen(spiegel);
        }
    }

    @API
    public void einfaerben(String farbe) {
        this.einfaerben(Farbe.vonString(farbe));
    }

    @API
    public void einfaerben(Farbe farbe) {
        int i;
        for (i = 0; i < this.actions.length; ++i) {
            this.actions[i].einfaerben(farbe);
        }
        for (i = 0; i < this.states.length; ++i) {
            this.states[i].einfaerben(farbe);
        }
    }

    @API
    public void faktorSetzen(int faktor) {
        int i;
        for (i = 0; i < this.actions.length; ++i) {
            this.actions[i].faktorSetzen(faktor);
        }
        for (i = 0; i < this.states.length; ++i) {
            this.states[i].faktorSetzen(faktor);
        }
    }

    private void animationsSchritt(int runde) {
        int i;
        if (this.performsAction) {
            this.animationsActionSchritt(runde);
        } else {
            this.states[this.indexState].animationsSchritt(runde);
        }
        BoundingRechteck r = this.dimension();
        for (i = 0; i < this.actions.length; ++i) {
            this.actions[i].positionSetzen(r.x, r.y);
        }
        for (i = 0; i < this.states.length; ++i) {
            this.states[i].positionSetzen(r.x, r.y);
        }
    }

    private void animationsActionSchritt(int runde) {
        int last;
        int curr = this.actions[this.indexAction].aktuellesBild();
        if (curr == (last = this.actions[this.indexAction].animation().length - 1)) {
            if (runde % this.actions[this.indexAction].intervall() == 0) {
                this.hatAktionSetzen(false);
            }
        } else {
            this.actions[this.indexAction].animationsSchritt(runde);
        }
    }

    @API
    public boolean vollfuehrtAktion() {
        return this.performsAction;
    }

    @Override
    public void zeichnen(Graphics2D g, BoundingRechteck r) {
        super.beforeRender(g, r);
        if (this.performsAction) {
            this.actions[this.indexAction].zeichnen(g, r);
        } else {
            this.states[this.indexState].zeichnen(g, r);
        }
        super.afterRender(g, r);
    }

    @Override
    @API
    public BoundingRechteck dimension() {
        return this.performsAction ? this.actions[this.indexAction].dimension() : this.states[this.indexState].dimension();
    }

    @Override
    @API
    public void verschieben(Vektor v) {
        int i;
        for (i = 0; i < this.states.length; ++i) {
            this.states[i].verschieben(v);
        }
        for (i = 0; i < this.actions.length; ++i) {
            this.actions[i].verschieben(v);
        }
    }

    @Override
    public Collider erzeugeCollider() {
        return this.states[0].erzeugeCollider();
    }

    @Override
    public BoundingRechteck[] flaechen() {
        if (this.performsAction) {
            return this.actions[this.indexAction].flaechen();
        }
        return this.states[this.indexState].flaechen();
    }

    static {
        Manager.standard.anmelden(new Ticker(){
            int runde = 0;

            @Override
            public void tick() {
                ++this.runde;
                try {
                    for (ActionFigur f : FIGUREN) {
                        f.animationsSchritt(this.runde);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, 1);
    }
}

