/*
 * Decompiled with CFR 0.152.
 */
import ea.Knoten;
import ea.Punkt;
import ea.Raum;

public class Player
extends Knoten {
    private GameSaver gamesaver;
    private String name;
    private float posX;
    private float posY;
    private int money;
    private int walkspeed;
    private ImageCollection2 IC2;
    float lastX;

    public Player(float posX, float posY, GameSaver gs) {
        this.lastX = this.posX;
        this.gamesaver = gs;
        this.posX = posX;
        this.posY = posY;
        this.money = 0;
        this.IC2 = new ImageCollection2(this.posX, this.posY, "./Assets/SpielerTest/BasicMale");
        this.IC2.Init();
        this.add((Raum)this.IC2);
        this.walkspeed = this.gamesaver.getWalkspeed();
    }

    @Override
    public void verschieben(float dX, float dY) {
        super.verschieben(dX, dY);
        this.posX += dX;
        this.posY += dY;
    }

    @Override
    public void positionSetzen(float x, float y) {
        this.posX = x;
        this.posY = y;
        super.positionSetzen(x, y);
    }

    @Override
    public void positionSetzen(Punkt p) {
        super.positionSetzen(p);
    }

    public void WalkLeft() {
        this.IC2.walkLeft(this.walkspeed);
        this.posX -= (float)this.walkspeed;
    }

    public void WalkRight() {
        this.IC2.walkRight(this.walkspeed);
        this.posX += (float)this.walkspeed;
    }

    public void WalkBottom() {
        this.IC2.walkBottom(this.walkspeed);
        this.posY += (float)this.walkspeed;
    }

    public void WalkTop() {
        this.IC2.walkTop(this.walkspeed);
        this.posY -= (float)this.walkspeed;
    }

    public void standStill() {
        this.IC2.resetStep();
    }

    public int getMoney() {
        return this.money;
    }

    public void addMoney(int x) {
        this.money += x;
    }

    public float getCenterX() {
        return this.posX + this.getBreite() / 2.0f;
    }

    public float getCenterY() {
        return this.posY + this.getHoehe() / 2.0f;
    }

    public int getWalkspeed() {
        return this.walkspeed;
    }

    public String getName() {
        return this.name;
    }

    public float getPosX() {
        return this.posX;
    }

    public float getPosY() {
        return this.posY;
    }
}

