/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import ea.Knoten;
import ea.Punkt;
import ea.Raum;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class NpcController2
extends Knoten {
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    private String npcTemplatePath = "./Assets/Files/NPCs-Template.json";
    private String npcFilePath = "./Assets/Files/NPCs_NEW.json";
    private String npcPositionPath = "./Assets/Files/NPCs_Positions.json";
    private HashMap<String, NPC2> NPCs;
    private Map<String, Map<String, DialogController5.NpcPosition>> npcPositions;
    private float lastQuietX = 0.0f;
    private float lastQuietY = 0.0f;
    public boolean initDone = false;
    private Player AP;
    private GameSaver gamesaver;

    public NpcController2(Player mAP, GameSaver gs) {
        this.AP = mAP;
        this.gamesaver = gs;
        this.readJSON();
        this.readNpcPositionJSON();
        this.addAllNPCs();
        this.updateNpcPositions(this.gamesaver.getTemporalPosition());
        this.initDone = true;
    }

    public void startNewGame() {
        System.out.println("NpcController2");
        this.readJSON();
        this.readNpcPositionJSON();
        this.leaveHouse();
    }

    public boolean checkForCollision(Player AP) {
        boolean coll = false;
        for (String key : this.NPCs.keySet()) {
            NPC2 element = this.NPCs.get(key);
            if (!element.schneidetNEU(AP) || !element.sichtbar()) continue;
            coll = true;
        }
        if (!coll) {
            this.lastQuietX = AP.getPosX();
            this.lastQuietY = AP.getPosY();
        }
        return coll;
    }

    public String getCollidingNPC(Player AP) {
        String returnKey = null;
        for (String key : this.NPCs.keySet()) {
            NPC2 element = this.NPCs.get(key);
            if (!element.schneidetNEU(AP) || !element.sichtbar()) continue;
            returnKey = key;
        }
        if (returnKey == null) {
            System.out.println("NpcController2: Komisches Verhalten: Es wird nach expliziter Kollision gefragt, aber es gibt keine. Das kann f\u00fcr massive weitere Fehler sorgen");
            return null;
        }
        return returnKey;
    }

    public String getNpcLastLine(String npcID) {
        return this.NPCs.get((Object)npcID).lastLine;
    }

    public void resetToLastQuietPos() {
        this.AP.positionSetzen(this.lastQuietX, this.lastQuietY);
    }

    public Punkt getLastQuietPos() {
        return new Punkt(this.lastQuietX, this.lastQuietY);
    }

    public void enterHouse(int houseN, int offsetX, int offsetY) {
        System.out.println("NpcController: enterhouse wird aufgerufen()");
        this.hideAllNPCs();
        for (String key : this.NPCs.keySet()) {
            NPC2 element = this.NPCs.get(key);
            if (element.getHouseNumber() != houseN) continue;
            System.out.println("Der NPC names( " + element.name + " )ist im Haus sichtbar");
            this.add((Raum)element);
            element.sichtbarSetzen(true);
            element.positionSetzen(offsetX + (int)element.getRelativPosX(), offsetY + (int)element.getRelativPosY());
            System.out.println("Er ist an der relativen Posititon x:" + element.getRelativPosX() + " und y:" + element.getRelativPosY());
            System.out.println("Er ist an der absoluten Posititon x:" + element.getPosX() + " und y:" + element.getPosY());
            System.out.println(element);
        }
    }

    public void setNpcLastLine(String name, String lineCode) {
        System.out.println("NpcController2: f\u00fcr den NPC:" + name + "wird der Dialog mit dem Code: " + lineCode + " gespeichert");
        NPC2 npc = this.NPCs.get(name);
        npc.setLastLine(lineCode);
        this.saveJSON();
    }

    public void highLightNpcs(Set keySet) {
        for (String key : this.NPCs.keySet()) {
            NPC2 element = this.NPCs.get(key);
            element.setHighlightState(false);
        }
        if (keySet != null) {
            for (String npcName : keySet) {
                System.out.println("NpcController2: Der Spieler mit dem Namen:" + npcName + " wird jetzt gehighlightet!");
                this.NPCs.get(npcName).setHighlightState(true);
            }
        } else {
            System.out.println("NpcController2: FEHLER: EIN DER HIGHLIGHT KEYSET GRUPPE IST LEER. DAS LIEGT WAHRSCHEINLICH DARAN, DASS ES KEINE WEITEREN DIALOGPACKETE F\u00dcTR DIE NEUE ZEIT GIBT!");
        }
    }

    public void highLightNpcsByName(String name) {
        System.out.println("Der NPC mit dem Namen (" + name + ") wird gehighlightet");
        if (name == null) {
            System.out.println("NpcController2: FEHLER: EIN DER HIGHLIGHT NAME  IST LEER. (DAS LIEGT Vielleicht DARAN, DASS ES KEINE WEITEREN DIALOGPACKETE F\u00dcTR DIE NEUE ZEIT GIBT!)");
        } else {
            this.NPCs.get(name).setHighlightState(true);
        }
    }

    public void disguiseAllNPCs() {
        for (String key : this.NPCs.keySet()) {
            NPC2 element = this.NPCs.get(key);
            element.setHighlightState(false);
        }
    }

    public void leaveHouse() {
        this.hideAllNPCs();
        for (String key : this.NPCs.keySet()) {
            NPC2 element = this.NPCs.get(key);
            if (element.isInHouse()) continue;
            element.sichtbarSetzen(true);
        }
    }

    public void updateNpcVisibility() {
        int currentHouseNumber = this.gamesaver.getHouseNumber();
        this.hideAllNPCs();
        for (String key : this.NPCs.keySet()) {
            NPC2 element = this.NPCs.get(key);
            if (element.getHouseNumber() != currentHouseNumber) continue;
            element.sichtbarSetzen(true);
        }
    }

    private void hideAllNPCs() {
        System.out.println("NpcController4: HideAllNPCs() aufgerufen");
        for (String key : this.NPCs.keySet()) {
            NPC2 element = this.NPCs.get(key);
            element.sichtbarSetzen(false);
        }
    }

    private void addAllNPCs() {
        for (String key : this.NPCs.keySet()) {
            NPC2 element = this.NPCs.get(key);
            this.add((Raum)element);
        }
    }

    private void saveJSON() {
        try {
            FileWriter writer = new FileWriter(this.npcFilePath);
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            String json = gson.toJson(this.NPCs);
            writer.write(json);
            ((Writer)writer).close();
            System.out.println("\u001b[32mNpcController2: JSON(./Assets/Files/NPCs_NEW.json) erfolgreich gespeichert\u001b[0m");
        }
        catch (Exception e) {
            System.out.println("\u001b[35mNpcController2: Ein Fehler beim SCHREIBEN der Json Datei:\u001b[0m");
            System.out.println(e);
        }
    }

    public void updateNpcPositions(String timePos) {
        System.out.println("NpcController2: updateNpcPositions aufgerufen---------------------------------");
        Map<String, DialogController5.NpcPosition> positionsAtTime = this.npcPositions.get(timePos);
        if (positionsAtTime != null) {
            for (String key : positionsAtTime.keySet()) {
                try {
                    DialogController5.NpcPosition posObject = positionsAtTime.get(key);
                    String name = key;
                    NPC2 npc = this.NPCs.get(name);
                    if (npc != null) {
                        System.out.println("NpcController2: Die Position des NPCs mir dem Name (" + name + ") wird geupdatet");
                        npc.setRelativPos((int)posObject.getPosX(), (int)posObject.getPosY());
                        npc.positionSetzen(posObject.getPosX(), posObject.getPosY());
                        npc.setHouseNumber(posObject.getHouseN());
                        System.out.println("NpcController2: Er befindet sich jz um Haus: " + npc.getHouseNumber() + " und x:" + npc.getPosX() + "| y:" + npc.getPosY());
                        continue;
                    }
                    System.out.println("NpcController: FEHLER: NPC mit dem name (" + name + ") existiert nicht in der urspr\u00fcnglichen JSON mit den NPCs");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("NpcController: FEHLER beim update der Positionen der NPCs");
                }
            }
            this.updateNpcVisibility();
        } else {
            System.out.println("NpcController: F\u00fcr diese Zeit gibt es kein NPC Pos Update");
        }
    }

    public HashMap<String, NPC2> getNPCs() {
        return this.NPCs;
    }

    private void readJSON() {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)NPC2.class), new NPC2.Deserializer()).excludeFieldsWithoutExposeAnnotation().create();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.npcFilePath));
            Type MapType = new TypeToken<HashMap<String, NPC2>>(){}.getType();
            this.NPCs = (HashMap)gson.fromJson((Reader)bufferedReader, MapType);
            System.out.println("\u001b[32mNpcController2: JSON(" + this.npcFilePath + ") erfolgreich gelesen" + ANSI_RESET);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[35mNpcController2: Ein Fehler beim Lesen der JSON(" + this.npcFilePath + ") Datei. Entweder Pfad flasch, oder JSON Struktur." + ANSI_RESET);
        }
    }

    private void readNpcPositionJSON() {
        Gson gson = new Gson();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.npcPositionPath));
            Type MapType = new TypeToken<Map<String, Map<String, DialogController5.NpcPosition>>>(){}.getType();
            this.npcPositions = (Map)gson.fromJson((Reader)bufferedReader, MapType);
            System.out.println("\u001b[32mNpcController2: JSON(" + this.npcPositionPath + ")  erfolgreich gelesen" + ANSI_RESET);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[35mNpcController2: Ein Fehler beim Lesen der Json Datei(" + this.npcPositionPath + " ). Entweder Pfad flasch, oder JSON Struktur." + ANSI_RESET);
        }
    }
}

