/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import ea.Bild;
import ea.Knoten;
import ea.Raum;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ItemController
extends Knoten {
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    private List<Item> items = new ArrayList<Item>();
    private final String itemInitFilePath = "./Assets/Files/Items.json";
    private Player activPlayer;
    private GameSaver gamesaver;
    private DialogController5 diaController;
    private ItemAnimation itemAnimator;
    private SoundController soundC;

    public ItemController(Player ap, GameSaver gs, DialogController5 diaC, ItemAnimation iA, SoundController sc) {
        this.activPlayer = ap;
        this.gamesaver = gs;
        this.diaController = diaC;
        this.itemAnimator = iA;
        this.soundC = sc;
        this.readJSON();
        this.addAllItems();
        System.out.println(this.items.toString());
    }

    public void updateItemVisibility() {
        List<String> lines = this.gamesaver.getLines();
        for (Item i : this.items) {
            if (i.found) continue;
            if (i.requiredLineCode.equals("")) {
                i.visible = true;
                continue;
            }
            if (lines.contains(i.requiredLineCode)) {
                System.out.println("ItemController: Das Item namnes:" + i.name + " wird jz aufgedeckt und angezeigt");
                i.visible = true;
                continue;
            }
            i.hideItem();
        }
    }

    public void enterHouse(int hN, int offsetX, int offsetY) {
        this.hideAllItems();
        for (Item item : this.items) {
            if (!item.visible || item.houseN != hN) continue;
            item.positionSetzen(item.relativePosX + (float)offsetX, item.relativePosY + (float)offsetY);
            item.sichtbarSetzen(true);
        }
    }

    public void leaveHouse() {
        this.hideAllItems();
        for (Item item : this.items) {
            if (!item.visible || item.houseN != -1) continue;
            item.positionSetzen(item.relativePosX, item.relativePosY);
            item.sichtbarSetzen(true);
        }
    }

    public boolean checkForCollision() {
        boolean coll = false;
        for (Item item : this.items) {
            if (!this.activPlayer.schneidet(item) || !item.visible || !item.sichtbar()) continue;
            coll = true;
        }
        return coll;
    }

    public String getCollidingItemName() {
        this.diaController.highLightReadyNpcs();
        Item collItem = null;
        for (Item item : this.items) {
            if (!this.activPlayer.schneidet(item) || !item.visible || !item.sichtbar()) continue;
            collItem = item;
        }
        if (collItem == null) {
            System.out.println("ItemController: FEHLER: ER schneidet KEIN Item");
            return null;
        }
        return collItem.name;
    }

    public void hideCollidingItem() {
        Item collItem = null;
        for (Item item : this.items) {
            if (!this.activPlayer.schneidet(item) || !item.visible) continue;
            collItem = item;
        }
        if (collItem == null) {
            System.out.println("ItemController: FEHLER: Er schneidet KEIN Item");
        } else {
            System.out.println("ItemController: Der Spieler schneidet echt ein Item und es wird jz ausgeblendet, Itemname=(" + collItem.name + ").");
            this.soundC.playItemFoundSound();
            collItem.hideItem();
            collItem.found = true;
            this.itemAnimator.openAnimation(collItem.name);
        }
    }

    private void hideAllItems() {
        for (Item item : this.items) {
            item.sichtbarSetzen(false);
        }
    }

    private void addAllItems() {
        for (Item item : this.items) {
            this.add((Raum)item);
            item.sichtbarSetzen(false);
        }
    }

    private void readJSON() {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Item.class), new Deserializer()).excludeFieldsWithoutExposeAnnotation().create();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("./Assets/Files/Items.json"));
            Type ListType = new TypeToken<List<Item>>(){}.getType();
            this.items = (List)gson.fromJson((Reader)bufferedReader, ListType);
            System.out.println("\u001b[32mItemController: JSON(./Assets/Files/Items.json) erfolgreich gelesen\u001b[0m");
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            System.out.println("\u001b[35mItemController: Ein Fehler beim Lesen der JSON(./Assets/Files/Items.json) Datei. Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
        }
    }

    public static class Item
    extends Knoten {
        private String mainPath = "./Assets/Items/";
        private Bild img;
        @Expose
        private String name;
        @Expose
        private float posX;
        @Expose
        private float posY;
        @Expose
        private float relativePosX;
        @Expose
        private float relativePosY;
        @Expose
        private int houseN;
        @Expose
        private boolean visible;
        @Expose
        private boolean found;
        @Expose
        private String requiredLineCode;

        private Item(String n, float x, float y, float rX, float rY, int hn, boolean vb, boolean f, String rLC) {
            this.name = n;
            this.posX = x;
            this.posY = y;
            this.relativePosX = rX;
            this.relativePosY = rY;
            this.houseN = hn;
            this.visible = vb;
            this.found = f;
            this.requiredLineCode = rLC;
            try {
                String path = this.mainPath + this.name + ".png";
                this.img = new Bild(this.posX, this.posY, path);
                this.add((Raum)this.img);
                this.sichtbarSetzen(this.visible);
            }
            catch (Exception e) {
                System.out.println("Item: Fehler beim importieren der Datei");
                System.out.println("Item: " + e);
            }
        }

        private void showItem() {
            this.visible = true;
            this.sichtbarSetzen(true);
        }

        private void hideItem() {
            this.visible = false;
            this.sichtbarSetzen(false);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Item{mainPath='" + this.mainPath + '\'' + ", img=" + this.img + ", name='" + this.name + '\'' + ", posX=" + this.posX + ", posY=" + this.posY + ", relativePosX=" + this.relativePosX + ", relativePosY=" + this.relativePosY + ", houseN=" + this.houseN + ", visible=" + this.visible + ", found=" + this.found + ", requiredLineCode='" + this.requiredLineCode + '\'' + '}';
        }
    }

    public static class Deserializer
    implements JsonDeserializer<Item> {
        @Override
        public Item deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = (JsonObject)jsonElement;
            return new Item(jsonObject.get("name").getAsString(), jsonObject.get("posX").getAsInt(), jsonObject.get("posY").getAsInt(), jsonObject.get("relativePosX").getAsInt(), jsonObject.get("relativePosY").getAsInt(), jsonObject.get("houseN").getAsInt(), jsonObject.get("visible").getAsBoolean(), jsonObject.get("found").getAsBoolean(), jsonObject.get("requiredLineCode").getAsString());
        }
    }
}

