/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import ea.Bild;
import ea.Knoten;
import ea.Raum;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemAnimation
extends Knoten {
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    private List<ItemController.Item> items = new ArrayList<ItemController.Item>();
    private final String itemInitFilePath = "./Assets/Files/Items.json";
    private final String itemsFilePath = "./Assets/Items/";
    private Map<String, Bild> bigItemImgs = new HashMap<String, Bild>();
    private Bild headerImg;
    private final int displayduration = 600;
    private int tickCounter = 0;
    private boolean activ = false;

    public ItemAnimation() {
        this.readJSON();
        try {
            this.headerImg = new Bild(0.0f, 0.0f, "./Assets/Items/header.png");
            this.headerImg.sichtbarSetzen(false);
            this.add((Raum)this.headerImg);
            for (ItemController.Item item : this.items) {
                Bild newImg = new Bild(0.0f, 0.0f, "./Assets/Items/" + item.getName() + "Big.png");
                this.bigItemImgs.put(item.getName(), newImg);
                newImg.sichtbarSetzen(false);
                this.add((Raum)newImg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ItemAnimation: Fehler bei den Item Bilder");
        }
    }

    public void openAnimation(String itemName) {
        this.activ = true;
        this.tickCounter = 0;
        this.headerImg.sichtbarSetzen(true);
        this.bigItemImgs.get(itemName).sichtbarSetzen(true);
    }

    public void tick() {
        if (this.activ) {
            ++this.tickCounter;
            if (this.tickCounter >= 600) {
                this.tickCounter = 0;
                this.hideEverything();
            }
        }
    }

    public void hideEverything() {
        this.activ = false;
        this.headerImg.sichtbarSetzen(false);
        for (String key : this.bigItemImgs.keySet()) {
            this.bigItemImgs.get(key).sichtbarSetzen(false);
        }
    }

    public boolean isActiv() {
        return this.activ;
    }

    private void readJSON() {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)ItemController.Item.class), new ItemController.Deserializer()).excludeFieldsWithoutExposeAnnotation().create();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("./Assets/Files/Items.json"));
            Type ListType = new TypeToken<List<ItemController.Item>>(){}.getType();
            this.items = (List)gson.fromJson((Reader)bufferedReader, ListType);
            System.out.println("\u001b[32mItemController: JSON(./Assets/Files/Items.json) erfolgreich gelesen\u001b[0m");
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            System.out.println("\u001b[35mItemController: Ein Fehler beim Lesen der JSON(./Assets/Files/Items.json) Datei. Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
        }
    }
}

