/*
 * Decompiled with CFR 0.152.
 */
import ea.Bild;
import ea.Knoten;
import ea.Raum;

class ImageCollection2
extends Knoten {
    private int ImageCount = 2;
    private int AllImageCount = this.ImageCount * 4;
    private float posX;
    private float posY;
    private String MainDir;
    private int stepL = 0;
    private int stepR = 0;
    private int stepT = 0;
    private int stepB = 0;
    private int distanceL = 0;
    private int distanceR = 0;
    private int distanceT = 0;
    private int distanceB = 0;
    private int stepDistance = 20;
    private Bild[] ImgL = new Bild[this.ImageCount];
    private Bild[] ImgR = new Bild[this.ImageCount];
    private Bild[] ImgT = new Bild[this.ImageCount];
    private Bild[] ImgB = new Bild[this.ImageCount];
    private Bild[] ImgAll = new Bild[this.AllImageCount * 4];
    private Bild stillImg;

    public ImageCollection2(float x, float y, String MainDir) {
        this.posX = x;
        this.posY = y;
        this.MainDir = MainDir;
        String path = "./Assets/SpielerTest/still.png";
        try {
            this.stillImg = new Bild(this.posX, this.posY, path);
            this.add((Raum)this.stillImg);
        }
        catch (Exception e) {
            System.out.println("ImageCollection2: Fehler beim Lesen des still-Bilds an der Stelle: + " + path);
        }
    }

    public void HideAll() {
        for (int i = 0; i < this.AllImageCount; ++i) {
            this.ImgAll[i].sichtbarSetzen(false);
            this.stillImg.sichtbarSetzen(false);
        }
    }

    public void Init() {
        this.initL();
        this.initR();
        this.initT();
        this.initB();
        this.combineLists();
    }

    public void initL() {
        for (int i = 0; i < this.ImageCount; ++i) {
            String Dir = this.MainDir + "-L" + i + ".png";
            this.ImgL[i] = new Bild(this.posX, this.posY, Dir);
            this.add((Raum)this.ImgL[i]);
        }
    }

    public void initR() {
        for (int i = 0; i < this.ImageCount; ++i) {
            String Dir = this.MainDir + "-R" + i + ".png";
            this.ImgR[i] = new Bild(this.posX, this.posY, Dir);
            this.add((Raum)this.ImgR[i]);
        }
    }

    public void initT() {
        for (int i = 0; i < this.ImageCount; ++i) {
            String Dir = this.MainDir + "-T" + i + ".png";
            this.ImgT[i] = new Bild(this.posX, this.posY, Dir);
            this.add((Raum)this.ImgT[i]);
        }
    }

    public void initB() {
        for (int i = 0; i < this.ImageCount; ++i) {
            String Dir = this.MainDir + "-B" + i + ".png";
            this.ImgB[i] = new Bild(this.posX, this.posY, Dir);
            this.add((Raum)this.ImgB[i]);
        }
    }

    public void combineLists() {
        System.arraycopy(this.ImgL, 0, this.ImgAll, 0, this.ImageCount);
        System.arraycopy(this.ImgR, 0, this.ImgAll, this.ImageCount, this.ImageCount);
        System.arraycopy(this.ImgT, 0, this.ImgAll, this.ImageCount * 2, this.ImageCount);
        System.arraycopy(this.ImgB, 0, this.ImgAll, this.ImageCount * 3, this.ImageCount);
    }

    public void walkLeft(int dis) {
        this.distanceL += dis;
        this.HideAll();
        this.ImgL[this.stepL].sichtbarSetzen(true);
        if (this.distanceL >= this.stepDistance) {
            ++this.stepL;
            if (this.stepL >= this.ImageCount) {
                this.stepL = 0;
            }
            this.distanceL = 0;
        }
        this.verschieben(-dis, 0.0f);
    }

    public void walkRight(int dis) {
        this.distanceR += dis;
        this.HideAll();
        this.ImgR[this.stepR].sichtbarSetzen(true);
        if (this.distanceR >= this.stepDistance) {
            ++this.stepR;
            if (this.stepR >= this.ImageCount) {
                this.stepR = 0;
            }
            this.distanceR = 0;
        }
        this.verschieben(dis, 0.0f);
    }

    public void walkTop(int dis) {
        this.distanceT += dis;
        this.HideAll();
        this.ImgT[this.stepT].sichtbarSetzen(true);
        if (this.distanceT >= this.stepDistance) {
            ++this.stepT;
            if (this.stepT >= this.ImageCount) {
                this.stepT = 0;
            }
            this.distanceT = 0;
        }
        this.verschieben(0.0f, -dis);
    }

    public void walkBottom(int dis) {
        this.distanceB += dis;
        this.HideAll();
        this.ImgB[this.stepB].sichtbarSetzen(true);
        if (this.distanceB >= this.stepDistance) {
            ++this.stepB;
            if (this.stepB >= this.ImageCount) {
                this.stepB = 0;
            }
            this.distanceB = 0;
        }
        this.verschieben(0.0f, dis);
    }

    public void resetStep() {
        this.stepL = 0;
        this.stepB = 0;
        this.stepT = 0;
        this.stepR = 0;
    }

    @Override
    public void positionSetzen(float x, float y) {
        this.positionSetzen(x, y);
        this.posX = x;
        this.posY = y;
    }

    @Override
    public void verschieben(float dX, float dY) {
        this.posX += dX;
        this.posY += dY;
        super.verschieben(dX, dY);
    }
}

