/*
 * Decompiled with CFR 0.152.
 */
import ea.Bild;
import ea.Knoten;
import ea.Punkt;
import ea.Raum;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HelpingArrow
extends Knoten {
    private DialogController5 dialogController;
    private Player player;
    private Map3 map;
    private Map<Integer, Punkt> housePos = new HashMap<Integer, Punkt>(){};
    private Bild[] arrowImgs = new Bild[8];
    private Boolean[] arrowVisibility = new Boolean[8];
    private final String mainImgPath = "./Assets/HelpingArrow/";
    private int directionalOffsetToDiagonal = 200;

    public HelpingArrow(DialogController5 dC, Player p, Map3 m) {
        this.dialogController = dC;
        this.player = p;
        this.map = m;
        this.housePos.put(1, new Punkt(4970.0f, 1320.0f));
        this.housePos.put(3, new Punkt(845.0f, 2100.0f));
        this.housePos.put(2, new Punkt(724.0f, 4500.0f));
        this.housePos.put(0, new Punkt(6430.0f, 4200.0f));
        this.housePos.put(4, new Punkt(7940.0f, 240.0f));
        this.fillImgArray();
    }

    private void fillImgArray() {
        this.arrowImgs[0] = new Bild(0.0f, 0.0f, "./Assets/HelpingArrow/top.png");
        this.arrowImgs[1] = new Bild(0.0f, 0.0f, "./Assets/HelpingArrow/topRight.png");
        this.arrowImgs[2] = new Bild(0.0f, 0.0f, "./Assets/HelpingArrow/right.png");
        this.arrowImgs[3] = new Bild(0.0f, 0.0f, "./Assets/HelpingArrow/bottomRight.png");
        this.arrowImgs[4] = new Bild(0.0f, 0.0f, "./Assets/HelpingArrow/bottom.png");
        this.arrowImgs[5] = new Bild(0.0f, 0.0f, "./Assets/HelpingArrow/bottomLeft.png");
        this.arrowImgs[6] = new Bild(0.0f, 0.0f, "./Assets/HelpingArrow/left.png");
        this.arrowImgs[7] = new Bild(0.0f, 0.0f, "./Assets/HelpingArrow/topLeft.png");
        for (Bild b : this.arrowImgs) {
            this.add((Raum)b);
        }
    }

    public void updateArrows() {
        if (this.map.getHouseNumber() == -1) {
            List<NPC2> npcPos = this.dialogController.getHighlightedNpcObjects();
            float playerPosX = this.player.getPosX();
            float playerPosY = this.player.getPosY();
            Arrays.fill((Object[])this.arrowVisibility, (Object)false);
            for (NPC2 npc : npcPos) {
                float comparePosY;
                float comparePosX;
                if (npc.isInHouse()) {
                    Punkt houseLocation = this.housePos.get(npc.getHouseNumber());
                    comparePosX = houseLocation.x;
                    comparePosY = houseLocation.y;
                } else {
                    comparePosX = npc.getPosX();
                    comparePosY = npc.getPosY();
                }
                if (comparePosX > playerPosX) {
                    if (comparePosY > playerPosY) {
                        if (comparePosY - playerPosY < (float)this.directionalOffsetToDiagonal) {
                            this.arrowVisibility[2] = true;
                            continue;
                        }
                        if (comparePosX - playerPosX < (float)this.directionalOffsetToDiagonal) {
                            this.arrowVisibility[4] = true;
                            continue;
                        }
                        this.arrowVisibility[3] = true;
                        continue;
                    }
                    if (!(comparePosY < playerPosY)) continue;
                    if (playerPosY - comparePosY < (float)this.directionalOffsetToDiagonal) {
                        this.arrowVisibility[2] = true;
                        continue;
                    }
                    if (comparePosX - playerPosX < (float)this.directionalOffsetToDiagonal) {
                        this.arrowVisibility[0] = true;
                        continue;
                    }
                    this.arrowVisibility[1] = true;
                    continue;
                }
                if (comparePosY < playerPosY) {
                    if (playerPosY - comparePosY < (float)this.directionalOffsetToDiagonal) {
                        this.arrowVisibility[6] = true;
                        continue;
                    }
                    if (playerPosX - comparePosX < (float)this.directionalOffsetToDiagonal) {
                        this.arrowVisibility[0] = true;
                        continue;
                    }
                    this.arrowVisibility[7] = true;
                    continue;
                }
                if (!(comparePosY > playerPosY)) continue;
                if (comparePosY - playerPosY < (float)this.directionalOffsetToDiagonal) {
                    this.arrowVisibility[6] = true;
                    continue;
                }
                if (playerPosX - comparePosX < (float)this.directionalOffsetToDiagonal) {
                    this.arrowVisibility[4] = true;
                    continue;
                }
                this.arrowVisibility[5] = true;
            }
            this.snycArrowVisibility();
        } else {
            Arrays.fill((Object[])this.arrowVisibility, (Object)false);
            this.snycArrowVisibility();
        }
    }

    private void snycArrowVisibility() {
        for (int i = 0; i < this.arrowVisibility.length; ++i) {
            this.arrowImgs[i].sichtbarSetzen(this.arrowVisibility[i]);
        }
    }
}

