/*
 * Decompiled with CFR 0.152.
 */
import ea.Bild;
import ea.Knoten;

public class EndScreen
extends Knoten {
    private SoundController soundC;
    private boolean active = false;
    private Bild endingImg;
    private Bild backgroundImg;

    public EndScreen(SoundController sc) {
        this.soundC = sc;
        this.endingImg = new Bild(0.0f, 0.0f, "./Assets/EndScreen/endImg.png");
        this.backgroundImg = new Bild(0.0f, 0.0f, "./Assets/EndScreen/background.png");
        this.add(this.backgroundImg, this.endingImg);
        this.endingImg.sichtbarSetzen(false);
        this.backgroundImg.sichtbarSetzen(false);
    }

    public void playEnding(boolean isSad) {
        this.soundC.stopAllMusic();
        this.active = true;
        if (isSad) {
            this.playSadEnding();
        } else {
            this.playGoodEnding();
        }
        this.endingImg.sichtbarSetzen(true);
        this.backgroundImg.sichtbarSetzen(true);
    }

    public void tick() {
        if (this.active) {
            this.endingImg.verschieben(0.0f, -1.0f);
        }
    }

    public void playSadEnding() {
        this.soundC.playSadMusic();
    }

    public void playGoodEnding() {
        this.soundC.playHappyMusic();
    }

    public boolean isActive() {
        return this.active;
    }
}

