/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import ea.Bild;
import ea.Farbe;
import ea.Knoten;
import ea.Raum;
import ea.Text;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class DialogController5
extends Knoten {
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    private final String dialogLinesPath = "./Assets/Files/Dialoge.json";
    private final String dialogPacketsPath = "./Assets/Files/DialogPackets.json";
    private String globalTemporalPosition;
    private boolean active = false;
    private boolean waitingForInput = false;
    private final NpcController2 NPC_Controller2;
    private final GameSaver gameSaver;
    private final EndScreen endScreen;
    private final ComputerScreen computerScreen;
    private final FadeScreen fadeScreen;
    private Map<String, DialogLine> dialogLines;
    private Map<String, Map<String, List<DialogPacket>>> dialogPackets;
    private String defaultPath = "./Assets/Dialoge/";
    private Text displayTextObject;
    private Text displayTextNpcName;
    private Bild displayDialogBackgroundLeft;
    private Bild displayDialogBackgroundRight;
    private Bild displayArrowLeft;
    private Bild displayArrowRight;
    private final int textPosY = 675;
    private final int defaultTextSize = 28;
    private final int maxTextWidth = 800;
    private final int nameTextPosY = 625;
    private String currentDialogCode;
    private String lastDialogCode;
    private boolean lastLineHadChoice = false;
    private int selection = 0;
    private boolean playingLastLine = false;
    private Map<String, String> lastLines = new HashMap<String, String>(){};
    private Map<String, Bild> npcFaces = new HashMap<String, Bild>(){};
    private final int faceLocationX = 100;
    private final int faceLocationY = 620;
    private final int selfFaceLocationX = MAIN.x - 100;

    public DialogController5(NpcController2 NPC_C2, GameSaver gs, EndScreen eS, ComputerScreen cS, FadeScreen fS) {
        this.NPC_Controller2 = NPC_C2;
        this.gameSaver = gs;
        this.endScreen = eS;
        this.computerScreen = cS;
        this.fadeScreen = fS;
        this.readJSON_DialogLines();
        this.readJSON_DialogPackets();
        this.addDisplayObjects();
        this.globalTemporalPosition = this.gameSaver.getTemporalPosition();
        this.NPC_Controller2.updateNpcPositions(this.globalTemporalPosition);
    }

    private void addDisplayObjects() {
        try {
            this.displayDialogBackgroundLeft = new Bild(0.0f, 0.0f, this.defaultPath + "DialogFensterLeft.png");
            this.displayDialogBackgroundRight = new Bild(0.0f, 0.0f, this.defaultPath + "DialogFensterRight.png");
            this.displayDialogBackgroundLeft.sichtbarSetzen(false);
            this.displayDialogBackgroundRight.sichtbarSetzen(false);
            this.add(this.displayDialogBackgroundLeft, this.displayDialogBackgroundRight);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[35mDialogController5: FEHLER beim Importieren der Bilder\u001b[0m");
        }
        try {
            this.displayArrowLeft = new Bild(0.0f, 0.0f, this.defaultPath + "arrowLeft.png");
            this.displayArrowRight = new Bild(0.0f, 0.0f, this.defaultPath + "arrowRight.png");
            this.displayArrowLeft.sichtbarSetzen(false);
            this.displayArrowRight.sichtbarSetzen(false);
            this.add(this.displayArrowLeft, this.displayArrowRight);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[35mDialogController5: FEHLER beim Importieren der Bilder\u001b[0m");
        }
        HashMap<String, NPC2> NpcMap = this.NPC_Controller2.getNPCs();
        Bild selfFace = new Bild((float)this.selfFaceLocationX, 620.0f, "./Assets/SpielerTest/still.png");
        this.npcFaces.put("self", selfFace);
        this.add((Raum)selfFace);
        for (String name : NpcMap.keySet()) {
            try {
                Bild tempImg = new Bild(100.0f, 620.0f, "./Assets/NPCs/Faces/" + name + ".png");
                this.add((Raum)tempImg);
                tempImg.sichtbarSetzen(false);
                this.npcFaces.put(name, tempImg);
                System.out.println("DialogController5: Neues Gesicht hinzugef\u00fcgt mit dem name: " + name);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("DialogController5: FEHLER beim Importieren der Gesicht-Bilder");
            }
        }
        this.displayTextObject = new Text(MAIN.x / 2, 675.0f, "DEFAULT TEXT");
        this.displayTextObject.mittelpunktSetzen(MAIN.x / 2, 675);
        this.displayTextObject.farbeSetzen(new Farbe(0, 0, 0));
        this.displayTextObject.groesseSetzen(28);
        this.displayTextObject.setzeFont("Monospaced");
        this.add((Raum)this.displayTextObject);
        this.displayTextNpcName = new Text(MAIN.x / 2, 675.0f, "DEFAULT NPC NAME");
        this.displayTextNpcName.mittelpunktSetzen(MAIN.x / 2, 625);
        this.displayTextNpcName.farbeSetzen(new Farbe(0, 0, 0));
        this.displayTextNpcName.groesseSetzen(28);
        this.displayTextNpcName.setzeSchriftart(1);
        this.displayTextNpcName.setzeFont("Monospaced");
        this.add((Raum)this.displayTextNpcName);
        this.hideWindow();
    }

    public void startDialog(String npcID) {
        this.selection = 0;
        this.playingLastLine = false;
        this.waitingForInput = true;
        this.active = true;
        if (this.isDialogPacketPlayable(npcID)) {
            DialogPacket element = this.getPlayableDialogPacket(npcID);
            this.lastDialogCode = this.currentDialogCode = element.code;
            boolean bl = this.lastLineHadChoice = !this.dialogLines.get(this.currentDialogCode).hasNoChoice();
            if (this.lastLineHadChoice) {
                this.updateArrows();
            } else {
                this.hideAllArrows();
            }
            this.showWindow();
            this.displayDialogLine(this.currentDialogCode);
        } else {
            System.out.println("DialogController4: W\u00dcRDE JZ LASTLINE SPIELEN MACHT ES ABER AUS TESTGR\u00dcNDEN NOCH NICHT");
            this.playLastLine(npcID);
        }
    }

    public void highLightReadyNpcs() {
        this.NPC_Controller2.disguiseAllNPCs();
        for (String name : this.getHighlightedNpcNames()) {
            this.NPC_Controller2.highLightNpcsByName(name);
        }
    }

    public List<String> getHighlightedNpcNames() {
        ArrayList<String> nameList = new ArrayList<String>(){};
        for (String name : this.NPC_Controller2.getNPCs().keySet()) {
            if (!this.isDialogPacketPlayable(name)) continue;
            nameList.add(name);
        }
        return nameList;
    }

    public List<NPC2> getHighlightedNpcObjects() {
        ArrayList<NPC2> npcList = new ArrayList<NPC2>(){};
        for (String name : this.NPC_Controller2.getNPCs().keySet()) {
            if (!this.isDialogPacketPlayable(name)) continue;
            npcList.add(this.NPC_Controller2.getNPCs().get(name));
        }
        return npcList;
    }

    public void setNpcFace(String npcName) {
        this.hideAllFaces();
        if (npcName.equals("self")) {
            // empty if block
        }
        this.npcFaces.get(npcName).sichtbarSetzen(true);
    }

    public void hideAllFaces() {
        for (String name : this.npcFaces.keySet()) {
            this.npcFaces.get(name).sichtbarSetzen(false);
        }
    }

    private void saveLastLines() {
        for (String npcName : this.lastLines.keySet()) {
            if (npcName.equals("self")) continue;
            String code = this.lastLines.get(npcName);
            this.NPC_Controller2.setNpcLastLine(npcName, code);
        }
        this.lastLines.clear();
    }

    private void endDialog() {
        System.out.println("DER DIALOG WIRD BEENDET");
        this.active = false;
        this.waitingForInput = false;
        this.NPC_Controller2.resetToLastQuietPos();
        this.NPC_Controller2.updateNpcPositions(this.globalTemporalPosition);
        this.currentDialogCode = null;
        this.hideWindow();
        this.saveLastLines();
        this.highLightReadyNpcs();
        this.lineSpecialAction(this.globalTemporalPosition);
    }

    private void playLastLine(String npcID) {
        this.playingLastLine = true;
        System.out.println("DialogController5: playLastLine() aufgerufen");
        DialogLine lastLine = this.dialogLines.get(this.NPC_Controller2.getNpcLastLine(npcID));
        if (lastLine == null) {
            this.updateTextContent("FEHLER DER NPC HAT KEINE LASTLINE");
        } else {
            this.displayDialogLine(this.NPC_Controller2.getNpcLastLine(npcID));
        }
    }

    public void nextLine() {
        if (!this.playingLastLine) {
            System.out.println("DialogController5: Es wird die Zeile mit den Code: " + this.currentDialogCode + " abgespeichert!");
            this.gameSaver.addLine(this.currentDialogCode);
            this.lastDialogCode = this.currentDialogCode;
            boolean bl = this.lastLineHadChoice = !this.dialogLines.get(this.lastDialogCode).hasNoChoice();
            if (this.lastLineHadChoice) {
                this.updateArrows();
            } else {
                this.hideAllArrows();
            }
            DialogLine currentLine = this.dialogLines.get(this.currentDialogCode);
            if (currentLine.hasNextTime()) {
                this.globalTemporalPosition = currentLine.nextTime;
                System.out.println("Der Dialog wird jz beendet mit und es wird zur Zeit: " + this.currentDialogCode + " gewechselt!");
                this.endDialog();
            } else {
                if (currentLine.hasNoChoice()) {
                    System.out.println("Bei dem Dialog wird mit der 1.Wahl weitergemacht weile er keine Wahl hat");
                    this.currentDialogCode = currentLine.wahl1;
                } else if (this.selection == 0) {
                    System.out.println("Bei dem Dialog wird mit der 1.Wahl weitergemacht bei slection: " + this.selection);
                    this.currentDialogCode = currentLine.wahl1;
                } else if (this.selection == 1) {
                    System.out.println("Bei dem Dialog wird mit der 2.Wahl weitergemacht bei slection: " + this.selection);
                    this.currentDialogCode = currentLine.wahl2;
                }
                this.displayDialogLine(this.currentDialogCode);
            }
        } else {
            this.endDialog();
        }
    }

    private Stream<DialogPacket> getPlayableDialogs(String npcID) {
        return this.dialogPackets.getOrDefault(this.globalTemporalPosition, Collections.emptyMap()).getOrDefault(npcID, Collections.emptyList()).stream().filter(packet -> this.gameSaver.getItems().containsAll(packet.requiredItems) && this.gameSaver.getLines().containsAll(packet.requiredLines) && DialogController5.inverseContains(this.gameSaver.getLines(), packet.forbiddenLines));
    }

    private DialogPacket getPlayableDialogPacket(String npcID) {
        return this.getPlayableDialogs(npcID).findFirst().orElse(null);
    }

    public boolean isDialogPacketPlayable(String npcID) {
        return this.getPlayableDialogs(npcID).findAny().isPresent();
    }

    public void showWindow() {
        this.displayTextObject.sichtbarSetzen(true);
        this.displayTextNpcName.sichtbarSetzen(true);
        this.displayDialogBackgroundLeft.sichtbarSetzen(true);
        this.displayDialogBackgroundRight.sichtbarSetzen(true);
    }

    public void hideWindow() {
        this.hideAllFaces();
        this.displayTextObject.sichtbarSetzen(false);
        this.displayTextNpcName.sichtbarSetzen(false);
        this.displayDialogBackgroundLeft.sichtbarSetzen(false);
        this.displayDialogBackgroundRight.sichtbarSetzen(false);
        this.hideAllArrows();
    }

    public void lineSpecialAction(String timeCode) {
        System.out.println("DialogController5: lineSpecialAction() aufegerufen mit der Zeit: " + timeCode);
        switch (timeCode) {
            case "Ende(felix)": 
            case "Ende (Posts gel\u00f6scht)": {
                this.endScreen.playEnding(false);
                break;
            }
            case "Ende(Tim)": 
            case "Tag 5 Ende(Acc gel\u00f6scht)": {
                this.endScreen.playEnding(true);
                break;
            }
            case "Tag 1 Abschnitt 3": {
                this.computerScreen.viewPost1();
                break;
            }
            case "Tag 3 Abschnitt 2": {
                this.computerScreen.viewPost2();
                break;
            }
            case "Tag 2 Abschnitt 1": 
            case "Tag 3 Abschnitt 1": 
            case "Tag 4 Abschnitt 1": 
            case "Tag 5 Abschnitt 1": {
                this.fadeScreen.startBlackFade();
                break;
            }
        }
    }

    public void displayDialogLine(String lineCode) {
        DialogLine dL = this.dialogLines.get(lineCode);
        this.setNpcFace(dL.name);
        this.setDialogWindowDir(dL.isSelf());
        this.updatePartnerName(dL.name, dL.isSelf());
        this.updateTextContent(dL.inhalt);
        System.out.println("DialogController5: Zeigt jetzt die Zeile: " + lineCode + " an!");
        this.lastLines.put(dL.name, lineCode);
    }

    public void updatePartnerName(String name, boolean isSelf) {
        if (isSelf) {
            String inhalt = "Antwort:";
            this.displayTextNpcName.inhaltSetzen(inhalt);
            this.displayTextNpcName.mittelpunktSetzen(MAIN.x / 2, 625);
            this.displayTextNpcName.sichtbarSetzen(true);
        } else {
            String displayName = this.NPC_Controller2.getNPCs().get((Object)name).displayName;
            if (displayName.equals("")) {
                this.displayTextNpcName.sichtbarSetzen(false);
            } else {
                String inhalt = displayName + ":";
                this.displayTextNpcName.inhaltSetzen(inhalt);
                this.displayTextNpcName.mittelpunktSetzen(MAIN.x / 2, 625);
                this.displayTextNpcName.sichtbarSetzen(true);
            }
        }
    }

    public void updateTextContent(String inhalt) {
        this.displayTextObject.sichtbarSetzen(true);
        this.displayTextObject.inhaltSetzen(inhalt);
        this.displayTextObject.groesseSetzen(28);
        while (this.displayTextObject.getBreite() > 800.0f) {
            this.displayTextObject.groesseSetzen(this.displayTextObject.groesse() - 1);
        }
        this.displayTextObject.mittelpunktSetzen(MAIN.x / 2, 675);
    }

    public void setDialogWindowDir(boolean isSelf) {
        this.displayDialogBackgroundLeft.sichtbarSetzen(false);
        this.displayDialogBackgroundRight.sichtbarSetzen(false);
        if (!isSelf) {
            this.displayDialogBackgroundLeft.sichtbarSetzen(true);
        } else {
            this.displayDialogBackgroundRight.sichtbarSetzen(true);
        }
    }

    public void updateArrows() {
        if (this.isLastLineHadChoice()) {
            this.hideAllArrows();
            if (this.selection == 0) {
                this.displayArrowRight.sichtbarSetzen(true);
            } else {
                this.displayArrowLeft.sichtbarSetzen(true);
            }
        } else {
            System.out.println("DialogController5: Komischer Fehler in updateArrows()");
        }
    }

    public void hideAllArrows() {
        this.displayArrowLeft.sichtbarSetzen(false);
        this.displayArrowRight.sichtbarSetzen(false);
    }

    public void input(String dir) {
        if (this.isWaitingForInput()) {
            switch (dir) {
                case "links": {
                    if (this.lastLineHadChoice) {
                        --this.selection;
                        if (this.selection < 0) {
                            this.selection = 0;
                        }
                        this.currentDialogCode = this.dialogLines.get((Object)this.lastDialogCode).wahl1;
                        this.displayDialogLine(this.currentDialogCode);
                        this.updateArrows();
                        break;
                    }
                    this.selection = 0;
                    break;
                }
                case "rechts": {
                    if (this.lastLineHadChoice) {
                        ++this.selection;
                        if (this.selection > 1) {
                            this.selection = 1;
                        }
                        this.currentDialogCode = this.dialogLines.get((Object)this.lastDialogCode).wahl2;
                        this.displayDialogLine(this.currentDialogCode);
                        this.updateArrows();
                        break;
                    }
                    this.selection = 0;
                    break;
                }
                case "enter": {
                    this.nextLine();
                    break;
                }
                default: {
                    System.out.println("\u001b[35mDialogController4: FEHLER Kein valider Input\u001b[0m");
                    break;
                }
            }
        } else {
            System.out.println("\u001b[35mDialogController4: FEHLER: wartet nicht auf Input\u001b[0m");
        }
    }

    public String getGlobalTemporalPosition() {
        return this.globalTemporalPosition;
    }

    public boolean isWaitingForInput() {
        return this.waitingForInput;
    }

    public String getCurrentDialogCode() {
        return this.currentDialogCode;
    }

    public boolean isLastLineHadChoice() {
        return this.lastLineHadChoice;
    }

    public static <T> boolean inverseContains(List<T> a, List<T> b) {
        if (b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.stream().noneMatch(b::contains);
    }

    public boolean isActive() {
        return this.active;
    }

    public int getSelection() {
        return this.selection;
    }

    private void readJSON_DialogLines() {
        Gson gson = new Gson();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("./Assets/Files/Dialoge.json"));
            Type MapType = new TypeToken<Map<String, DialogLine>>(){}.getType();
            this.dialogLines = (Map)gson.fromJson((Reader)bufferedReader, MapType);
            System.out.println();
            System.out.println("\u001b[32mDialogController5: JSON(./Assets/Files/Dialoge.json)  erfolgreich gelesen\u001b[0m");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[35mDialogController5: Ein Fehler beim Lesen der Json Datei(./Assets/Files/Dialoge.json ). Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
        }
    }

    private void readJSON_DialogPackets() {
        Gson gson = new Gson();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("./Assets/Files/DialogPackets.json"));
            Type MapType = new TypeToken<Map<String, Map<String, List<DialogPacket>>>>(){}.getType();
            this.dialogPackets = (Map)gson.fromJson((Reader)bufferedReader, MapType);
            System.out.println("\u001b[32mDialogController5: JSON(./Assets/Files/DialogPackets.json)  erfolgreich gelesen\u001b[0m");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[35mDialogController5: FEHLEE beim Lesen der Json Datei(./Assets/Files/DialogPackets.json ). Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
        }
    }

    public class DialogPacket {
        ArrayList<String> requiredItems;
        ArrayList<String> requiredLines;
        ArrayList<String> forbiddenLines;
        String code;
    }

    public class DialogLine {
        String inhalt;
        String name;
        String wahl1;
        String wahl2;
        String nextTime;

        public String toString() {
            return "DialogLine{inhalt='" + this.inhalt + '\'' + ", name='" + this.name + '\'' + ", wahl1='" + this.wahl1 + '\'' + ", wahl2='" + this.wahl2 + '\'' + ", nextTime='" + this.nextTime + '\'' + '}';
        }

        public boolean isSelf() {
            return this.name.equals("self");
        }

        public boolean hasNextTime() {
            return !this.nextTime.equals("");
        }

        public boolean hasNoChoice() {
            return this.wahl2.equals("");
        }
    }

    public class NpcPosition {
        private String name;
        private float posX;
        private float posY;
        private int houseN;

        public NpcPosition(String name, int x, int y, int hn) {
            this.name = name;
            this.posX = x;
            this.posY = y;
            this.houseN = hn;
        }

        public float getPosX() {
            return this.posX;
        }

        public float getPosY() {
            return this.posY;
        }

        public int getHouseN() {
            return this.houseN;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInHouse() {
            return this.houseN > -1;
        }
    }
}

