/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import ea.Bild;
import ea.Knoten;
import ea.Raum;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DialogChecker {
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    private final String dialogLinesPath = "./Assets/Files/Dialoge.json";
    private final String dialogPacketsPath = "./Assets/Files/DialogPackets.json";
    private final String itemInitFilePath = "./Assets/Files/Items.json";
    private final String npcFilePath = "./Assets/Files/NPCs-Template.json";
    private Map<String, DialogLine> dialogLines;
    private Map<String, Map<String, List<DialogPacket>>> dialogPackets;
    private HashMap<String, NPC2> NPCs;
    private List<Item> items = new ArrayList<Item>();

    public DialogChecker() {
        System.out.println("DIALOGCHECKER GESTARTET");
        this.readJSON_DialogLines();
        this.readJSON_DialogPackets();
        this.readJSON_NPCs();
        this.readJSON_Item();
        System.out.println("ITEMS:" + this.items);
        this.checkEveryLine();
        this.checkEveryPacket();
    }

    public void checkEveryLine() {
        System.out.println("\u001b[32mDialogChecker: checkEveryLine() aufgerufen\u001b[0m");
        for (String timeStamp : this.dialogLines.keySet()) {
            DialogLine dialogLine = this.dialogLines.get(timeStamp);
            if (this.NPCs.containsKey(dialogLine.name)) {
                if (!dialogLine.wahl1.equals("") && dialogLine.nextTime.equals("")) {
                    if (this.dialogLines.containsKey(dialogLine.wahl1)) {
                        if (dialogLine.wahl2.equals("") || this.dialogLines.containsKey(dialogLine.wahl2)) {
                            if (dialogLine.wahl2.equals("") || this.dialogLines.containsKey(dialogLine.wahl2)) {
                                if (!dialogLine.inhalt.equals("")) continue;
                                System.out.println("\u001b[35mDialogChecker: FEHLER: In der DialogLine (" + timeStamp + ") ist der Inhalt leer");
                                continue;
                            }
                            System.out.println("\u001b[35mDialogChecker: FEHLER: In der DialogLine (" + timeStamp + ") ist die wahl2 kein Code der sonst der nochmal irgendwo vorkommt. Falsche Verlinkung");
                            continue;
                        }
                        System.out.println("\u001b[35mDialogChecker: FEHLER: In der DialogLine (" + timeStamp + ") ist die wahl2 leer, oder kein Code der sonst der nochmal irgendwo vorkommt. Falsche Verlinkung oder leeer!");
                        continue;
                    }
                    System.out.println("\u001b[35mDialogChecker: FEHLER: In der DialogLine (" + timeStamp + ") ist die wahl1 kein Code der sonst der nochmal irgendwo vorkommt. Falsche Verlinkung!");
                    continue;
                }
                if (!dialogLine.nextTime.equals("")) {
                    if (this.dialogPackets.containsKey(dialogLine.nextTime)) continue;
                    System.out.println("\u001b[35mDialogChecker: FEHLER: In der DialogLine (" + timeStamp + ") zwar eine NextTime, aber diese ist nicht ein valider Code");
                    continue;
                }
                System.out.println("\u001b[35mDialogChecker: FEHLER: In der DialogLine (" + timeStamp + ") ist die wahl1 leer und NextTime ist auch leer");
                continue;
            }
            System.out.println("\u001b[35mDialogChecker: FEHLER: In der DialogLine (" + timeStamp + ") ist ein Namen, den es in NPCs-NEW nicht gibt!");
        }
    }

    public void checkEveryPacket() {
        System.out.println("\u001b[32mDialogChecker: checkEveryPacket() aufgerufen\u001b[0m");
        ArrayList<String> itemStringList = new ArrayList<String>();
        for (Item s : this.items) {
            itemStringList.add(s.name);
        }
        for (String timeCode : this.dialogPackets.keySet()) {
            Map<String, List<DialogPacket>> packetOccs = this.dialogPackets.get(timeCode);
            for (String npcName : packetOccs.keySet()) {
                List<DialogPacket> packets = packetOccs.get(npcName);
                if (this.NPCs.containsKey(npcName)) {
                    for (DialogPacket packet : packets) {
                        if (this.dialogLines.containsKey(packet.code)) {
                            if (itemStringList.containsAll(packet.requiredItems)) {
                                if (packet.forbiddenLines == null) continue;
                                for (String s : packet.forbiddenLines) {
                                    if (this.dialogLines.containsKey(s)) continue;
                                    System.out.println("\u001b[35mDialogChecker: FEHLER: In dem DialogPacket (" + timeCode + ") ist der NPC names: " + npcName + " vorhanden, aber eine forbiddenLine ist nicht in " + "./Assets/Files/NPCs-Template.json" + " nicht vorhanden.");
                                }
                                continue;
                            }
                            System.out.println("\u001b[35mDialogChecker: FEHLER: In dem DialogPacket (" + timeCode + ") ist der NPC names: " + npcName + " vorhanden, aber ein requiredItem in einem Packet ist nicht in " + "./Assets/Files/Items.json" + " nicht vorhanden.");
                            continue;
                        }
                        System.out.println("\u001b[35mDialogChecker: FEHLER: In dem DialogPacket (" + timeCode + ") ist der NPC names: " + npcName + " vorhanden, aber ein Code in einem Packet ist nicht in " + "./Assets/Files/NPCs-Template.json" + " nicht vorhanden.");
                    }
                    continue;
                }
                System.out.println("\u001b[35mDialogChecker: FEHLER: In dem DialogPacket (" + timeCode + ") ist der NPC names: " + npcName + " vorhanden, dieser ist jedoch nicht in NPCs-NEW dabei");
            }
        }
    }

    private void readJSON_Item() {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Item.class), new Deserializer()).excludeFieldsWithoutExposeAnnotation().create();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("./Assets/Files/Items.json"));
            Type ListType = new TypeToken<List<Item>>(){}.getType();
            this.items = (List)gson.fromJson((Reader)bufferedReader, ListType);
            System.out.println("\u001b[32mItemController: JSON(./Assets/Files/Items.json) erfolgreich gelesen\u001b[0m");
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            System.out.println("\u001b[35mItemController: Ein Fehler beim Lesen der JSON(./Assets/Files/Items.json) Datei. Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
        }
    }

    private void readJSON_DialogLines() {
        Gson gson = new Gson();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("./Assets/Files/Dialoge.json"));
            Type MapType = new TypeToken<Map<String, DialogLine>>(){}.getType();
            this.dialogLines = (Map)gson.fromJson((Reader)bufferedReader, MapType);
            System.out.println();
            System.out.println("\u001b[32mDialogChecker: JSON(./Assets/Files/Dialoge.json)  erfolgreich gelesen\u001b[0m");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[35mDialogChecker: Ein Fehler beim Lesen der Json Datei(./Assets/Files/Dialoge.json ). Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
        }
    }

    private void readJSON_DialogPackets() {
        Gson gson = new Gson();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("./Assets/Files/DialogPackets.json"));
            Type MapType = new TypeToken<Map<String, Map<String, List<DialogPacket>>>>(){}.getType();
            this.dialogPackets = (Map)gson.fromJson((Reader)bufferedReader, MapType);
            System.out.println("\u001b[32mDialogChecker: JSON(./Assets/Files/DialogPackets.json)  erfolgreich gelesen\u001b[0m");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[35mDialogChecker: FEHLEE beim Lesen der Json Datei(./Assets/Files/DialogPackets.json ). Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
        }
        System.out.println("DialogPacket:" + this.dialogPackets);
    }

    private void readJSON_NPCs() {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)NPC2.class), new NPC2.Deserializer()).excludeFieldsWithoutExposeAnnotation().create();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("./Assets/Files/NPCs-Template.json"));
            Type MapType = new TypeToken<HashMap<String, NPC2>>(){}.getType();
            this.NPCs = (HashMap)gson.fromJson((Reader)bufferedReader, MapType);
            System.out.println("\u001b[32mDialogChecker: JSON(./Assets/Files/NPCs-Template.json) erfolgreich gelesen\u001b[0m");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\u001b[35mDialogChecker: Ein Fehler beim Lesen der JSON(./Assets/Files/NPCs-Template.json) Datei. Entweder Pfad flasch, oder JSON Struktur.\u001b[0m");
        }
        this.NPCs.put("self", null);
    }

    public class DialogLine {
        String inhalt;
        String name;
        String wahl1;
        String wahl2;
        String nextTime;

        public String toString() {
            return "DialogLine{inhalt='" + this.inhalt + '\'' + ", name='" + this.name + '\'' + ", wahl1='" + this.wahl1 + '\'' + ", wahl2='" + this.wahl2 + '\'' + ", nextTime='" + this.nextTime + '\'' + '}';
        }
    }

    public static class Item
    extends Knoten {
        private String mainPath = "./Assets/Items/";
        private Bild img;
        @Expose
        private String name;
        @Expose
        private float posX;
        @Expose
        private float posY;
        @Expose
        private float relativePosX;
        @Expose
        private float relativePosY;
        @Expose
        private int houseN;
        @Expose
        private boolean visible;

        private Item(String n, float x, float y, float rX, float rY, int hn, boolean vb) {
            this.name = n;
            this.posX = x;
            this.posY = y;
            this.relativePosX = rX;
            this.relativePosY = rY;
            this.houseN = hn;
            this.visible = vb;
            try {
                String path = this.mainPath + this.name + ".png";
                this.img = new Bild(this.posX, this.posY, path);
                this.add((Raum)this.img);
                this.sichtbarSetzen(this.visible);
            }
            catch (Exception e) {
                System.out.println("Item: Fehler beim importieren der Datei");
                System.out.println("Item: " + e);
            }
        }

        private void showItem() {
            this.visible = true;
            this.sichtbarSetzen(true);
        }

        private void hideItem() {
            this.visible = false;
            this.sichtbarSetzen(false);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Item{mainPath='" + this.mainPath + '\'' + ", img=" + this.img + ", name='" + this.name + '\'' + ", posX=" + this.posX + ", posY=" + this.posY + ", relativePosX=" + this.relativePosX + ", relativePosY=" + this.relativePosY + ", houseN=" + this.houseN + ", visible=" + this.visible + '}';
        }
    }

    public class DialogPacket {
        ArrayList<String> requiredItems;
        ArrayList<String> requiredLines;
        ArrayList<String> forbiddenLines;
        String code;
    }

    public static class Deserializer
    implements JsonDeserializer<Item> {
        @Override
        public Item deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = (JsonObject)jsonElement;
            return new Item(jsonObject.get("name").getAsString(), jsonObject.get("posX").getAsInt(), jsonObject.get("posY").getAsInt(), jsonObject.get("relativePosX").getAsInt(), jsonObject.get("relativePosY").getAsInt(), jsonObject.get("houseN").getAsInt(), jsonObject.get("visible").getAsBoolean());
        }
    }

    public class NpcPosition {
        private String name;
        private float posX;
        private float posY;
        private int houseN;

        public NpcPosition(String name, int x, int y, int hn) {
            this.name = name;
            this.posX = x;
            this.posY = y;
            this.houseN = hn;
        }

        public float getPosX() {
            return this.posX;
        }

        public float getPosY() {
            return this.posY;
        }

        public int getHouseN() {
            return this.houseN;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInHouse() {
            return this.houseN > -1;
        }
    }
}

