/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class Logger {
    private static BufferedWriter writer;

    private Logger() {
    }

    public static void warning(String s) {
        StackTraceElement e = Thread.currentThread().getStackTrace()[2];
        Logger.write("WARNUNG", e.getFileName(), e.getLineNumber(), s);
    }

    private static String write(String type, String filename, int line, String message) {
        return Logger.write(type, filename, line, message, false);
    }

    private static String write(String type, String filename, int line, String message, boolean error) {
        String str = String.format("[%s][%s] %s (%s:%s)", Logger.getTime(), type, message, filename, Integer.toString(line));
        if (error) {
            System.err.println(str);
        } else {
            System.out.println(str);
        }
        return Logger.write(str);
    }

    private static String getTime() {
        return new Date().toString();
    }

    private static String write(String text) {
        try {
            writer.write(text);
            writer.newLine();
            return text;
        }
        catch (IOException e) {
            System.err.println("Logger konnte folgende Zeile nicht schreiben:\n" + text);
            return null;
        }
    }

    public static void error(String s) {
        StackTraceElement e = Thread.currentThread().getStackTrace()[2];
        Logger.write("ERROR", e.getFileName(), e.getLineNumber(), s, true);
    }

    public static void info(String s) {
        StackTraceElement e = Thread.currentThread().getStackTrace()[2];
        Logger.write("INFO", e.getFileName(), e.getLineNumber(), s);
    }

    static {
        try {
            writer = new BufferedWriter(new FileWriter("engine-alpha.log", false));
        }
        catch (IOException e) {
            File ea = new File("engine-alpha.log");
            if (ea.isDirectory()) {
                System.err.println("Logger konnte nicht initialisiert werden, da 'engine-alpha.log' ein Verzeichnis ist!");
                System.exit(1);
            }
            if (!ea.canWrite()) {
                System.err.println("Logger konnte nicht initialisiert werden, da 'engine-alpha.log' nicht beschreibbar ist!");
                System.exit(1);
            }
            System.err.println("Logger konnte aus unbekannten Gr\u00fcnden nicht initialisiert werden!");
            System.exit(1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

