/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.sound;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class SampledSound
extends Thread {
    private State state;
    private byte[] data;
    private boolean loop;
    private AudioInputStream ais;
    private SourceDataLine line;

    public SampledSound(byte[] data, boolean loop) {
        this.setDaemon(true);
        this.init(data, loop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(byte[] data, boolean loop) {
        this.data = data;
        this.loop = loop;
        if (this.ais != null) {
            try {
                this.ais.close();
                this.ais = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ByteArrayInputStream is = new ByteArrayInputStream((byte[])this.data.clone());
        try {
            AudioInputStream tmp;
            this.ais = AudioSystem.getAudioInputStream(is);
            AudioFormat baseFormat = this.ais.getFormat();
            AudioFormat decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, baseFormat.getSampleRate(), 16, baseFormat.getChannels(), baseFormat.getChannels() * 2, baseFormat.getSampleRate(), false);
            this.ais = tmp = AudioSystem.getAudioInputStream(decodedFormat, this.ais);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void start() {
        if (this.startLine()) {
            super.start();
        }
    }

    @Override
    public void run() {
        this.playSound();
        this.state = State.STOPPED;
    }

    private boolean startLine() {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.ais.getFormat());
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(this.ais.getFormat());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.line.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void playSound() {
        int num = 0;
        byte[] buffer = new byte[1024];
        try {
            while (num != -1) {
                if (this.state == State.PAUSED) {
                    try {
                        SampledSound sampledSound = this;
                        synchronized (sampledSound) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        this.state = State.STOPPED;
                    }
                }
                if (this.state == State.STOPPED) {
                    this.line.start();
                    this.line.flush();
                    break;
                }
                num = this.ais.read(buffer, 0, buffer.length);
                if (num < 0) continue;
                this.line.write(buffer, 0, num);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.ais.close();
                this.ais = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.loop && this.state != State.STOPPED) {
                this.init(this.data, true);
                this.playSound();
            } else {
                this.line.drain();
                this.line.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSound(boolean pause) {
        this.state = pause ? State.PAUSED : State.PLAYING;
        SampledSound sampledSound = this;
        synchronized (sampledSound) {
            if (!pause) {
                this.notify();
            }
        }
    }

    public void stopSound() {
        this.state = State.STOPPED;
    }

    private static enum State {
        PLAYING,
        PAUSED,
        STOPPED;

    }
}

