/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.phy;

import ea.BoundingRechteck;
import ea.FallDummy;
import ea.FallReagierbar;
import ea.Raum;
import ea.StehReagierbar;
import ea.Vektor;
import ea.internal.phy.Physik;
import ea.internal.phy.PhysikClient;
import ea.internal.phy.StehDummy;
import ea.internal.util.Logger;

public class Gravitator
extends PhysikClient {
    private final Physik physik = Physik.getPhysik();
    private int schwerkraft = 4;
    private int yTrend = 0;
    private int zaehler = 1;
    private boolean sprungStart = false;
    private boolean zuletztGefallen = false;
    private boolean hatSchwerkraft = true;
    private FallReagierbar fListener = FallDummy.getDummy();
    private StehReagierbar sListener = StehDummy.getDummy();
    private int kritischeTiefe;
    private float remainderX = 0.0f;
    private float remainderY = 0.0f;

    public Gravitator(Raum ziel) {
        super(ziel);
        this.physik.aktivAnmelden(this);
    }

    public void tick(int runde) {
        this.ziel.verschieben(this.physik.entblocken(this.ziel.dimension()));
        if (this.ziel.dimension().y > (float)this.kritischeTiefe) {
            this.fListener.fallReagieren();
        }
        if (runde != 1) {
            return;
        }
        if (!this.hatSchwerkraft) {
            return;
        }
        boolean steht = this.steht();
        if (!steht) {
            if (this.zaehler % this.schwerkraft == 0) {
                if (this.yTrend < 10) {
                    this.zaehler = 1;
                    ++this.yTrend;
                }
            } else {
                ++this.zaehler;
            }
        } else if (!this.sprungStart) {
            if (this.zuletztGefallen) {
                this.sListener.stehReagieren();
            }
            this.yTrend = 0;
            this.zuletztGefallen = false;
            this.zaehler = 1;
        } else {
            this.sprungStart = false;
            this.zuletztGefallen = false;
        }
        this.bewegen(new Vektor(0.0f, this.yTrend));
    }

    @Override
    public boolean bewegen(Vektor v) {
        this.ziel.verschieben(this.physik.entblocken(this.ziel.dimension()));
        return this.xVersch(v.x) & this.yVersch(v.y);
    }

    @Override
    public void aufloesen() {
        this.physik.aktivAbmelden(this);
    }

    @Override
    public boolean sprung(int kraft) {
        if (!this.hatSchwerkraft) {
            Logger.error("Achtung! Ein Raum-Objekt, fuer das KEINE Schwerkraft gilt, kann nicht springen!");
            return false;
        }
        if (this.steht()) {
            this.yTrend = -kraft;
            this.sprungStart = true;
            return true;
        }
        return false;
    }

    @Override
    public void schwerkraftAktivSetzen(boolean aktiv) {
        this.hatSchwerkraft = aktiv;
    }

    @Override
    public void kritischeTiefeSetzen(int tiefe) {
        this.kritischeTiefe = tiefe;
    }

    @Override
    public void fallReagierbarAnmelden(FallReagierbar f, int tiefe) {
        this.fListener = f;
        this.kritischeTiefe = tiefe;
    }

    @Override
    public void stehReagierbarAnmelden(StehReagierbar s) {
        this.sListener = s;
    }

    @Override
    public boolean steht() {
        BoundingRechteck test = this.ziel.dimension().verschobeneInstanz(new Vektor(0.0f, 1.0f));
        return this.physik.inPassivem(test);
    }

    @Override
    public void schwerkraftSetzen(int schwerkraft) {
        this.schwerkraft = schwerkraft;
    }

    @Override
    public void impulsHinzunehmen(Vektor impuls) {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keine Impulsrechnung. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void geschwindigkeitHinzunehmen(Vektor geschwindigkeit) {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keine Geschwindigkeit. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public float getLuftwiderstandskoeffizient() {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keinen Luftwiderstand. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
        return 0.0f;
    }

    @Override
    public boolean istBeeinflussbar() {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keinen Beeinflussbarkeit. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
        return false;
    }

    @Override
    public float getMasse() {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keine Masse. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
        return 0.0f;
    }

    @Override
    public Vektor getForce() {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keine Kraftrechnung. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
        return null;
    }

    @Override
    public void luftwiderstandskoeffizientSetzen(float luftwiderstandskoeffizient) {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keinen Luftwiderstand. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void beeinflussbarSetzen(boolean beeinflussbar) {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keinen Beeinflussbarkeit. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void masseSetzen(float masse) {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keine Masse. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void kraftSetzen(Vektor kraft) {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keine Kraftrechnung. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void geschwindigkeitSetzen(Vektor geschwindigkeit) {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keine Geschwindigkeit. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void einfluesseZuruecksetzen() {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keine Einfl\u00fcsse. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    @Override
    public void kraftAnwenden(Vektor kraft, float t_kraftuebertrag) {
        Logger.error("Aktivobjekte unterst\u00fctzen leider keine Kraftrechnung. Daf\u00fcr gibt es die Newton-K\u00f6rper!");
    }

    public boolean xVersch(float dX) {
        int max;
        float z;
        if ((dX += this.remainderX) > 0.0f) {
            z = 1.0f;
            max = (int)dX;
        } else if (dX < 0.0f) {
            z = -1.0f;
            max = -((int)dX);
        } else {
            this.remainderX = dX;
            return true;
        }
        Vektor v = new Vektor(z, 0.0f);
        for (int i = 0; i < max; ++i) {
            BoundingRechteck test = this.ziel.dimension().verschobeneInstanz(v);
            if (this.physik.inPassivem(test)) {
                return false;
            }
            this.ziel.verschieben(v);
            dX -= z;
        }
        this.remainderX = dX;
        return true;
    }

    public boolean yVersch(float dY) {
        int max;
        float z;
        if ((dY += this.remainderX) > 0.0f) {
            z = 1.0f;
            max = (int)dY;
        } else if (dY < 0.0f) {
            z = -1.0f;
            max = -((int)dY);
        } else {
            this.remainderY = dY;
            return true;
        }
        Vektor v = new Vektor(0.0f, z);
        for (int i = 0; i < max; ++i) {
            BoundingRechteck test = this.ziel.dimension().verschobeneInstanz(v);
            if (this.physik.inPassivem(test)) {
                this.yTrend = 0;
                if (z > 0.0f) {
                    this.sListener.stehReagieren();
                }
                this.zuletztGefallen = false;
                return false;
            }
            this.zuletztGefallen = true;
            this.ziel.verschieben(v);
            dY -= z;
        }
        this.remainderY = dY;
        return true;
    }
}

