/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.io;

import ea.internal.util.Logger;
import ea.internal.util.Optimizer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageLoader {
    private ImageLoader() {
    }

    public static BufferedImage loadExternalImage(String path) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(new FileInputStream(new File(path)));
            img = Optimizer.toCompatibleImage(img);
        }
        catch (IOException e) {
            Logger.error("Das Bild konnte nicht geladen werden: " + path);
        }
        return img;
    }

    public static BufferedImage loadInternalImage(String path) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(ImageLoader.class.getResource(path));
            img = Optimizer.toCompatibleImage(img);
        }
        catch (IOException e) {
            Logger.error("Das Bild konnte nicht geladen werden: " + path);
        }
        return img;
    }
}

