/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.gui;

import ea.internal.util.Logger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class HighScoreFenster
extends JDialog {
    public HighScoreFenster(Frame parent, String titel, String[] namen, int[] punkte, Font font) {
        super(parent, titel, true);
        if (namen.length != punkte.length) {
            Logger.error("Achtung!! Die eingegebenen String- und int-Arrays haben nicht die selbe Laenge!!!");
            return;
        }
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setLocation(screenSize.width / 4, screenSize.height / 4);
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(namen.length, 3, 5, 5));
        for (int i = 0; i < namen.length; ++i) {
            JLabel l1 = new JLabel("" + (i + 1) + ".");
            l1.setFont(font);
            panel.add(l1);
            JLabel l2 = new JLabel(namen[i]);
            l2.setFont(font);
            panel.add(l2);
            JLabel l3 = new JLabel("" + punkte[i]);
            l3.setFont(font);
            panel.add(l3);
        }
        this.getContentPane().add((Component)new JScrollPane(panel), "Center");
        JButton b = new JButton("OK");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HighScoreFenster.this.dispose();
            }
        });
        this.getContentPane().add((Component)b, "South");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            Logger.error(e.getLocalizedMessage());
        }
        this.validate();
        this.pack();
        this.setSize(200, 300);
        this.setVisible(true);
    }
}

