/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.gui;

import ea.BoundingRechteck;
import ea.Kamera;
import ea.Knoten;
import ea.Manager;
import ea.Maus;
import ea.Punkt;
import ea.Raum;
import ea.SimpleGraphic;
import ea.Taste;
import ea.TastenLosgelassenReagierbar;
import ea.TastenReagierbar;
import ea.Ticker;
import ea.Vektor;
import ea.internal.gra.Zeichenebene;
import ea.internal.gra.Zeichner;
import ea.internal.gui.Adapter;
import ea.internal.util.Logger;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class Fenster
extends Frame {
    private static final long serialVersionUID = 1L;
    public static Fenster instanz = null;
    private static volatile int frameCount = 0;
    private final boolean vollbild;
    private final Zeichner zeichner;
    private final List<TastenReagierbar> listener = new ArrayList<TastenReagierbar>();
    private final List<TastenLosgelassenReagierbar> losListener = new ArrayList<TastenLosgelassenReagierbar>();
    private volatile boolean mausAusBild = false;
    private boolean zaehlt = true;
    private volatile Maus maus = null;
    private Robot robot;
    private Raum mausBild;
    private volatile boolean[] tabelle;
    private Point lastMousePosition;

    public Fenster(int x, int y) {
        this(x, y, "EngineAlpha - Ein Projekt von Michael Andonie", false, 50, 50);
    }

    public Fenster(int breite, int hoehe, String titel, boolean vollbild, int fensterX, int fensterY) {
        super(titel);
        ++frameCount;
        int WINDOW_FRAME = 1;
        int WINDOW_FULLSCREEN = 2;
        int WINDOW_FULLSCREEN_FRAME = 4;
        int windowMode = vollbild ? WINDOW_FULLSCREEN : WINDOW_FRAME;
        this.tabelle = new boolean[45];
        this.vollbild = vollbild;
        this.setSize(breite, hoehe);
        this.setResizable(false);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        Dimension screenSize = this.getToolkit().getScreenSize();
        if (vollbild) {
            if (devices[0].isFullScreenSupported()) {
                breite = screenSize.width;
                hoehe = screenSize.height;
            } else {
                Logger.error("Achtung!");
                Logger.error("Vollbild war nicht m\u00f6glich, weil dieser PC dies nicht unterst\u00fctzt!");
                windowMode = WINDOW_FULLSCREEN_FRAME;
            }
        } else {
            int x = screenSize.width / 8;
            int y = screenSize.height / 8;
            if (fensterX > -1 && fensterX < screenSize.width) {
                x = fensterX;
            }
            if (fensterY > -1 && fensterY < screenSize.height) {
                y = fensterY;
            }
            this.setLocation(x, y);
        }
        if (windowMode == WINDOW_FULLSCREEN) {
            this.setUndecorated(true);
            devices[0].setFullScreenWindow(this);
            boolean success = false;
            if (devices[0].isDisplayChangeSupported()) {
                DisplayMode[] displayMode = devices[0].getDisplayModes();
                Logger.info("DisplayModes: " + displayMode.length);
                for (int i = 0; i < displayMode.length; ++i) {
                    Logger.info(i + 1 + ": Breite: " + displayMode[i].getWidth() + ", H\u00f6he: " + displayMode[i].getHeight());
                    if (displayMode[i].getWidth() != breite || displayMode[i].getHeight() != hoehe) continue;
                    devices[0].setDisplayMode(new DisplayMode(breite, hoehe, displayMode[i].getBitDepth(), displayMode[i].getRefreshRate()));
                    Logger.info("SET!");
                    success = true;
                    break;
                }
                if (!success) {
                    Logger.error("Achtung!\nDie angegebene Aufl\u00f6sung wird von diesem Bildschirm nicht unterst\u00fctzt!\nNur besondere Aufl\u00f6sungen sind m\u00f6glich, z.B. 800 x 600.\nDiese sollten in der Konsole vor dieser Fehlerausgabe gelistet sein.");
                }
            } else {
                Logger.error("Dieser Bildschirm unterst\u00fctzt keine Aufl\u00f6sungs\u00e4nderung!");
            }
            if (!success) {
                Logger.error("Die gew\u00fcnschte Aufl\u00f6sung wird nicht vom Hauptbildschirm des Computers unterst\u00fctzt!");
            }
        } else if (windowMode == WINDOW_FULLSCREEN_FRAME) {
            this.setVisible(true);
            this.setBounds(env.getMaximumWindowBounds());
            this.setExtendedState(6);
            Insets insets = this.getInsets();
            breite = this.getWidth() - insets.left - insets.right;
            hoehe = this.getHeight() - insets.top - insets.bottom;
        } else {
            this.setVisible(true);
        }
        this.zeichner = new Zeichner(breite, hoehe, new Kamera(breite, hoehe, new Zeichenebene()));
        this.add(this.zeichner);
        this.zeichner.init();
        if ((windowMode & (WINDOW_FULLSCREEN_FRAME | WINDOW_FRAME)) > 0) {
            this.pack();
        }
        try {
            this.robot = new Robot(devices[0]);
        }
        catch (AWTException e) {
            Logger.error("Achtung!\nEs war nicht m\u00f6glich ein GUI-Controlobjekt zu erstelllen!\nZentrale Funktionen der Maus-Interaktion werden nicht funktionieren.\nGrund: Dies liegt an diesem Computer.");
        }
        this.addKeyListener();
        this.addMouseListener();
        this.addMouseMotionListener();
        this.addWindowListener(new Adapter(this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Fenster.this.loeschen();
            }
        });
        this.removeCursor();
        Manager.standard.anmelden(new Ticker(){
            private static final long serialVersionUID = -7552570027596373694L;

            @Override
            public void tick() {
                if (Fenster.this.hatMaus() && !Fenster.this.maus.absolut() && Fenster.this.maus.bewegend()) {
                    try {
                        BoundingRechteck r = Fenster.this.mausBild.dimension();
                        Punkt hs = Fenster.this.maus.hotSpot();
                        BoundingRechteck praeferenz = Fenster.this.mausPlatz();
                        Punkt p = new Punkt(r.x + hs.realX(), r.y + hs.realY());
                        if (!praeferenz.istIn(p) && Fenster.this.maus.bewegend()) {
                            Fenster.this.getCam().verschieben(new Vektor(praeferenz.zentrum(), p).teilen(20.0f));
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }, 50);
        instanz = this;
    }

    private void addKeyListener() {
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                Fenster.this.tastenAktion(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int i = Fenster.this.zuordnen(e.getKeyCode());
                if (i == -1) {
                    return;
                }
                ((Fenster)Fenster.this).tabelle[i] = false;
                for (TastenLosgelassenReagierbar l : Fenster.this.losListener) {
                    l.tasteLosgelassen(i);
                }
            }
        };
        this.addKeyListener(keyListener);
        this.zeichner.addKeyListener(keyListener);
    }

    private void addMouseListener() {
        this.zeichner.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Fenster.this.mausAktion(e, false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Fenster.this.mausAktion(e, true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (Fenster.this.hatMaus()) {
                    Point po = Fenster.this.getLocation();
                    int startX = Fenster.this.getWidth() / 2;
                    int startY = Fenster.this.getHeight() / 2;
                    Fenster.this.robot.mouseMove(startX + po.x, startY + po.y);
                }
                Fenster.this.zaehlt = false;
                Fenster.this.robot.mousePress(16);
                Fenster.this.robot.mouseRelease(16);
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void addMouseMotionListener() {
        this.zeichner.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Fenster.this.mausBewegung(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Fenster.this.mausBewegung(e);
            }
        });
    }

    public void loeschen() {
        this.zeichner.kill();
        this.setVisible(false);
        this.dispose();
        if (--frameCount == 0) {
            System.exit(0);
        }
    }

    private void removeCursor() {
        this.mausLoeschen();
    }

    public boolean hatMaus() {
        return this.maus != null;
    }

    private BoundingRechteck mausPlatz() {
        Dimension d = this.getSize();
        int x = d.width / 4 * 3;
        int y = d.height / 4 * 3;
        return new BoundingRechteck(d.width / 8, d.height / 8, x, y);
    }

    public Kamera getCam() {
        return this.zeichner.cam();
    }

    private void tastenAktion(KeyEvent e) {
        int z = this.zuordnen(e.getKeyCode());
        if (z == -1 || this.tabelle[z]) {
            return;
        }
        for (TastenReagierbar r : this.listener) {
            r.reagieren(z);
        }
        this.tabelle[z] = true;
    }

    @Deprecated
    public int zuordnen(int keyCode) {
        return Taste.vonJava(keyCode);
    }

    private void mausAktion(MouseEvent e, boolean losgelassen) {
        boolean links;
        if (!this.zaehlt) {
            this.zaehlt = true;
            return;
        }
        boolean bl = links = e.getButton() != 3;
        if (this.hatMaus()) {
            if (this.maus.absolut() || this.maus.bewegend()) {
                Punkt pu = this.maus.klickAufZeichenebene();
                this.maus.klick(pu, links, losgelassen);
            } else {
                this.maus.klick(this.maus.getImage().position().verschobeneInstanz(this.getCam().position().position().alsVektor()), links, losgelassen);
            }
        }
    }

    private void mausBewegung(MouseEvent e) {
        if (this.hatMaus()) {
            Insets insets = this.getInsets();
            float centerX = this.zeichner.getWidth() / 2;
            float centerY = this.zeichner.getHeight() / 2;
            Point windowLocation = this.getLocation();
            Point mousePosition = e.getPoint();
            if (this.maus.absolut()) {
                if (this.maus.bewegend()) {
                    Vektor offset = new Vektor((float)mousePosition.x - centerX, (float)mousePosition.y - centerY);
                    this.getCam().verschieben(offset);
                }
                if (this.lastMousePosition != null) {
                    this.maus.bewegt(new Vektor(mousePosition.x - this.lastMousePosition.x, mousePosition.y - this.lastMousePosition.y));
                }
            } else {
                float dx = (float)mousePosition.x - centerX;
                float dy = (float)mousePosition.y - centerY;
                BoundingRechteck bounds = this.mausBild.dimension();
                Punkt hotspot = this.maus.hotSpot();
                Punkt hotspotX = new Punkt(bounds.x + hotspot.realX() + dx, bounds.y + hotspot.realY());
                Punkt hotspotY = new Punkt(bounds.x + hotspot.realX(), bounds.y + hotspot.realY() + dy);
                if (!this.zeichner.masse().istIn(hotspotX)) {
                    dx = 0.0f;
                }
                if (!this.zeichner.masse().istIn(hotspotY)) {
                    dy = 0.0f;
                }
                Vektor bewegung = new Vektor(dx, dy);
                this.mausBild.verschieben(bewegung);
                this.maus.bewegt(bewegung);
            }
            this.robot.mouseMove((int)((float)(windowLocation.x + insets.left) + centerX), (int)((float)(windowLocation.y + insets.top) + centerY));
            this.lastMousePosition = new Point((int)centerX, (int)centerY);
        }
    }

    public void mausLoeschen() {
        this.setCursor(this.getToolkit().createCustomCursor(new BufferedImage(1, 1, 2), new Point(0, 0), "NOCURSOR"));
        this.maus = null;
    }

    public static FontMetrics metrik(Font f) {
        return instanz.getFontMetrics(f);
    }

    public static Fenster instanz() {
        return instanz;
    }

    public void minimieren() {
        this.setState(1);
    }

    public void maximieren() {
        this.setState(0);
    }

    public boolean vollbild() {
        return this.vollbild;
    }

    public void hintergrundAnmelden(Raum hintergrund) {
        this.zeichner.hintergrundAnmelden(hintergrund);
    }

    public void anmelden(TastenReagierbar t) {
        if (t == null) {
            throw new IllegalArgumentException("Listener darf nicht NULL sein.");
        }
        this.listener.add(t);
    }

    public void tastenLosgelassenReagierbarAnmelden(TastenLosgelassenReagierbar t) {
        this.tastenLosgelassenAnmelden(t);
    }

    public void tastenLosgelassenAnmelden(TastenLosgelassenReagierbar t) {
        if (t == null) {
            throw new IllegalArgumentException("Listener darf nicht NULL sein.");
        }
        this.losListener.add(t);
    }

    public void anmelden(Maus m) {
        if (this.hatMaus()) {
            Logger.error("Es ist bereits eine Maus angemeldet!");
        } else {
            this.maus = m;
            this.maus.fensterSetzen(this);
            BoundingRechteck r = this.maus.getImage().dimension();
            this.maus.getImage().positionSetzen(((float)this.getWidth() - r.breite) / 2.0f, ((float)this.getHeight() - r.hoehe) / 2.0f);
            this.mausBild = this.maus.getImage();
            this.zeichner.anmelden(this.mausBild);
        }
    }

    public boolean mausBewegt() {
        return this.hatMaus() && this.maus.bewegend();
    }

    public Knoten getStatNode() {
        return this.zeichner.statNode();
    }

    public Maus getMaus() {
        return this.maus;
    }

    public BoundingRechteck fenstermasse() {
        return this.zeichner.masse();
    }

    public Zeichner zeichner() {
        return this.zeichner;
    }

    public void removeSimple(SimpleGraphic g) {
        this.zeichner.removeSimple(g);
    }

    public void fillSimple(SimpleGraphic g) {
        this.zeichner.addSimple(g);
    }

    public Raum mausBild() {
        return this.mausBild;
    }

    public void druckAufheben() {
        for (int i = 0; i < this.tabelle.length; ++i) {
            this.tabelle[i] = false;
        }
    }

    public boolean istGedrueckt(int tastencode) {
        return this.tabelle[tastencode];
    }
}

