/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.gra;

import ea.AnimationsManager;
import ea.BoundingRechteck;
import ea.Kamera;
import ea.Knoten;
import ea.Raum;
import ea.SimpleGraphic;
import ea.Vektor;
import ea.internal.phy.Physik;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferStrategy;
import java.util.ArrayList;

public class Zeichner
extends Canvas
implements Runnable {
    public static final int UPDATE_INTERVALL = 40;
    private static final long serialVersionUID = 188647530006553893L;
    private final ArrayList<SimpleGraphic> simples = new ArrayList();
    private Kamera cam;
    private BoundingRechteck groesse;
    private Knoten statNode = new Knoten();
    private Raum hintergrund;
    private Raum vordergrund;
    private boolean work = true;
    private Thread thread;

    public Zeichner(int x, int y, Kamera c) {
        this.setSize(x, y);
        this.setPreferredSize(this.getSize());
        this.setFocusable(true);
        this.groesse = new BoundingRechteck(0.0f, 0.0f, x, y);
        this.cam = c;
    }

    public void init() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Zeichenthread"){
                {
                    this.setDaemon(true);
                }
            };
            this.thread.start();
        }
    }

    @Override
    public void run() {
        this.createBufferStrategy(2);
        BufferStrategy bs = this.getBufferStrategy();
        Graphics2D g = (Graphics2D)bs.getDrawGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        while (this.work) {
            this.render(g);
            bs.show();
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void render(Graphics2D g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, (int)this.groesse.breite, (int)this.groesse.hoehe);
        if (this.hintergrund != null) {
            this.hintergrund.zeichnenBasic(g, this.groesse.verschobeneInstanz(new Vektor(this.cam.getX() / 5, this.cam.getY() / 10)));
        }
        this.cam.zeichne(g);
        BoundingRechteck camBounds = this.cam.position();
        for (SimpleGraphic gr : this.simples) {
            gr.paint(g, (int)camBounds.x, (int)camBounds.y);
        }
        this.statNode.zeichnen(g, this.groesse);
        if (this.vordergrund != null) {
            this.vordergrund.zeichnen(g, this.groesse);
        }
    }

    public void kill() {
        this.work = false;
        try {
            this.thread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Physik.neutralize();
        AnimationsManager.neutralize();
    }

    public Kamera cam() {
        return this.cam;
    }

    public Knoten statNode() {
        return this.statNode;
    }

    public void anmelden(Raum vordergrund) {
        this.vordergrund = vordergrund;
    }

    public void hintergrundAnmelden(Raum hintergrund) {
        this.hintergrund = hintergrund;
    }

    void vordergrundLoeschen() {
        this.vordergrund = null;
    }

    public BoundingRechteck masse() {
        return this.groesse;
    }

    public void addSimple(SimpleGraphic g) {
        this.simples.add(g);
    }

    public void removeSimple(SimpleGraphic g) {
        this.simples.remove(g);
    }
}

