/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.gra;

import ea.BoundingRechteck;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public class PixelFeld
implements Serializable {
    private static final long serialVersionUID = 78L;
    private final Color[][] farbe;
    private transient BufferedImage cache;
    private transient boolean cacheOutdated;
    private Color alternativ = null;
    private int faktor;
    private boolean changed = true;
    private int pixel = 0;

    public PixelFeld(int grX, int grY, int faktor) {
        this.farbe = new Color[grX][grY];
        if (faktor <= 0) {
            throw new IllegalArgumentException("Der Eingabefaktor muss gr\u00f6\u00dfer als 0 sein. Deine Eingabe: " + faktor);
        }
        this.faktor = faktor;
        this.cacheOutdated = true;
    }

    public void faktorSetzen(int faktor) {
        if (faktor <= 0) {
            throw new IllegalArgumentException("Zoomfaktor muss gr\u00f6\u00dfer als 0 sein. Deine Eingabe: " + faktor);
        }
        this.faktor = faktor;
        this.cacheOutdated = true;
    }

    public int faktor() {
        return this.faktor;
    }

    public void angleichen(PixelFeld f) {
        if (f.hoeheN() == this.hoeheN() && f.breiteN() == this.breiteN()) {
            for (int i = 0; i < this.farbe.length; ++i) {
                System.arraycopy(f.farbe[i], 0, this.farbe[i], 0, this.farbe[0].length);
            }
        } else {
            throw new IllegalArgumentException("Achtung!\nDie beiden zum Angleich angef\u00fchrten PixelFelder haben unterschiedliche Masse in H\u00f6he und/oder Breite!");
        }
        this.cacheOutdated = true;
    }

    public int breiteN() {
        return this.farbe.length;
    }

    public int hoeheN() {
        return this.farbe[0].length;
    }

    public void negativ() {
        for (int i = 0; i < this.farbe.length; ++i) {
            for (int j = 0; j < this.farbe[0].length; ++j) {
                if (this.farbe[i][j] == null) continue;
                this.farbe[i][j] = new Color(255 - this.farbe[i][j].getRed(), 255 - this.farbe[i][j].getGreen(), 255 - this.farbe[i][j].getBlue(), this.farbe[i][j].getAlpha());
            }
        }
        this.cacheOutdated = true;
    }

    public void heller() {
        for (int i = 0; i < this.farbe.length; ++i) {
            for (int j = 0; j < this.farbe[0].length; ++j) {
                if (this.farbe[i][j] == null) continue;
                this.farbe[i][j] = this.farbe[i][j].brighter();
            }
        }
        this.cacheOutdated = true;
    }

    public void dunkler() {
        for (int i = 0; i < this.farbe.length; ++i) {
            for (int j = 0; j < this.farbe[0].length; ++j) {
                if (this.farbe[i][j] == null) continue;
                this.farbe[i][j] = this.farbe[i][j].darker();
            }
        }
        this.cacheOutdated = true;
    }

    public void transformieren(int r, int g, int b) {
        for (int i = 0; i < this.farbe.length; ++i) {
            for (int j = 0; j < this.farbe[0].length; ++j) {
                if (this.farbe[i][j] == null) continue;
                Color c = this.farbe[i][j];
                this.farbe[i][j] = new Color(PixelFeld.zahlenSumme(c.getRed(), r), PixelFeld.zahlenSumme(c.getGreen(), g), PixelFeld.zahlenSumme(c.getBlue(), b));
            }
        }
    }

    private static int zahlenSumme(int a, int b) {
        return Math.max(0, Math.min(255, a + b));
    }

    public void einfaerben(Color c) {
        this.alternativ = c;
    }

    public void zurueckFaerben() {
        this.alternativ = null;
    }

    public void zeichnen(Graphics2D g, int x, int y, boolean spiegelX, boolean spiegelY) {
        if (this.cache == null || this.cacheOutdated) {
            int width = this.farbe.length * this.faktor;
            int height = this.farbe.length == 0 ? 0 : this.farbe[0].length * this.faktor;
            this.cache = new BufferedImage(width, height, 2);
            Graphics2D cacheGraphics = this.cache.createGraphics();
            for (int i = 0; i < this.farbe.length; ++i) {
                for (int j = 0; j < this.farbe[i].length; ++j) {
                    Color c = this.farbe[i][j];
                    if (c == null) continue;
                    if (this.alternativ == null) {
                        cacheGraphics.setColor(c);
                    } else {
                        cacheGraphics.setColor(this.alternativ);
                    }
                    cacheGraphics.fillRect(i * this.faktor, j * this.faktor, this.faktor, this.faktor);
                }
            }
            cacheGraphics.dispose();
        }
        int w = this.breite();
        int h = this.hoehe();
        if (spiegelX && spiegelY) {
            g.drawImage(this.cache, x + w, y + h, x, y, 0, 0, w, h, null);
        } else if (spiegelX) {
            g.drawImage(this.cache, x + w, y, x, y + h, 0, 0, w, h, null);
        } else if (spiegelY) {
            g.drawImage(this.cache, x, y + h, x + w, y, 0, 0, w, h, null);
        } else {
            g.drawImage((Image)this.cache, x, y, null);
        }
    }

    public int breite() {
        return this.farbe.length * this.faktor;
    }

    public int hoehe() {
        return this.farbe[0].length * this.faktor;
    }

    public Color[][] getPic() {
        return this.farbe;
    }

    public PixelFeld erstelleKlon() {
        PixelFeld ret = new PixelFeld(this.farbe.length, this.farbe[0].length, this.faktor);
        for (int i = 0; i < this.farbe.length; ++i) {
            for (int j = 0; j < this.farbe[0].length; ++j) {
                ret.farbeSetzen(i, j, this.farbe[i][j]);
            }
        }
        return ret;
    }

    public void farbeSetzen(int x, int y, Color c) {
        this.farbe[x][y] = c;
        this.cacheOutdated = true;
    }

    public BoundingRechteck[] flaechen(float x, float y) {
        BoundingRechteck[] ret = new BoundingRechteck[this.anzahlPixel()];
        int cnt = 0;
        for (int i = 0; i < this.farbe.length; ++i) {
            for (int j = 0; j < this.farbe[0].length; ++j) {
                if (this.farbe[i][j] == null) continue;
                ret[cnt] = new BoundingRechteck(x + (float)(i * this.faktor), y + (float)(j * this.faktor), this.faktor, this.faktor);
                ++cnt;
            }
        }
        return ret;
    }

    public int anzahlPixel() {
        if (this.changed) {
            int neu = 0;
            for (int i = 0; i < this.farbe.length; ++i) {
                for (int j = 0; j < this.farbe[0].length; ++j) {
                    if (this.farbe[i][j] == null) continue;
                    ++neu;
                }
            }
            this.pixel = neu;
            this.changed = false;
        }
        return this.pixel;
    }
}

