/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.collision;

import ea.BoundingRechteck;
import ea.Farbe;
import ea.Punkt;
import ea.Raum;
import ea.Rechteck;
import ea.Vektor;
import ea.internal.collision.Collider;
import ea.internal.collision.ColliderGroup;
import ea.internal.collision.SphereCollider;

public class BoxCollider
extends Collider {
    Vektor diagonale;

    public BoxCollider() {
    }

    public BoxCollider(Vektor diagonale) {
        this(diagonale, Vektor.NULLVEKTOR);
    }

    public BoxCollider(Vektor diagonale, Vektor offset) {
        this.offset = offset;
        this.diagonale = diagonale;
    }

    public static BoxCollider fromBoundingRechteck(Vektor offset, BoundingRechteck br) {
        BoxCollider bc = new BoxCollider();
        bc.offsetSetzen(offset);
        bc.diagonale = new Vektor(br.breite, br.hoehe);
        return bc;
    }

    @Override
    public boolean verursachtCollision(Punkt positionThis, Punkt positionOther, Collider collider) {
        if (collider instanceof BoxCollider) {
            return Collider.boxboxCollision(this, (BoxCollider)collider, positionThis, positionOther);
        }
        if (collider instanceof SphereCollider) {
            return Collider.sphereboxCollision((SphereCollider)collider, this, positionOther, positionThis);
        }
        if (collider instanceof ColliderGroup) {
            return collider.verursachtCollision(positionOther, positionThis, this);
        }
        return false;
    }

    @Override
    public boolean istNullCollider() {
        return false;
    }

    @Override
    public Raum visualize(Punkt p, Farbe color) {
        Rechteck r = this.alsBR(p).ausDiesem();
        r.farbeSetzen(color);
        return r;
    }

    @Override
    public Collider clone() {
        return new BoxCollider(this.offset.clone(), this.diagonale.clone());
    }

    public BoundingRechteck alsBR(Punkt start) {
        return new BoundingRechteck(start.x + this.offset.x, start.y + this.offset.y, this.diagonale.x, this.diagonale.y);
    }
}

