/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.ani;

import ea.AnimationsEndeReagierbar;
import ea.Manager;
import ea.Punkt;
import ea.Raum;
import ea.Vektor;
import ea.internal.ani.Animierer;

public class StreckenAnimierer
extends Animierer {
    private final Punkt[] punkte;
    private Vektor vektor;
    private Vektor modulo;
    private int punkteCount;
    private boolean vorwaerts = true;
    private final int schritteProEtappe;
    private boolean circuit = true;

    public StreckenAnimierer(Raum ziel, boolean loop, Manager m, int geschwindigkeit, AnimationsEndeReagierbar listener, Punkt ... zielPunkte) {
        this(ziel, loop, loop, m, geschwindigkeit, listener, zielPunkte);
    }

    public StreckenAnimierer(Raum ziel, boolean loop, boolean circuit, Manager m, int geschwindigkeit, AnimationsEndeReagierbar listener, Punkt ... zielPunkte) {
        super(ziel, loop, m, listener);
        this.schritteProEtappe = geschwindigkeit / 5;
        this.circuit = circuit;
        this.punkte = new Punkt[zielPunkte.length + 1];
        this.punkte[0] = ziel.zentrum();
        System.arraycopy(zielPunkte, 0, this.punkte, 1, this.punkte.length - 1);
        this.punkteCount = 1;
        Punkt p2 = this.punkte[1];
        this.vektor = new Vektor((p2.realX() - this.punkte[0].realX()) / (float)this.schritteProEtappe, (p2.realY() - this.punkte[0].realY()) / (float)this.schritteProEtappe);
        this.modulo = new Vektor((p2.realX() - this.punkte[0].realX()) % (float)this.schritteProEtappe, (p2.realY() - this.punkte[0].realY()) % (float)this.schritteProEtappe);
    }

    public StreckenAnimierer(Raum ziel, Manager m, int geschwindigkeit, AnimationsEndeReagierbar listener, Punkt ... zielPunkte) {
        this(ziel, true, true, m, geschwindigkeit, listener, zielPunkte);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void animationsSchritt() {
        this.ziel.bewegen(this.vektor);
        if (this.count == this.schritteProEtappe) {
            Punkt p1 = this.punkte[this.punkteCount];
            Punkt p2 = null;
            if (this.punkteCount == this.punkte.length - 1 && this.vorwaerts) {
                if (!this.loop) {
                    this.beenden();
                    return;
                }
                if (this.circuit) {
                    this.punkteCount = 0;
                    p2 = this.punkte[this.punkteCount];
                } else {
                    this.vorwaerts = true;
                }
            } else if (this.punkteCount == 0 && !this.vorwaerts) {
                if (!this.loop) {
                    this.beenden();
                    return;
                }
                if (!this.circuit) {
                    this.vorwaerts = false;
                }
            }
            if (p2 == null) {
                this.punkteCount = !this.vorwaerts ? --this.punkteCount : ++this.punkteCount;
                p2 = this.punkte[this.punkteCount];
            }
            this.vektor = new Vektor((p2.realX() - p1.realX()) / (float)this.schritteProEtappe, (p2.realY() - p1.realY()) / (float)this.schritteProEtappe);
            this.modulo = new Vektor((p2.realX() - p1.realX()) % (float)this.schritteProEtappe, (p2.realY() - p1.realY()) % (float)this.schritteProEtappe);
            this.count = 0;
        }
    }
}

