/*
 * Decompiled with CFR 0.152.
 */
package ea.internal.ani;

import ea.AnimationsEndeReagierbar;
import ea.Gerade;
import ea.Manager;
import ea.Punkt;
import ea.Raum;
import ea.Vektor;
import ea.internal.ani.Animierer;

public class KreisAnimierer
extends Animierer {
    private final double winkelProAnimationsschritt;
    private final double radius;
    private final Punkt zentrum;
    private double winkel;
    private Punkt letzter;
    private boolean uhrzeigersinn;
    private int stepCount = 0;

    public KreisAnimierer(Raum ziel, Punkt zentrum, int umlaufzeit, boolean loop, Manager m, AnimationsEndeReagierbar listener, boolean uhrzeigersinn) {
        super(ziel, loop, m, listener);
        this.zentrum = zentrum;
        this.letzter = ziel.zentrum();
        this.uhrzeigersinn = uhrzeigersinn;
        this.winkelProAnimationsschritt = Math.PI * 2 / (double)(umlaufzeit / 5);
        Punkt zielMitte = ziel.zentrum();
        this.radius = zentrum.abstand(zielMitte);
        this.winkel = new Gerade(zielMitte, zentrum).winkel();
        if (zentrum.realX() < zielMitte.realX() && zentrum.realY() < zielMitte.realY()) {
            this.winkel = Math.PI - this.winkel;
        }
    }

    @Override
    public void animationsSchritt() {
        this.winkel = this.uhrzeigersinn ? (this.winkel += this.winkelProAnimationsschritt) : (this.winkel -= this.winkelProAnimationsschritt);
        float x = (float)(-Math.sin(this.winkel) * this.radius) + this.zentrum.realX();
        float y = (float)(Math.cos(this.winkel) * this.radius) + this.zentrum.realY();
        Vektor v = new Vektor(x - this.letzter.realX(), y - this.letzter.realY());
        this.ziel.bewegen(v);
        this.letzter = this.letzter.verschobenerPunkt(v);
        if (!this.loop && ++this.stepCount == 200) {
            super.anhalten();
        }
    }
}

