/*
 * Decompiled with CFR 0.152.
 */
package ea.edu.net;

import ea.Empfaenger;
import ea.NetzwerkVerbindung;
import ea.Server;
import ea.internal.util.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;

public class NetzwerkInterpreter
extends Thread {
    private final ArrayList<Empfaenger> outputListe = new ArrayList();
    private BufferedReader reader;
    private boolean connectionActive;
    private String remoteIP;
    private Server server;

    public NetzwerkInterpreter(String remoteIP, Server server, BufferedReader br) {
        this.remoteIP = remoteIP;
        this.server = server;
        this.reader = br;
        this.connectionActive = true;
        this.setDaemon(true);
        this.start();
    }

    public boolean verbindungAktiv() {
        return this.connectionActive;
    }

    public void empfaengerHinzufuegen(Empfaenger e) {
        this.outputListe.add(e);
    }

    @Override
    public void run() {
        while (!this.isInterrupted() && this.connectionActive) {
            try {
                String got = this.reader.readLine();
                if (got == null) {
                    this.connectionActive = false;
                    break;
                }
                this.process(got);
            }
            catch (IOException e) {
                Logger.error("Konnte nicht vom Kommunikationspartner einlesen.");
                this.connectionActive = false;
            }
        }
        try {
            this.reader.close();
        }
        catch (IOException e) {
            Logger.error("Konnte die Verbindung nicht schlie\u00dfen.");
        }
    }

    private void process(String raw) {
        String rest = raw.substring(1);
        if (this.server != null && this.server.isBroadcasting()) {
            switch (raw.charAt(0)) {
                case 'b': 
                case 'c': 
                case 'd': 
                case 'i': 
                case 'k': 
                case 's': {
                    for (NetzwerkVerbindung netzwerkVerbindung : this.server.getVerbindungen()) {
                        if (netzwerkVerbindung.getRemoteIP().equals(this.remoteIP)) continue;
                        netzwerkVerbindung.sende(raw);
                    }
                    break;
                }
            }
        }
        block3 : switch (raw.charAt(0)) {
            case 's': {
                for (Empfaenger empfaenger : this.outputListe) {
                    empfaenger.empfangeString(rest);
                }
                break;
            }
            case 'i': {
                int i = Integer.parseInt(rest);
                for (Empfaenger e : this.outputListe) {
                    e.empfangeInt(i);
                }
                break;
            }
            case 'b': {
                byte by = Byte.parseByte(rest);
                for (Empfaenger e : this.outputListe) {
                    e.empfangeByte(by);
                }
                break;
            }
            case 'd': {
                double d = Double.parseDouble(rest);
                for (Empfaenger e : this.outputListe) {
                    e.empfangeDouble(d);
                }
                break;
            }
            case 'c': {
                char c = rest.charAt(0);
                for (Empfaenger e : this.outputListe) {
                    e.empfangeChar(c);
                }
                break;
            }
            case 'k': {
                boolean bo = Boolean.parseBoolean(rest);
                for (Empfaenger e : this.outputListe) {
                    e.empfangeBoolean(bo);
                }
                break;
            }
            case 'x': {
                switch (rest.charAt(0)) {
                    case 'q': {
                        this.quitCommunication();
                        break block3;
                    }
                }
            }
        }
    }

    public void quitCommunication() {
        for (Empfaenger e : this.outputListe) {
            e.verbindungBeendet();
        }
        try {
            this.reader.close();
        }
        catch (IOException e1) {
            Logger.error("Konnte den Kommunikationskanal nicht mehr schlie\u00dfen.");
        }
        this.connectionActive = false;
    }
}

