/*
 * Decompiled with CFR 0.152.
 */
package ea.edu;

import ea.API;
import ea.Bild;
import ea.Maus;
import ea.Punkt;
import ea.edu.AnzeigeE;
import ea.edu.FensterE;
import ea.internal.util.Logger;

public class SPIEL {
    private AnzeigeE anzeige;
    private boolean tick = false;

    @API
    public SPIEL() {
        this(808, 629, false, false, false);
    }

    @API
    public SPIEL(int breite, int hoehe, boolean punkteLinks, boolean punkteRechts, boolean maus) {
        this(breite, hoehe, punkteLinks, punkteRechts, maus, true);
    }

    @API
    public SPIEL(int breite, int hoehe, boolean punkteLinks, boolean punkteRechts, boolean maus, boolean tickerAnmelden) {
        this.anzeige = new AnzeigeE(breite, hoehe);
        this.anzeige.punkteLinksSichtbarSetzen(punkteLinks);
        this.anzeige.punkteRechtsSichtbarSetzen(punkteRechts);
        if (maus) {
            this.anzeige.klickReagierbarAnmelden(this, true);
        }
        this.anzeige.tastenReagierbarAnmelden(this);
        if (tickerAnmelden) {
            this.anzeige.tickerAnmelden(this, 500);
        }
    }

    public void tick() {
        this.tick = !this.tick;
        Logger.info(this.tick ? "Tick!" : "Tack!");
    }

    public void klickReagieren(int x, int y) {
        Logger.info("Klick bei (" + x + ", " + y + ").");
    }

    public void tasteReagieren(int tastenkuerzel) {
        Logger.info("Taste mit Kuerzel " + tastenkuerzel + " wurde gedrueckt");
    }

    @API
    public void tickerIntervallSetzen(int ms) {
        this.anzeige.tickerAbmelden(this);
        this.anzeige.tickerAnmelden(this, ms);
    }

    @API
    public void tickerStoppen() {
        this.anzeige.tickerAbmelden(this);
    }

    @API
    public void tickerNeuStarten(int ms) {
        this.anzeige.tickerAbmelden(this);
        this.anzeige.tickerAnmelden(this, ms);
    }

    @API
    public void tickerStarten() {
        this.tickerStarten(500);
    }

    @API
    public void tickerStarten(int ms) {
        this.anzeige.tickerAnmelden(this, ms);
    }

    @API
    public void mausIconSetzen(String pfad, int hotspotX, int hotspotY) {
        FensterE.getFenster().mausAnmelden(new Maus(new Bild(0.0f, 0.0f, pfad), new Punkt(hotspotX, hotspotY)), true);
    }

    @API
    public void allePunkteSichtbar() {
        this.anzeige.punkteLinksSichtbarSetzen(true);
        this.anzeige.punkteRechtsSichtbarSetzen(true);
    }

    @API
    public void nurRechtePunkteSichtbar() {
        this.anzeige.punkteLinksSichtbarSetzen(false);
        this.anzeige.punkteRechtsSichtbarSetzen(true);
    }

    @API
    public void nurLinkePunkteSichtbar() {
        this.anzeige.punkteLinksSichtbarSetzen(true);
        this.anzeige.punkteRechtsSichtbarSetzen(false);
    }

    @API
    public void allePunkteUnsichtbar() {
        this.anzeige.punkteLinksSichtbarSetzen(false);
        this.anzeige.punkteRechtsSichtbarSetzen(false);
    }

    @API
    public void punkteLinksSetzen(int pl) {
        this.anzeige.punkteLinksSetzen(pl);
    }

    @API
    public void punkteRechtsSetzen(int pr) {
        this.anzeige.punkteRechtsSetzen(pr);
    }

    public void setzeFarbePunktestand(String farbe) {
        this.anzeige.setzeFarbePunktestand(farbe);
    }

    @API
    public int zufallszahlVonBis(int von, int bis) {
        return this.anzeige.zufallszahlVonBis(von, bis);
    }

    @API
    public void hintergrundgrafikSetzen(String pfad) {
        FensterE.getFenster().hintergrundSetzen(new Bild(0.0f, 0.0f, pfad));
    }
}

