/*
 * Decompiled with CFR 0.152.
 */
package ea.edu;

import ea.EngineAlpha;
import ea.KlickReagierbar;
import ea.Manager;
import ea.Maus;
import ea.Punkt;
import ea.Raum;
import ea.RechtsKlickReagierbar;
import ea.TastenReagierbar;
import ea.Text;
import ea.Ticker;
import ea.edu.FensterE;
import ea.internal.util.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Random;

public class AnzeigeE
extends Manager
implements Ticker,
TastenReagierbar,
KlickReagierbar,
RechtsKlickReagierbar {
    private static final long serialVersionUID = 3387123025090347796L;
    private final Text links;
    private final Text rechts;
    private final Text strich;
    private final ArrayList<Auftrag> aufgabenT;
    private final ArrayList<TastenAuftrag> aufgaben;
    private final ArrayList<KlickAuftrag> aufgabenKlick;
    private final Random random = new Random();
    private int runde = 0;
    private Maus maus;

    public AnzeigeE(int breite, int hoehe) {
        this.links = new Text(0.0f, 10.0f, "0");
        this.rechts = new Text(0.0f, 10.0f, "0");
        this.aufgaben = new ArrayList();
        this.aufgabenT = new ArrayList();
        this.aufgabenKlick = new ArrayList();
        Raum[] raumArray = new Raum[3];
        raumArray[0] = this.links;
        raumArray[1] = this.rechts;
        this.strich = new Text(0.0f, 10.0f, "-");
        raumArray[2] = this.strich;
        FensterE.getFenster((int)breite, (int)hoehe).wurzel.add(raumArray);
        FensterE.getFenster(breite, hoehe).tastenReagierbarAnmelden(this);
        super.anmelden(this, 1);
        this.punkteAnzeigen(false);
        this.punkteAlignen();
    }

    public static boolean frage(String text) {
        return FensterE.getFenster().frage(text);
    }

    public static String eingabeFordern(String nachricht) {
        return FensterE.getFenster().eingabeFordern(nachricht);
    }

    public static void nachrichtDialog(String nachricht) {
        FensterE.getFenster().nachrichtSchicken(nachricht);
    }

    public static void highscoreAnzeigen(String[] namen, int[] punkte, String festertitel) {
        FensterE.getFenster().highscoreAnzeigen(namen, punkte, festertitel);
    }

    public void rasterSichtbarSetzen(boolean sichtbar) {
        EngineAlpha.setDebug(sichtbar);
    }

    public void punkteAnzeigen(boolean visible) {
        this.rechts.sichtbarSetzen(visible);
        this.links.sichtbarSetzen(visible);
        this.strich.sichtbarSetzen(visible);
    }

    private void punkteAlignen() {
        float lLinks = this.links.dimension().breite;
        float lRechts = this.rechts.dimension().breite;
        float lStrich = this.strich.dimension().breite;
        float groesser = lLinks > lRechts ? lLinks : lRechts;
        float breite = FensterE.getFenster().fensterGroesse().breite;
        this.strich.positionSetzen((breite - lStrich) / 2.0f, 10.0f);
        this.links.positionSetzen((breite - lStrich) / 2.0f - groesser - 5.0f, 10.0f);
        this.rechts.positionSetzen((breite + lStrich) / 2.0f + 5.0f, 10.0f);
    }

    public void setzeFarbePunktestand(String farbe) {
        this.links.setzeFarbe(farbe);
        this.rechts.setzeFarbe(farbe);
        this.strich.setzeFarbe(farbe);
    }

    public Maus getMaus() {
        return this.maus;
    }

    public int zufallszahlVonBis(int von, int bis) {
        if (von > bis) {
            Logger.error("Die Zufallszahl von (" + von + ") war gr\u00f6\u00dfer als die Zufallszahl bis (" + bis + ").");
            return -1;
        }
        return this.random.nextInt(bis - von + 1) + von;
    }

    public void punkteLinksSetzen(int punkte) {
        this.links.inhaltSetzen("" + punkte);
        this.punkteAlignen();
    }

    public void punkteLinksSichtbarSetzen(boolean sichtbar) {
        this.links.sichtbarSetzen(sichtbar);
        this.strich.sichtbarSetzen(this.links.sichtbar() && this.rechts.sichtbar());
    }

    public void punkteRechtsSetzen(int punkte) {
        this.rechts.inhaltSetzen("" + punkte);
        this.punkteAlignen();
    }

    public void punkteRechtsSichtbarSetzen(boolean sichtbar) {
        this.rechts.sichtbarSetzen(sichtbar);
        this.strich.sichtbarSetzen(this.links.sichtbar() && this.rechts.sichtbar());
    }

    public void tickerAnmelden(Object o, int intervall) {
        Class<?> klasse = o.getClass();
        Method[] methoden = klasse.getMethods();
        for (int i = 0; i < methoden.length; ++i) {
            if (!methoden[i].getName().equals("tick")) continue;
            this.aufgabenT.add(new Auftrag(o, methoden[i], intervall));
            return;
        }
    }

    public void tickerAbmelden(Object o) {
        for (int i = this.aufgabenT.size() - 1; i >= 0; --i) {
            if (!this.aufgabenT.get(i).client().equals(o)) continue;
            this.aufgabenT.remove(i);
            return;
        }
    }

    public void tastenReagierbarAnmelden(Object o) {
        Class<?> klasse = o.getClass();
        Method[] methoden = klasse.getMethods();
        for (int i = 0; i < methoden.length; ++i) {
            if (!methoden[i].getName().equals("tasteReagieren")) continue;
            this.aufgaben.add(new TastenAuftrag(o, methoden[i]));
            return;
        }
    }

    public void klickReagierbarAnmelden(Object client, boolean linksklick) {
        if (this.maus == null) {
            this.maus = new Maus(1);
            FensterE.getFenster().mausAnmelden(this.maus);
            this.maus.klickReagierbarAnmelden(this);
        }
        Class<?> klasse = client.getClass();
        Method[] methoden = klasse.getMethods();
        for (int i = 0; i < methoden.length; ++i) {
            if (!methoden[i].getName().equals("klickReagieren")) continue;
            this.aufgabenKlick.add(new KlickAuftrag(client, methoden[i], linksklick));
            return;
        }
    }

    @Override
    public void klickReagieren(Punkt punkt) {
        this.klickSub(punkt.x(), punkt.y(), true);
    }

    private void klickSub(int x, int y, boolean links) {
        for (KlickAuftrag a : this.aufgabenKlick) {
            if (a.linksklick != links) continue;
            a.ausfuehren(x, y);
        }
    }

    @Override
    public void rechtsKlickReagieren(Punkt punkt) {
        this.klickSub(punkt.x(), punkt.y(), false);
    }

    @Override
    public void reagieren(int code) {
        for (TastenAuftrag t : this.aufgaben) {
            t.ausfuehren(code);
        }
    }

    @Override
    public void tick() {
        try {
            for (Auftrag a : this.aufgabenT) {
                if (this.runde % a.intervall() != 0) continue;
                a.ausfuehren();
            }
            ++this.runde;
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    private final class KlickAuftrag {
        private final Method methode;
        private final Object client;
        private final boolean linksklick;

        private KlickAuftrag(Object c, Method m, boolean linksklick) {
            this.methode = m;
            this.client = c;
            this.linksklick = linksklick;
        }

        private void ausfuehren(int x, int y) {
            try {
                this.methode.invoke(this.client, x, y);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private final class TastenAuftrag {
        private final Method methode;
        private final Object client;

        public TastenAuftrag(Object client, Method m) {
            this.client = client;
            this.methode = m;
        }

        public void ausfuehren(int code) {
            try {
                this.methode.invoke(this.client, code);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private final class Auftrag {
        private final int intervall;
        private final Object client;
        private final Method methode;

        public Auftrag(Object client, Method tick, int intervall) {
            this.intervall = intervall;
            this.client = client;
            this.methode = tick;
        }

        public final void ausfuehren() {
            try {
                this.methode.invoke(this.client, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }

        public int intervall() {
            return this.intervall;
        }

        public Object client() {
            return this.client;
        }
    }
}

