/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.API;
import ea.Punkt;

public final class Vektor
implements Cloneable {
    public static final Vektor NULLVEKTOR = new Vektor(0.0f, 0.0f);
    public static final Vektor RECHTS = new Vektor(1.0f, 0.0f);
    public static final Vektor LINKS = new Vektor(-1.0f, 0.0f);
    public static final Vektor OBEN = new Vektor(0.0f, -1.0f);
    public static final Vektor UNTEN = new Vektor(0.0f, 1.0f);
    public static final int KEINE_BEWEGUNG = -1;
    public static final int W = 0;
    public static final int O = 1;
    public static final int N = 2;
    public static final int S = 3;
    public static final int NW = 4;
    public static final int NO = 5;
    public static final int SW = 6;
    public static final int SO = 7;
    public final float x;
    public final float y;

    public Vektor(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vektor(Punkt start, Punkt ziel) {
        this.x = ziel.x - start.x;
        this.y = ziel.y - start.y;
    }

    public Vektor normiert() {
        return this.teilen(this.laenge());
    }

    public Vektor teilen(float divisor) {
        if (divisor == 0.0f) {
            throw new ArithmeticException("Der Divisor f\u00fcr das Teilen war 0!");
        }
        return new Vektor(this.x / divisor, this.y / divisor);
    }

    public float laenge() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vektor gegenrichtung() {
        return new Vektor(-this.x, -this.y);
    }

    public Vektor summe(Vektor v) {
        return new Vektor(this.x + v.x, this.y + v.y);
    }

    public Vektor differenz(Vektor v) {
        return new Vektor(this.x - v.x, this.y - v.y);
    }

    public Vektor multiplizieren(float faktor) {
        return new Vektor(this.x * faktor, this.y * faktor);
    }

    public float skalarprodukt(Vektor v) {
        return this.x * v.x + this.y * v.y;
    }

    public boolean unwirksam() {
        return this.x == 0.0f && this.y == 0.0f;
    }

    public boolean istEchtGanzzahlig() {
        return this.x == (float)((int)this.x) && this.y == (float)((int)this.y);
    }

    public float realX() {
        return this.x;
    }

    public float realY() {
        return this.y;
    }

    public Vektor einfacher() {
        return Vektor.vonKonstante(this.richtung());
    }

    public static Vektor vonKonstante(int konstante) {
        switch (konstante) {
            case 2: {
                return OBEN;
            }
            case 3: {
                return UNTEN;
            }
            case 1: {
                return RECHTS;
            }
            case 0: {
                return LINKS;
            }
            case 5: {
                return new Vektor(1.0f, -1.0f);
            }
            case 4: {
                return new Vektor(-1.0f, -1.0f);
            }
            case 7: {
                return new Vektor(1.0f, 1.0f);
            }
            case 6: {
                return new Vektor(-1.0f, 1.0f);
            }
        }
        throw new IllegalArgumentException("Die eingegebene Konstante hatte keinen der m\u00f6glichen Werte!");
    }

    public int richtung() {
        if (this.x == 0.0f && this.y == 0.0f) {
            return -1;
        }
        if (this.x == 0.0f) {
            return this.y > 0.0f ? 3 : 2;
        }
        if (this.y == 0.0f) {
            return this.x > 0.0f ? 1 : 0;
        }
        if (this.x < 0.0f && this.y < 0.0f) {
            return 4;
        }
        if (this.x > 0.0f && this.y < 0.0f) {
            return 5;
        }
        if (this.x > 0.0f && this.y > 0.0f) {
            return 7;
        }
        return 6;
    }

    public boolean equals(Object o) {
        if (o instanceof Vektor) {
            Vektor v = (Vektor)o;
            return this.x == v.x && this.y == v.y;
        }
        return false;
    }

    public Vektor clone() {
        return new Vektor(this.x, this.y);
    }

    public String toString() {
        return "ea.Vektor [x = " + this.x + "; y = " + this.y + "]";
    }

    public int dX() {
        return (int)this.x;
    }

    public int dY() {
        return (int)this.y;
    }

    @API
    public Punkt alsPunkt() {
        return new Punkt(this.x, this.y);
    }

    public float manhattanLength() {
        float v = this.x + this.y;
        return v < 0.0f ? -v : v;
    }
}

