/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.internal.sound.SampledSound;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Sound {
    private byte[] data;
    private SampledSound ss;

    public Sound(String datei) {
        try {
            this.data = Sound.loadFromStream(new FileInputStream(datei));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFromStream(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            int n;
            byte[] bytes = new byte[is.available()];
            for (int off = 0; off < bytes.length && (n = is.read(bytes, off, bytes.length - off)) >= 0; off += n) {
            }
            is.close();
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void play() {
        if (this.ss != null) {
            this.ss.stopSound();
            try {
                this.ss.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.ss = null;
        }
        if (this.data != null) {
            this.ss = new SampledSound(this.data, false);
            this.ss.start();
        }
    }

    public void loop() {
        if (this.ss != null) {
            this.ss.stopSound();
            try {
                this.ss.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.ss = null;
        }
        if (this.data != null) {
            this.ss = new SampledSound(this.data, true);
            this.ss.start();
        }
    }

    public void pause() {
        if (this.ss == null) {
            return;
        }
        this.ss.pauseSound(true);
    }

    public void unpause() {
        if (this.ss == null) {
            return;
        }
        this.ss.pauseSound(false);
    }

    public void stop() {
        if (this.ss == null) {
            return;
        }
        this.ss.stopSound();
    }
}

