/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.SenderInterface;
import ea.internal.util.Logger;
import java.io.BufferedWriter;
import java.io.IOException;

public class Sender
implements SenderInterface {
    private final BufferedWriter writer;
    private boolean active;

    public Sender(BufferedWriter bw) {
        this.writer = bw;
        this.active = true;
    }

    public boolean verbindungAktiv() {
        return this.active;
    }

    @Override
    public void sendeString(String s) {
        this.sende("s" + s);
    }

    public boolean sende(String s) {
        if (!this.active) {
            Logger.error("Kann nach dem Schlie\u00dfen nicht mehr senden.");
            return false;
        }
        try {
            this.writer.write(s);
            this.writer.newLine();
            this.writer.flush();
        }
        catch (IOException e) {
            Logger.error("Es gab einen internen Fehler beim Schreiben.");
            return false;
        }
        return true;
    }

    @Override
    public void sendeInt(int i) {
        this.sende("i" + Integer.toString(i));
    }

    @Override
    public void sendeByte(byte b) {
        this.sende("b" + Byte.toString(b));
    }

    @Override
    public void sendeDouble(double d) {
        this.sende("d" + Double.toString(d));
    }

    @Override
    public void sendeChar(char c) {
        this.sende("c" + Character.toString(c));
    }

    @Override
    public void sendeBoolean(boolean b) {
        this.sende("k" + Boolean.toString(b));
    }

    @Override
    public void beendeVerbindung() {
        if (!this.sende("xq")) {
            return;
        }
        this.active = false;
        try {
            this.writer.close();
        }
        catch (IOException e) {
            Logger.error("Konnte die Verbindung nicht schlie\u00dfen.");
        }
    }
}

