/*
 * Decompiled with CFR 0.152.
 */
package ea;

import ea.API;
import ea.Vektor;

public final class Punkt {
    public static final Punkt ZENTRUM = new Punkt(0.0f, 0.0f);
    public final float x;
    public final float y;

    public Punkt(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public float abstand(Punkt p) {
        double x = this.x - p.x;
        double y = this.y - p.y;
        return (float)Math.sqrt(x * x + y * y);
    }

    public Punkt verschobeneInstanz(Vektor v) {
        return this.verschobenerPunkt(v);
    }

    public Punkt verschobenerPunkt(Vektor v) {
        return new Punkt(this.x + v.x, this.y + v.y);
    }

    @API
    public Vektor alsVektor() {
        return new Vektor(this.x, this.y);
    }

    public boolean equals(Object o) {
        if (o instanceof Punkt) {
            Punkt p = (Punkt)o;
            return this.x == p.x && this.y == p.y;
        }
        return false;
    }

    public String toString() {
        return "Punkt: (" + this.x + "|" + this.y + ")";
    }

    public Vektor nach(Punkt p2) {
        return new Vektor(p2.x - this.x, p2.y - this.y);
    }

    public boolean istEchtGanzzahlig() {
        return this.x == (float)((int)this.x) && this.y == (float)((int)this.y);
    }

    public float realX() {
        return this.x;
    }

    public float realY() {
        return this.y;
    }

    public int x() {
        return (int)this.x;
    }

    public int y() {
        return (int)this.y;
    }
}

